/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_0;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThread;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBProcesses_7_1
extends GDBProcesses_7_0 {
    private CommandFactory fCommandFactory;
    private CommandCache fCommandForCoresCache;
    private IGDBControl fCommandControl;

    public GDBProcesses_7_1(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBProcesses_7_1.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fCommandForCoresCache = new CommandCache(this.getSession(), (ICommandControl)new BufferedCommandControl((ICommandControl)this.fCommandControl, this.getExecutor(), 2));
        this.fCommandForCoresCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    @Override
    public void getExecutionData(final IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IMIProcessDMContext) {
            super.getExecutionData(dmc, (DataRequestMonitor<IProcesses.IThreadDMData>)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(rm){

                protected void handleSuccess() {
                    final IProcesses.IThreadDMData firstLevelData = (IProcesses.IThreadDMData)this.getData();
                    ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
                    final String groupId = GDBProcesses_7_1.this.getGroupFromPid(((IMIProcessDMContext)dmc).getProcId());
                    GDBProcesses_7_1.this.fCommandForCoresCache.execute(GDBProcesses_7_1.this.fCommandFactory.createMIListThreadGroups(controlDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIListThreadGroupsInfo>((RequestMonitor)rm){

                        protected void handleCompleted() {
                            MIListThreadGroupsInfo.IThreadGroupInfo[] groups;
                            String[] cores = null;
                            if (this.isSuccess() && (groups = ((MIListThreadGroupsInfo)this.getData()).getGroupList()) != null) {
                                MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = groups;
                                int n = groups.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MIListThreadGroupsInfo.IThreadGroupInfo group = iThreadGroupInfoArray[n2];
                                    if (group.getGroupId().equals(groupId)) {
                                        cores = group.getCores();
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            rm.setData((Object)new MIThreadDMData_7_1(firstLevelData.getName(), firstLevelData.getId(), cores));
                            rm.done();
                        }
                    });
                }
            });
        } else if (dmc instanceof GDBProcesses_7_0.MIThreadDMC) {
            final GDBProcesses_7_0.MIThreadDMC threadDmc = (GDBProcesses_7_0.MIThreadDMC)dmc;
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
            this.fCommandForCoresCache.execute(this.fCommandFactory.createMIThreadInfo(controlDmc, threadDmc.getId()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIThreadInfoInfo>(rm){

                protected void handleSuccess() {
                    MIThread thread;
                    MIThreadDMData_7_1 threadData = null;
                    if (((MIThreadInfoInfo)this.getData()).getThreadList().length != 0 && (thread = ((MIThreadInfoInfo)this.getData()).getThreadList()[0]).getThreadId().equals(threadDmc.getId())) {
                        String[] stringArray;
                        String core;
                        String id = thread.getOsId();
                        String details = thread.getDetails();
                        if (details != null && details.length() > 0) {
                            id = String.valueOf(id) + " (" + details + ")";
                        }
                        if ((core = thread.getCore()) == null) {
                            stringArray = null;
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = core;
                        }
                        threadData = new MIThreadDMData_7_1("", id, stringArray);
                    }
                    if (threadData != null) {
                        rm.setData(threadData);
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Could not get thread info", null));
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched_7_1(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fCommandForCoresCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched_7_1(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fCommandForCoresCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        }
        this.fCommandForCoresCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched_7_1(IRunControl.IStartedDMEvent e) {
        this.fCommandForCoresCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched_7_1(IRunControl.IExitedDMEvent e) {
        this.fCommandForCoresCache.reset();
    }

    @Override
    public void flushCache(IDMContext context) {
        this.fCommandForCoresCache.reset(context);
        super.flushCache(context);
    }

    @Immutable
    protected static class MIThreadDMData_7_1
    extends GDBProcesses_7_0.MIThreadDMData
    implements IGDBProcesses.IGdbThreadDMData {
        final String[] fCores;

        public MIThreadDMData_7_1(String name, String id, String[] cores) {
            super(name, id);
            this.fCores = cores;
        }

        @Override
        public String[] getCores() {
            return this.fCores;
        }

        @Override
        public String getOwner() {
            return null;
        }
    }
}

