/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class MouseMonitor {
    public static final int LEFT_BUTTON = 1;
    public static final int MIDDLE_BUTTON = 2;
    public static final int RIGHT_BUTTON = 3;
    public static final int MOUSE_DRAG_BEGIN = 0;
    public static final int MOUSE_DRAG = 1;
    public static final int MOUSE_DRAG_END = 2;
    public static final int MOUSE_DRAG_HYSTERESIS = 4;
    protected Control m_control = null;
    protected MouseListener m_mouseButtonListener = null;
    protected MouseMoveListener m_mouseMoveListener = null;
    protected MouseTrackListener m_mouseTrackListener = null;
    protected boolean m_mouseDown = false;
    protected boolean m_mouseDrag = false;
    protected Point m_mouseDownPoint = new Point(0, 0);
    protected int m_mouseDownButton = 0;
    protected Point m_dragPoint = new Point(0, 0);
    protected Rectangle m_dragRegion = new Rectangle(0, 0, 0, 0);

    public MouseMonitor() {
    }

    public MouseMonitor(Control control) {
        this();
        this.m_control = control;
        this.attach(this.m_control);
    }

    public void dispose() {
        this.detach(this.m_control);
    }

    protected void attach(Control control) {
        this.detach(this.m_control);
        this.m_mouseButtonListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
                MouseMonitor.this.mouseDownHandler(e.button, e.x, e.y, e.stateMask);
            }

            public void mouseUp(MouseEvent e) {
                MouseMonitor.this.mouseUpHandler(e.button, e.x, e.y, e.stateMask);
            }

            public void mouseDoubleClick(MouseEvent e) {
                MouseMonitor.this.mouseDoubleClickHandler(e.button, e.x, e.y, e.stateMask);
            }
        };
        control.addMouseListener(this.m_mouseButtonListener);
        this.m_mouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                MouseMonitor.this.mouseMoveHandler(e.x, e.y, e.stateMask);
            }
        };
        control.addMouseMoveListener(this.m_mouseMoveListener);
        this.m_mouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                MouseMonitor.this.mouseEnterHandler(e.x, e.y);
            }

            public void mouseExit(MouseEvent e) {
                MouseMonitor.this.mouseExitHandler(e.x, e.y);
            }

            public void mouseHover(MouseEvent e) {
                MouseMonitor.this.mouseHoverHandler(e.x, e.y);
            }
        };
        control.addMouseTrackListener(this.m_mouseTrackListener);
    }

    protected void detach(Control control) {
        if (control == null) {
            return;
        }
        if (this.m_control != null) {
            if (this.m_mouseButtonListener != null) {
                this.m_control.removeMouseListener(this.m_mouseButtonListener);
                this.m_mouseButtonListener = null;
            }
            if (this.m_mouseMoveListener != null) {
                this.m_control.removeMouseMoveListener(this.m_mouseMoveListener);
                this.m_mouseMoveListener = null;
            }
            if (this.m_mouseTrackListener != null) {
                this.m_control.removeMouseTrackListener(this.m_mouseTrackListener);
                this.m_mouseTrackListener = null;
            }
        }
    }

    public Control getControl() {
        return this.m_control;
    }

    public void setControl(Control control) {
        this.detach(this.m_control);
        this.m_control = control;
        this.attach(this.m_control);
    }

    public Point getMouseDownPoint() {
        return this.m_mouseDownPoint;
    }

    public Point getDragPoint() {
        return this.m_dragPoint;
    }

    public Rectangle getDragRegion() {
        return this.m_dragRegion;
    }

    public static boolean isShiftDown(int keys) {
        return (keys & 0x20000) != 0;
    }

    public static boolean isControlDown(int keys) {
        return (keys & 0x40000) != 0;
    }

    public static boolean isAltDown(int keys) {
        return (keys & 0x10000) != 0;
    }

    protected void setDragPoint(int x, int y) {
        this.m_dragPoint.x = x;
        this.m_dragPoint.y = y;
    }

    protected void setDragRegion(int x, int y, int width, int height) {
        this.m_dragRegion.x = x;
        this.m_dragRegion.y = y;
        this.m_dragRegion.width = width;
        this.m_dragRegion.height = height;
    }

    protected void setDragRegionFromPoints(int x1, int y1, int x2, int y2) {
        if (x1 < x2) {
            this.m_dragRegion.x = x1;
            this.m_dragRegion.width = x2 - x1;
        } else {
            this.m_dragRegion.x = x2;
            this.m_dragRegion.width = x1 - x2;
        }
        if (y1 < y2) {
            this.m_dragRegion.y = y1;
            this.m_dragRegion.height = y2 - y1;
        } else {
            this.m_dragRegion.y = y2;
            this.m_dragRegion.height = y1 - y2;
        }
    }

    protected void mouseDownHandler(int button, int x, int y, int keys) {
        if (!this.m_mouseDown) {
            this.m_mouseDown = true;
            this.m_mouseDownPoint.x = x;
            this.m_mouseDownPoint.y = y;
            this.m_mouseDownButton = button;
            this.setDragPoint(x, y);
            this.setDragRegion(x, y, 0, 0);
        }
        this.mouseDown(button, x, y, keys);
    }

    protected void mouseMoveHandler(int x, int y, int keys) {
        if (this.m_mouseDown) {
            int distance;
            if (!this.m_mouseDrag && (distance = Math.abs(x - this.m_mouseDownPoint.x) + Math.abs(y - this.m_mouseDownPoint.y)) > 4) {
                this.m_mouseDrag = true;
                this.drag(this.m_mouseDownButton, this.m_mouseDownPoint.x, this.m_mouseDownPoint.y, keys, 0);
            }
            if (this.m_mouseDrag) {
                int dx = x - this.m_mouseDownPoint.x;
                int dy = y - this.m_mouseDownPoint.y;
                this.setDragPoint(x, y);
                this.setDragRegionFromPoints(this.m_mouseDownPoint.x, this.m_mouseDownPoint.y, x, y);
                this.drag(this.m_mouseDownButton, dx, dy, keys, 1);
            }
        }
        this.mouseMove(x, y, keys);
    }

    protected void mouseUpHandler(int button, int x, int y, int keys) {
        if (this.m_mouseDown) {
            if (this.m_mouseDrag) {
                int dx = x - this.m_mouseDownPoint.x;
                int dy = y - this.m_mouseDownPoint.y;
                this.setDragPoint(x, y);
                this.setDragRegionFromPoints(this.m_mouseDownPoint.x, this.m_mouseDownPoint.y, x, y);
                this.drag(this.m_mouseDownButton, dx, dy, keys, 2);
                this.m_mouseDrag = false;
            } else if (button == 3) {
                this.contextMenu(x, y, keys);
            } else {
                this.select(x, y, keys);
            }
            this.m_mouseDown = false;
        }
        this.mouseUp(button, x, y, keys);
    }

    protected void mouseDoubleClickHandler(int button, int x, int y, int keys) {
        this.mouseDoubleClick(button, x, y, keys);
    }

    protected void mouseEnterHandler(int x, int y) {
        if (!this.m_mouseDown) {
            this.mouseEnter(x, y);
        }
    }

    protected void mouseExitHandler(int x, int y) {
        if (!this.m_mouseDown) {
            this.mouseExit(x, y);
        }
    }

    protected void mouseHoverHandler(int x, int y) {
        if (!this.m_mouseDown) {
            this.mouseHover(x, y);
        }
    }

    public void mouseDown(int button, int x, int y, int keys) {
    }

    public void mouseMove(int x, int y, int keys) {
    }

    public void mouseUp(int button, int x, int y, int keys) {
    }

    public void select(int x, int y, int keys) {
    }

    public void contextMenu(int x, int y, int keys) {
    }

    public void mouseDoubleClick(int button, int x, int y, int keys) {
    }

    public void drag(int button, int x, int y, int keys, int dragState) {
    }

    public void mouseEnter(int x, int y) {
    }

    public void mouseExit(int x, int y) {
    }

    public void mouseHover(int x, int y) {
    }
}

