/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.mingw;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MingwEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static final String ENV_PATH = "PATH";
    private static String envPathValueCached = null;
    private static String envMingwHomeValueCached = null;
    private static IPath binDir = null;
    private static IPath msysBinDir = null;

    public static IPath getBinDir() {
        MingwEnvironmentVariableSupplier.locateMingw();
        return binDir;
    }

    public static IPath getMsysBinDir() {
        MingwEnvironmentVariableSupplier.locateMingw();
        return msysBinDir;
    }

    private static void locateMingw() {
        String envMingwHomeValue;
        IEnvironmentVariable varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, null, true);
        String envPathValue = varPath != null ? varPath.getValue() : null;
        IEnvironmentVariable varMingwHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable("MINGW_HOME", null, true);
        String string = envMingwHomeValue = varMingwHome != null ? varMingwHome.getValue() : null;
        if (CDataUtil.objectsEqual((Object)envPathValue, (Object)envPathValueCached) && CDataUtil.objectsEqual((Object)envMingwHomeValue, (Object)envMingwHomeValueCached)) {
            return;
        }
        envPathValueCached = envPathValue;
        envMingwHomeValueCached = envMingwHomeValue;
        binDir = MingwEnvironmentVariableSupplier.locateBinDir();
        msysBinDir = MingwEnvironmentVariableSupplier.locateMsysBinDir(binDir);
    }

    private static IPath locateBinDir() {
        IPath gcc64Loc;
        Path mingwBinDir = new Path(String.valueOf(envMingwHomeValueCached) + "\\bin");
        if (mingwBinDir.toFile().isDirectory()) {
            return mingwBinDir;
        }
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        mingwBinDir = installPath.append("mingw\\bin");
        if (mingwBinDir.toFile().isDirectory()) {
            return mingwBinDir;
        }
        if ("x86_64".equals(Platform.getOSArch()) && (gcc64Loc = PathUtil.findProgramLocation((String)"x86_64-w64-mingw32-gcc.exe", (String)envPathValueCached)) != null) {
            return gcc64Loc.removeLastSegments(1);
        }
        IPath gccLoc = PathUtil.findProgramLocation((String)"mingw32-gcc.exe", (String)envPathValueCached);
        if (gccLoc != null) {
            return gccLoc.removeLastSegments(1);
        }
        mingwBinDir = new Path("C:\\MinGW\\bin");
        if (mingwBinDir.toFile().isDirectory()) {
            return mingwBinDir;
        }
        return null;
    }

    private static IPath locateMsysBinDir(IPath binPath) {
        if (binPath != null) {
            Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
            IPath msysBinPath = installPath.append("msys\\bin");
            if (msysBinPath.toFile().isDirectory()) {
                return msysBinPath;
            }
            if (envMingwHomeValueCached != null && (msysBinPath = new Path(String.valueOf(envMingwHomeValueCached) + "\\msys\\1.0\\bin")).toFile().isDirectory()) {
                return msysBinPath;
            }
            msysBinPath = new Path("C:\\MinGW\\msys\\1.0\\bin");
            if (msysBinPath.toFile().isDirectory()) {
                return msysBinPath;
            }
        }
        return null;
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName.equals(ENV_PATH)) {
            MingwEnvironmentVariableSupplier.locateMingw();
            if (binDir != null) {
                String pathStr = binDir.toOSString();
                if (msysBinDir != null) {
                    pathStr = String.valueOf(pathStr) + ";" + msysBinDir.toOSString();
                }
                return new MingwBuildEnvironmentVariable(ENV_PATH, pathStr, 3);
            }
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray;
        IBuildEnvironmentVariable path = this.getVariable(ENV_PATH, configuration, provider);
        if (path != null) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = new IBuildEnvironmentVariable[1];
            iBuildEnvironmentVariableArray = iBuildEnvironmentVariableArray2;
            iBuildEnvironmentVariableArray2[0] = path;
        } else {
            iBuildEnvironmentVariableArray = new IBuildEnvironmentVariable[]{};
        }
        return iBuildEnvironmentVariableArray;
    }

    private static class MingwBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private static final String PATH_SEPARATOR = ";";
        private final String name;
        private final String value;
        private final int operation;

        public MingwBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getDelimiter() {
            return PATH_SEPARATOR;
        }
    }
}

