/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsBaseProvider;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.CExtensionUtil;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsSerializableStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ScannerInfoExtensionLanguageSettingsProvider
extends LanguageSettingsBaseProvider {
    @Override
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        IScannerInfo si;
        ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>();
        IScannerInfoProvider scannerInfoProvider = this.getScannerInfoProvider(cfgDescription);
        if (scannerInfoProvider != null && (si = scannerInfoProvider.getScannerInformation(rc)) != null) {
            if (si instanceof IExtendedScannerInfo) {
                this.addLocalIncludePaths(entries, (IExtendedScannerInfo)si);
            }
            this.addSystemIncludePaths(entries, si);
            this.addDefinedSymbols(entries, si);
            if (si instanceof IExtendedScannerInfo) {
                this.addIncludeFiles(entries, (IExtendedScannerInfo)si);
                this.addMacroFiles(entries, (IExtendedScannerInfo)si);
            }
            if (!entries.isEmpty()) {
                return LanguageSettingsSerializableStorage.getPooledList(entries);
            }
        }
        return null;
    }

    public IScannerInfoProvider getScannerInfoProvider(ICConfigurationDescription cfgDescription) {
        if (cfgDescription == null) {
            return null;
        }
        IScannerInfoProvider scannerInfoProvider = null;
        ICConfigExtensionReference[] refs = cfgDescription.get("org.eclipse.cdt.core.ScannerInfoProvider");
        if (refs != null && refs.length > 0) {
            ICConfigExtensionReference ref = refs[0];
            try {
                AbstractCExtension cExtension = null;
                IConfigurationElement el = CExtensionUtil.getFirstConfigurationElement(ref, "cextension", false);
                cExtension = (AbstractCExtension)el.createExecutableExtension("run");
                cExtension.setExtensionReference(ref);
                cExtension.setProject(ref.getConfiguration().getProjectDescription().getProject());
                if (cExtension instanceof IScannerInfoProvider) {
                    scannerInfoProvider = (IScannerInfoProvider)((Object)cExtension);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return scannerInfoProvider;
    }

    private void addLocalIncludePaths(List<ICLanguageSettingEntry> entries, IExtendedScannerInfo esi) {
        String[] localIncludePaths = esi.getLocalIncludePath();
        if (localIncludePaths != null) {
            String[] stringArray = localIncludePaths;
            int n = localIncludePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                entries.add(CDataUtil.createCIncludePathEntry(path, 4));
                ++n2;
            }
        }
    }

    private void addSystemIncludePaths(List<ICLanguageSettingEntry> entries, IScannerInfo si) {
        String[] includePaths = si.getIncludePaths();
        if (includePaths != null) {
            String[] stringArray = includePaths;
            int n = includePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                entries.add(CDataUtil.createCIncludePathEntry(path, 0));
                ++n2;
            }
        }
    }

    private void addDefinedSymbols(List<ICLanguageSettingEntry> entries, IScannerInfo si) {
        Map<String, String> definedSymbols = si.getDefinedSymbols();
        if (definedSymbols != null) {
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(definedSymbols).entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                entries.add(CDataUtil.createCMacroEntry(name, value, 0));
            }
        }
    }

    private void addIncludeFiles(List<ICLanguageSettingEntry> entries, IExtendedScannerInfo esi) {
        String[] includeFiles = esi.getIncludeFiles();
        if (includeFiles != null) {
            String[] stringArray = includeFiles;
            int n = includeFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                entries.add(CDataUtil.createCIncludeFileEntry(path, 0));
                ++n2;
            }
        }
    }

    private void addMacroFiles(List<ICLanguageSettingEntry> entries, IExtendedScannerInfo esi) {
        String[] macroFiles = esi.getMacroFiles();
        if (macroFiles != null) {
            String[] stringArray = macroFiles;
            int n = macroFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                entries.add(CDataUtil.createCMacroFileEntry(path, 0));
                ++n2;
            }
        }
    }
}

