/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui;

import org.eclipse.cdt.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.DsfSourceDisplayAdapter;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.DefaultDsfModelSelectionPolicyFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.pda.launch.PDALaunch;
import org.eclipse.cdt.examples.dsf.pda.ui.PDASuspendTrigger;
import org.eclipse.cdt.examples.dsf.pda.ui.actions.PDATerminateCommand;
import org.eclipse.cdt.examples.dsf.pda.ui.viewmodel.PDAVMAdapter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

class SessionAdapterSet {
    final PDAVMAdapter fViewModelAdapter;
    final DsfSourceDisplayAdapter fSourceDisplayAdapter;
    final DsfStepIntoCommand fStepIntoCommand;
    final DsfStepOverCommand fStepOverCommand;
    final DsfStepReturnCommand fStepReturnCommand;
    final DsfSuspendCommand fSuspendCommand;
    final DsfResumeCommand fResumeCommand;
    final PDATerminateCommand fTerminateCommand;
    final PDASuspendTrigger fSuspendTrigger;
    final IDebugModelProvider fDebugModelProvider;
    final PDALaunch fLaunch;
    final SteppingController fSteppingController;
    final IModelSelectionPolicyFactory fModelSelectionPolicyFactory;

    SessionAdapterSet(PDALaunch launch) {
        this.fLaunch = launch;
        DsfSession session = launch.getSession();
        this.fSteppingController = new SteppingController(session);
        session.registerModelAdapter(SteppingController.class, (Object)this.fSteppingController);
        this.fViewModelAdapter = new PDAVMAdapter(session, this.fSteppingController);
        this.fSourceDisplayAdapter = new DsfSourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator(), this.fSteppingController);
        session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
        this.fModelSelectionPolicyFactory = new DefaultDsfModelSelectionPolicyFactory();
        session.registerModelAdapter(IModelSelectionPolicyFactory.class, (Object)this.fModelSelectionPolicyFactory);
        this.fStepIntoCommand = new DsfStepIntoCommand(session, null);
        this.fStepOverCommand = new DsfStepOverCommand(session, null);
        this.fStepReturnCommand = new DsfStepReturnCommand(session);
        this.fSuspendCommand = new DsfSuspendCommand(session);
        this.fResumeCommand = new DsfResumeCommand(session);
        this.fTerminateCommand = new PDATerminateCommand(session);
        this.fSuspendTrigger = new PDASuspendTrigger(session, (ILaunch)this.fLaunch);
        session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
        session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
        session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
        session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
        session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
        session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
        this.fDebugModelProvider = new IDebugModelProvider(){

            public String[] getModelIdentifiers() {
                return new String[]{"org.eclipse.cdt.examples.dsf.pda.debugModel"};
            }
        };
        session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
    }

    void dispose() {
        DsfSession session = this.fLaunch.getSession();
        this.fViewModelAdapter.dispose();
        session.unregisterModelAdapter(ISourceDisplay.class);
        if (this.fSourceDisplayAdapter != null) {
            this.fSourceDisplayAdapter.dispose();
        }
        session.unregisterModelAdapter(SteppingController.class);
        this.fSteppingController.dispose();
        session.unregisterModelAdapter(IModelSelectionPolicyFactory.class);
        session.unregisterModelAdapter(IStepIntoHandler.class);
        session.unregisterModelAdapter(IStepOverHandler.class);
        session.unregisterModelAdapter(IStepReturnHandler.class);
        session.unregisterModelAdapter(ISuspendHandler.class);
        session.unregisterModelAdapter(IResumeHandler.class);
        session.unregisterModelAdapter(ITerminateHandler.class);
        this.fStepIntoCommand.dispose();
        this.fStepOverCommand.dispose();
        this.fStepReturnCommand.dispose();
        this.fSuspendCommand.dispose();
        this.fResumeCommand.dispose();
        this.fTerminateCommand.dispose();
        this.fSuspendTrigger.dispose();
    }
}

