/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.ui.text.spelling.HtmlTagDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingPreferences;
import org.eclipse.cdt.internal.ui.text.spelling.TaskTagDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.engine.LocaleSensitiveSpellDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.engine.PersistentSpellDictionary;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private static Set<Locale> fgLocalesWithInstalledDictionaries;
    private Set<ISpellDictionary> fGlobalDictionaries = new HashSet<ISpellDictionary>();
    private ISpellChecker fChecker = null;
    private Map<Locale, ISpellDictionary> fLocaleDictionaries = new HashMap<Locale, ISpellDictionary>();
    private ISpellDictionary fUserDictionary = null;

    public static Set<Locale> getLocalesWithInstalledDictionaries() {
        String[] fileNames;
        URL location;
        if (fgLocalesWithInstalledDictionaries != null) {
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            location = SpellCheckEngine.getDictionaryLocation();
            if (location == null) {
                fgLocalesWithInstalledDictionaries = Collections.emptySet();
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (MalformedURLException ex) {
            CUIPlugin.log(ex);
            fgLocalesWithInstalledDictionaries = Collections.emptySet();
            return fgLocalesWithInstalledDictionaries;
        }
        try {
            URL url = FileLocator.toFileURL((URL)location);
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                fgLocalesWithInstalledDictionaries = Collections.emptySet();
                return fgLocalesWithInstalledDictionaries;
            }
            fileNames = file.list();
            if (fileNames == null) {
                fgLocalesWithInstalledDictionaries = Collections.emptySet();
                return fgLocalesWithInstalledDictionaries;
            }
        }
        catch (IOException ex) {
            CUIPlugin.log(ex);
            fgLocalesWithInstalledDictionaries = Collections.emptySet();
            return fgLocalesWithInstalledDictionaries;
        }
        fgLocalesWithInstalledDictionaries = new HashSet<Locale>();
        int fileNameCount = fileNames.length;
        int i = 0;
        while (i < fileNameCount) {
            String fileName = fileNames[i];
            int localeEnd = fileName.indexOf(".dictionary");
            if (localeEnd > 1) {
                String localeName = fileName.substring(0, localeEnd);
                int languageEnd = localeName.indexOf(95);
                if (languageEnd == -1) {
                    fgLocalesWithInstalledDictionaries.add(new Locale(localeName));
                } else if (languageEnd == 2 && localeName.length() == 5) {
                    fgLocalesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3)));
                } else if (localeName.length() > 6 && localeName.charAt(5) == '_') {
                    fgLocalesWithInstalledDictionaries.add(new Locale(localeName.substring(0, 2), localeName.substring(3, 5), localeName.substring(6)));
                }
            }
            ++i;
        }
        return fgLocalesWithInstalledDictionaries;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public ISpellDictionary findDictionary(Locale locale) {
        ISpellDictionary dictionary = this.fLocaleDictionaries.get(locale);
        if (dictionary != null) {
            return dictionary;
        }
        String language = locale.getLanguage();
        for (Map.Entry<Locale, ISpellDictionary> entry : this.fLocaleDictionaries.entrySet()) {
            Locale dictLocale = entry.getKey();
            if (!dictLocale.getLanguage().equals(language)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Locale findClosestLocale(Locale locale) {
        if (locale == null || locale.toString().length() == 0) {
            return locale;
        }
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(locale)) {
            return locale;
        }
        String language = locale.getLanguage();
        for (Locale dictLocale : SpellCheckEngine.getLocalesWithInstalledDictionaries()) {
            if (!dictLocale.getLanguage().equals(language)) continue;
            return dictLocale;
        }
        Locale defaultLocale = Locale.US;
        if (SpellCheckEngine.getLocalesWithInstalledDictionaries().contains(defaultLocale)) {
            return defaultLocale;
        }
        return null;
    }

    public static URL getDictionaryLocation() throws MalformedURLException {
        CUIPlugin plugin = CUIPlugin.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getEntry("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    public static final synchronized void shutdownInstance() {
        if (fgEngine != null) {
            fgEngine.shutdown();
            fgEngine = null;
        }
    }

    private SpellCheckEngine() {
        this.fGlobalDictionaries.add(new TaskTagDictionary());
        this.fGlobalDictionaries.add(new HtmlTagDictionary());
        try {
            URL location = SpellCheckEngine.getDictionaryLocation();
            for (Locale locale : SpellCheckEngine.getLocalesWithInstalledDictionaries()) {
                this.fLocaleDictionaries.put(locale, new LocaleSensitiveSpellDictionary(locale, location));
            }
        }
        catch (MalformedURLException malformedURLException) {}
        SpellingPreferences.addPropertyChangeListener(this);
    }

    @Override
    public final synchronized ISpellChecker getSpellChecker() throws IllegalStateException {
        ISpellDictionary dictionary2;
        if (this.fGlobalDictionaries == null) {
            throw new IllegalStateException("spell checker has been shut down");
        }
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        Locale locale = this.getCurrentLocale(store);
        if (this.fUserDictionary == null && "".equals(locale.toString())) {
            return null;
        }
        if (this.fChecker != null && this.fChecker.getLocale().equals(locale)) {
            return this.fChecker;
        }
        this.resetSpellChecker();
        this.fChecker = new DefaultSpellChecker(store, locale);
        this.resetUserDictionary();
        for (ISpellDictionary dictionary2 : this.fGlobalDictionaries) {
            this.fChecker.addDictionary(dictionary2);
        }
        dictionary2 = this.findDictionary(this.fChecker.getLocale());
        if (dictionary2 != null) {
            this.fChecker.addDictionary(dictionary2);
        }
        return this.fChecker;
    }

    private Locale getCurrentLocale(IPreferenceStore store) {
        return SpellCheckEngine.convertToLocale(SpellingPreferences.getSpellingLocale());
    }

    public static Locale convertToLocale(String locale) {
        Locale defaultLocale = SpellCheckEngine.getDefaultLocale();
        if (locale.equals(defaultLocale.toString())) {
            return defaultLocale;
        }
        if (locale.length() >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        return new Locale("");
    }

    @Override
    public final synchronized Locale getLocale() {
        if (this.fChecker == null) {
            return null;
        }
        return this.fChecker.getLocale();
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("spelling_locale")) {
            this.resetSpellChecker();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary")) {
            this.resetUserDictionary();
            return;
        }
        if (event.getProperty().equals("spelling_user_dictionary_encoding")) {
            this.resetUserDictionary();
            return;
        }
    }

    private synchronized void resetUserDictionary() {
        block10: {
            String filePath;
            if (this.fChecker == null) {
                return;
            }
            if (this.fUserDictionary != null) {
                this.fChecker.removeDictionary(this.fUserDictionary);
                this.fUserDictionary.unload();
                this.fUserDictionary = null;
            }
            if ((filePath = SpellingPreferences.getSpellingUserDictionary()).length() > 0) {
                try {
                    File file = new File(filePath);
                    if (!file.exists() && !file.createNewFile()) {
                        return;
                    }
                    URL url = new URL("file", null, filePath);
                    InputStream stream = url.openStream();
                    if (stream == null) break block10;
                    try {
                        this.fUserDictionary = new PersistentSpellDictionary(url);
                        this.fChecker.addDictionary(this.fUserDictionary);
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public final synchronized void registerGlobalDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        this.resetSpellChecker();
    }

    @Override
    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        this.resetSpellChecker();
    }

    @Override
    public final synchronized void shutdown() {
        SpellingPreferences.removePropertyChangeListener(this);
        for (ISpellDictionary dictionary : this.fGlobalDictionaries) {
            dictionary.unload();
        }
        this.fGlobalDictionaries = null;
        for (ISpellDictionary dictionary : this.fLocaleDictionaries.values()) {
            dictionary.unload();
        }
        this.fLocaleDictionaries = null;
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    private synchronized void resetSpellChecker() {
        ISpellDictionary dictionary;
        if (this.fChecker != null && (dictionary = this.fLocaleDictionaries.get(this.fChecker.getLocale())) != null) {
            dictionary.unload();
        }
        this.fChecker = null;
    }

    @Override
    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        dictionary.unload();
        this.resetSpellChecker();
    }
}

