/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.llvm.ui.preferences;

import org.eclipse.cdt.managedbuilder.llvm.ui.LlvmEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.llvm.ui.preferences.LlvmListEditor;
import org.eclipse.cdt.managedbuilder.llvm.ui.preferences.LlvmPreferenceStore;
import org.eclipse.cdt.managedbuilder.llvm.ui.preferences.Messages;
import org.eclipse.cdt.managedbuilder.llvm.util.LlvmToolOptionPathUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class IncludePathListEditor
extends LlvmListEditor {
    IncludePathListEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected String getNewInputObject() {
        DirectoryDialog dlg = new DirectoryDialog(this.getShell());
        Text text = new Text((Composite)this.getShell(), 2048);
        dlg.setFilterPath(text.getText());
        dlg.setText(Messages.IncludePathListEditor_0);
        dlg.setMessage(Messages.IncludePathListEditor_1);
        String dir = dlg.open();
        if (dir == null) {
            return null;
        }
        if ((dir = dir.trim()).length() != 0) {
            String[] existingItems = this.getList().getItems();
            if (existingItems.length > 0) {
                String[] stringArray = existingItems;
                int n = existingItems.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.equalsIgnoreCase(dir)) {
                        return null;
                    }
                    ++n2;
                }
            }
            LlvmPreferenceStore.appendIncludePath(dir);
            LlvmToolOptionPathUtil.addLlvmIncludePath(dir);
            LlvmEnvironmentVariableSupplier.notifyPreferenceChange();
            return dir;
        }
        return null;
    }

    protected void removePressed() {
        String[] selected;
        List incList = this.getList();
        this.setPresentsDefaultValue(false);
        String[] stringArray = selected = incList.getSelection();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            LlvmPreferenceStore.removeIncludePath(s);
            LlvmToolOptionPathUtil.removeLlvmIncludePath(s);
            LlvmEnvironmentVariableSupplier.notifyPreferenceChange();
            incList.remove(s);
            this.selectionChanged();
            ++n2;
        }
    }
}

