/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.internal.core;

import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.tag.IBindingTagger;
import org.eclipse.cdt.core.dom.ast.tag.ITag;
import org.eclipse.cdt.core.dom.ast.tag.ITagWriter;
import org.eclipse.cdt.core.dom.ast.tag.IWritableTag;

public class QtSignalSlotTagger
implements IBindingTagger {
    private static ICPPASTVisibilityLabel findVisibilityLabel(ICPPMethod method, IASTNode ast) {
        if (ast == null) {
            return null;
        }
        IASTNode methodDecl = ast;
        ICPPASTCompositeTypeSpecifier classType = null;
        while (methodDecl != null && classType == null) {
            IASTNode parent = methodDecl.getParent();
            if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                classType = (ICPPASTCompositeTypeSpecifier)parent;
                continue;
            }
            methodDecl = parent;
        }
        if (methodDecl == null || classType == null) {
            return null;
        }
        ICPPASTVisibilityLabel lastLabel = null;
        IASTDeclaration[] iASTDeclarationArray = classType.getMembers();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof ICPPASTVisibilityLabel) {
                lastLabel = (ICPPASTVisibilityLabel)decl;
            } else if (decl == methodDecl) {
                return lastLabel;
            }
            ++n2;
        }
        return null;
    }

    private static byte getBitset(IASTNodeLocation ... locations) {
        IASTNodeLocation[] iASTNodeLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNodeLocation location = iASTNodeLocationArray[n2];
            if (location instanceof IASTMacroExpansionLocation) {
                IASTMacroExpansionLocation macroExpansion = (IASTMacroExpansionLocation)location;
                IASTPreprocessorMacroExpansion exp = macroExpansion.getExpansion();
                String macro = exp.getMacroReference().toString();
                if ("Q_SIGNAL".equals(macro) || "Q_SIGNALS".equals(macro) || "signals".equals(macro)) {
                    return 1;
                }
                if ("Q_SLOT".equals(macro) || "Q_SLOTS".equals(macro) || "slots".equals(macro)) {
                    return 2;
                }
            }
            ++n2;
        }
        return 0;
    }

    private static byte getBitset(IASTNode ... nodes) {
        byte bitset = 0;
        IASTNode[] iASTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            if (node != null) {
                IASTNodeLocation[] iASTNodeLocationArray = node.getNodeLocations();
                int n3 = iASTNodeLocationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTNodeLocation loc = iASTNodeLocationArray[n4];
                    bitset = (byte)(bitset | QtSignalSlotTagger.getBitset(loc));
                    ++n4;
                }
            }
            ++n2;
        }
        return bitset;
    }

    private static IASTNode getSimpleDecl(IASTNode node) {
        while (node != null && !(node instanceof IASTSimpleDeclaration)) {
            node = node.getParent();
        }
        return node;
    }

    private byte getQtMarkers(ICPPMethod method, IASTName ast) {
        IASTNode parent;
        byte bitset = 0;
        if (ast == null) {
            return bitset;
        }
        bitset = (byte)(bitset | QtSignalSlotTagger.getBitset(new IASTNode[]{QtSignalSlotTagger.findVisibilityLabel(method, (IASTNode)ast)}));
        IASTNode simpleDecl = QtSignalSlotTagger.getSimpleDecl((IASTNode)ast);
        IASTNode iASTNode = parent = simpleDecl == null ? null : simpleDecl.getParent();
        if (parent == null) {
            return bitset;
        }
        IASTNode previous = null;
        IASTNode[] children = parent.getChildren();
        if (children.length > 1) {
            int i = 1;
            while (i < children.length) {
                if (children[i] == simpleDecl) {
                    int j = i - 1;
                    while (previous == null && j >= 0) {
                        if (!(children[j] instanceof IASTProblemHolder)) {
                            previous = children[j];
                        }
                        --j;
                    }
                    break;
                }
                if (children[i] instanceof IASTSimpleDeclaration) {
                    previous = children[i];
                }
                ++i;
            }
        }
        if (previous == null) {
            return bitset;
        }
        IASTFileLocation prevLocation = previous.getFileLocation();
        int prev_off = prevLocation.getNodeOffset();
        int prev_end = prevLocation.getNodeOffset() + prevLocation.getNodeLength();
        int end = ast.getFileLocation().getNodeOffset() + ast.getFileLocation().getNodeLength();
        boolean found_previous = false;
        IASTNodeLocation[] iASTNodeLocationArray = parent.getNodeLocations();
        int n = iASTNodeLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNodeLocation loc = iASTNodeLocationArray[n2];
            int o = loc.getNodeOffset();
            int e = loc.getNodeOffset() + loc.getNodeLength();
            if (found_previous) {
                bitset = (byte)(bitset | QtSignalSlotTagger.getBitset(loc));
            } else if (o <= prev_off && e >= prev_end) {
                found_previous = true;
            }
            if (e >= end) break;
            ++n2;
        }
        return bitset;
    }

    public ITag process(ITagWriter tagWriter, IBinding binding, IASTName ast) {
        IWritableTag tag;
        if (!(binding instanceof ICPPMethod)) {
            return null;
        }
        ICPPMethod method = (ICPPMethod)binding;
        byte bitset = this.getQtMarkers(method, ast);
        if (bitset != 0 && (tag = tagWriter.createTag("org.eclipse.cdt.qt.core.signalslot.tagger", 1)) != null && tag.putByte(0, bitset)) {
            return tag;
        }
        return null;
    }
}

