/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.tag.ITag;
import org.eclipse.cdt.core.dom.ast.tag.ITagReader;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class QtCompletionProposalComputer
extends ParsingBasedProposalComputer {
    private boolean isApplicable(ICEditorContentAssistInvocationContext context) {
        ITranslationUnit tu = context.getTranslationUnit();
        if (tu == null) {
            return false;
        }
        ICProject cProject = tu.getCProject();
        if (cProject == null) {
            return false;
        }
        IProject project = cProject.getProject();
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature("org.eclipse.cdt.qt.core.qtNature");
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
            return false;
        }
    }

    private static boolean is_QObject_connect(ICEditorContentAssistInvocationContext context, IASTCompletionContext astContext, IASTName name) {
        IBinding[] funcBindings;
        IASTName connectName = name.getLastName();
        if (!"connect".equals(new String(connectName.getSimpleID()))) {
            return false;
        }
        IBinding[] iBindingArray = funcBindings = astContext.findBindings(connectName, !context.isContextInformationStyle());
        int n = funcBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding ownerBinding;
            IBinding funcBinding = iBindingArray[n2];
            if (funcBinding instanceof ICPPFunction && (ownerBinding = ((ICPPFunction)funcBinding).getOwner()) != null && "QObject".equals(ownerBinding.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Iterable<ICPPMethod> filterMethods(final ICPPClassType cls, final MethodFilter filter) {
        return new Iterable<ICPPMethod>(){

            @Override
            public Iterator<ICPPMethod> iterator() {
                return new Iterator<ICPPMethod>(cls){
                    private int index = 0;
                    private final ICPPMethod[] methods;
                    {
                        this.methods = iCPPClassType.getMethods();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.index < this.methods.length) {
                            if (filter.keep(this.methods[this.index])) {
                                return true;
                            }
                            ++this.index;
                        }
                        return false;
                    }

                    @Override
                    public ICPPMethod next() {
                        return this.methods[this.index++];
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    private static String getSignature(ICPPMethod method) {
        StringBuilder signature = new StringBuilder();
        signature.append(method.getName());
        signature.append('(');
        boolean first = true;
        ICPPParameter[] iCPPParameterArray = method.getParameters();
        int n = iCPPParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPParameter param = iCPPParameterArray[n2];
            if (first) {
                first = false;
            } else {
                signature.append(", ");
            }
            signature.append(ASTTypeUtil.getType((IType)param.getType()));
            ++n2;
        }
        signature.append(')');
        return signature.toString();
    }

    private static void addCompletionsFor(Collection<Completion> completions, IASTInitializerClause init, MethodFilter filter) {
        if (!(init instanceof ICPPASTInitializerClause)) {
            return;
        }
        ICPPEvaluation eval = ((ICPPASTInitializerClause)init).getEvaluation();
        if (eval == null) {
            return;
        }
        IType type = eval.getTypeOrFunctionSet((IASTNode)init);
        while (type instanceof IPointerType) {
            type = ((IPointerType)type).getType();
        }
        if (type instanceof ICPPClassType) {
            for (ICPPMethod signal : QtCompletionProposalComputer.filterMethods((ICPPClassType)type, filter)) {
                completions.add(new Completion(QtCompletionProposalComputer.getSignature(signal)));
            }
        }
    }

    private static int indexOfClosingPeer(String code, char left, char right, int pos) {
        int level = 0;
        int length = code.length();
        while (pos < length) {
            char ch = code.charAt(pos);
            if (ch == left) {
                ++level;
            } else if (ch == right && --level == 0) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private static int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(new Integer(-1));
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(new Integer(pos));
                    break;
                }
                case '(': {
                    pos = QtCompletionProposalComputer.indexOfClosingPeer(code, '(', ')', pos);
                    break;
                }
                case '<': {
                    pos = QtCompletionProposalComputer.indexOfClosingPeer(code, '<', '>', pos);
                    break;
                }
                case '[': {
                    pos = QtCompletionProposalComputer.indexOfClosingPeer(code, '[', ']', pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(new Integer(length));
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }

    private void addConnectParameterCompletions(List<ICompletionProposal> proposals, ICEditorContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        IASTName[] names = completionNode.getNames();
        LinkedList<Completion> completions = new LinkedList<Completion>();
        IASTName[] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTCompletionContext astContext;
            IASTName name = iASTNameArray[n2];
            if (name.getTranslationUnit() != null && (astContext = name.getCompletionContext()) != null && astContext instanceof IASTNode) {
                IASTIdExpression funcNameIdExpr;
                IASTName funcName;
                IASTFunctionCallExpression call;
                IASTExpression nameExpr;
                IASTNode parent;
                IASTNode astNode = (IASTNode)astContext;
                if (QtCompletionProposalComputer.is_QObject_connect(context, astContext, name)) {
                    int parseOffset = context.getParseOffset();
                    int invocationOffset = context.getInvocationOffset();
                    String unparsed = "";
                    try {
                        unparsed = context.getDocument().get(parseOffset, invocationOffset - parseOffset);
                    }
                    catch (BadLocationException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                    if (unparsed.length() > 0 && unparsed.charAt(0) == '(') {
                        unparsed = unparsed.substring(1);
                    }
                    int[] commas = QtCompletionProposalComputer.computeCommaPositions(unparsed);
                    switch (commas.length) {
                        case 3: {
                            completions.add(Completion.SIGNAL);
                            break;
                        }
                        case 5: {
                            completions.add(Completion.SLOT);
                        }
                    }
                } else if (astNode.getPropertyInParent() == IASTFunctionCallExpression.ARGUMENT && (parent = astNode.getParent()) instanceof IASTFunctionCallExpression && (nameExpr = (call = (IASTFunctionCallExpression)parent).getFunctionNameExpression()) instanceof IASTIdExpression && QtCompletionProposalComputer.is_QObject_connect(context, astContext, funcName = (funcNameIdExpr = (IASTIdExpression)nameExpr).getName())) {
                    IASTInitializerClause[] args = call.getArguments();
                    switch (args.length) {
                        case 2: {
                            QtCompletionProposalComputer.addCompletionsFor(completions, args[0], MethodFilter.Qt.Signal);
                            break;
                        }
                        case 4: {
                            QtCompletionProposalComputer.addCompletionsFor(completions, args[2], MethodFilter.Qt.Slot);
                        }
                    }
                }
            }
            ++n2;
        }
        for (Completion completion : completions) {
            ICompletionProposal proposal = completion.createProposal(context);
            if (proposal == null) continue;
            proposals.add(proposal);
        }
    }

    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) throws CoreException {
        if (!this.isApplicable((ICEditorContentAssistInvocationContext)context)) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        this.addConnectParameterCompletions(proposals, (ICEditorContentAssistInvocationContext)context, completionNode, prefix);
        return proposals;
    }

    private static class Completion {
        private final String replacement;
        private final String display;
        private final int cursorOffset;
        public static final Completion SIGNAL = new Completion("SIGNAL()", "SIGNAL(a)", -1);
        public static final Completion SLOT = new Completion("SLOT()", "SLOT(a)", -1);

        public Completion(String replacement) {
            this(replacement, replacement, 0);
        }

        public Completion(String replacement, String display, int cursorOffset) {
            this.replacement = replacement;
            this.display = display;
            this.cursorOffset = cursorOffset;
        }

        public ICompletionProposal createProposal(ICEditorContentAssistInvocationContext context) {
            int repLength = this.replacement.length();
            int repOffset = context.getInvocationOffset();
            CCompletionProposal p = new CCompletionProposal(this.replacement, repOffset, repLength, null, this.display, 20, context.getViewer());
            p.setCursorPosition(repLength + this.cursorOffset);
            return p;
        }

        public String toString() {
            if (this.replacement == null) {
                return super.toString();
            }
            return String.valueOf(this.replacement) + '@' + this.cursorOffset;
        }
    }

    private static interface MethodFilter {
        public boolean keep(ICPPMethod var1);

        public static class Qt {
            public static final MethodFilter Signal = new MethodFilter(){

                @Override
                public boolean keep(ICPPMethod method) {
                    ITagReader tagReader = CCorePlugin.getTagService().findTagReader((IBinding)method);
                    if (tagReader == null) {
                        return false;
                    }
                    ITag tag = tagReader.getTag("org.eclipse.cdt.qt.core.signalslot.tagger");
                    if (tag == null) {
                        return false;
                    }
                    int result = tag.getByte(0);
                    return result != -1 && (result & 1) == 1;
                }
            };
            public static final MethodFilter Slot = new MethodFilter(){

                @Override
                public boolean keep(ICPPMethod method) {
                    ITagReader tagReader = CCorePlugin.getTagService().findTagReader((IBinding)method);
                    if (tagReader == null) {
                        return false;
                    }
                    ITag tag = tagReader.getTag("org.eclipse.cdt.qt.core.signalslot.tagger");
                    if (tag == null) {
                        return false;
                    }
                    int result = tag.getByte(0);
                    return result != -1 && (result & 2) == 2;
                }
            };
        }
    }
}

