/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorPragmaStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeGuardDetection;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.refactoring.includes.BindingClassifier;
import org.eclipse.cdt.internal.ui.refactoring.includes.HeaderSubstitutor;
import org.eclipse.cdt.internal.ui.refactoring.includes.IHeaderChooser;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeInfo;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeUtil;
import org.eclipse.cdt.internal.ui.refactoring.includes.InclusionContext;
import org.eclipse.cdt.internal.ui.refactoring.includes.InclusionRequest;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class IncludeOrganizer {
    private static boolean DEBUG_HEADER_SUBSTITUTION = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.ui/debug/includeOrganizer/headerSubstitution"));
    private static final Collator COLLATOR = Collator.getInstance();
    private final IHeaderChooser fHeaderChooser;
    private final InclusionContext fContext;
    private final String fLineDelimiter;

    public IncludeOrganizer(ITranslationUnit tu, IIndex index, String lineDelimiter, IHeaderChooser headerChooser) {
        this.fLineDelimiter = lineDelimiter;
        this.fHeaderChooser = headerChooser;
        this.fContext = new InclusionContext(tu, index);
    }

    public List<TextEdit> organizeIncludes(IASTTranslationUnit ast) throws CoreException {
        IASTPreprocessorIncludeStatement[] existingIncludes;
        Object prototype;
        BindingClassifier bindingClassifier = new BindingClassifier(this.fContext);
        bindingClassifier.classifyNodeContents((IASTNode)ast);
        Set<IBinding> bindingsToDefine = bindingClassifier.getBindingsToDefine();
        ArrayList<String> typeForwardDeclarations = new ArrayList<String>();
        ArrayList<String> functionForwardDeclarations = new ArrayList<String>();
        this.createForwardDeclarations(ast, bindingClassifier, typeForwardDeclarations, functionForwardDeclarations, bindingsToDefine);
        HeaderSubstitutor headerSubstitutor = new HeaderSubstitutor(this.fContext);
        IIndexFileSet reachableHeaders = ast.getIndexFileSet();
        List<InclusionRequest> requests = this.createInclusionRequests(bindingsToDefine, reachableHeaders);
        this.processInclusionRequests(requests, headerSubstitutor);
        HashMap<IncludePrototype, IncludePrototype> includePrototypes = new HashMap<IncludePrototype, IncludePrototype>();
        for (IPath header : this.fContext.getHeadersToInclude()) {
            IncludeGroupStyle style = this.getIncludeStyle(header);
            IncludeInfo includeInfo = this.createIncludeInfo(header, style);
            prototype = new IncludePrototype(header, includeInfo, style);
            this.updateIncludePrototypes(includePrototypes, (IncludePrototype)prototype);
        }
        prototype = existingIncludes = ast.getIncludeDirectives();
        int includeInfo = existingIncludes.length;
        int style = 0;
        while (style < includeInfo) {
            IASTPreprocessorIncludeStatement include = prototype[style];
            if (include.isPartOfTranslationUnitFile()) {
                String name = new String(include.getName().getSimpleID());
                IncludeInfo includeInfo2 = new IncludeInfo(name, include.isSystemInclude());
                String path = include.getPath();
                IPath header = path.isEmpty() ? null : Path.fromOSString((String)path);
                IncludeGroupStyle style2 = header != null ? this.getIncludeStyle(header) : this.getIncludeStyle(includeInfo2);
                IncludePrototype prototype2 = new IncludePrototype(include, header, includeInfo2, style2);
                this.updateIncludePrototypes(includePrototypes, prototype2);
            }
            ++style;
        }
        NodeCommentMap commentedNodeMap = ASTCommenter.getCommentedNodeMap((IASTTranslationUnit)ast);
        IRegion includeReplacementRegion = this.getSafeIncludeReplacementRegion(ast, commentedNodeMap);
        IncludePreferences preferences = this.fContext.getPreferences();
        boolean allowReordering = preferences.allowReordering || existingIncludes.length == 0;
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        List[] groupedPrototypes = new List[preferences.includeStyles.size()];
        for (IncludePrototype prototype3 : includePrototypes.keySet()) {
            if (prototype3.existingInclude == null || allowReordering && this.isContainedInRegion((IASTNode)prototype3.existingInclude, includeReplacementRegion)) {
                IncludeGroupStyle groupingStyle = this.getGroupingStyle(prototype3.style);
                int position = allowReordering ? groupingStyle.getOrder() : 0;
                ArrayList<IncludePrototype> prototypes = groupedPrototypes[position];
                if (prototypes == null) {
                    groupedPrototypes[position] = prototypes = new ArrayList<IncludePrototype>();
                }
                prototypes.add(prototype3);
            }
            if (allowReordering || prototype3.existingInclude == null || prototype3.required || prototype3.header == null || !this.isContainedInRegion((IASTNode)prototype3.existingInclude, includeReplacementRegion)) continue;
            switch (preferences.unusedStatementsDisposition) {
                case REMOVE: {
                    this.createDelete(prototype3.existingInclude, edits);
                    break;
                }
                case COMMENT_OUT: {
                    this.createCommentOut(prototype3.existingInclude, edits);
                    break;
                }
            }
        }
        ArrayList<String> includeDirectives = new ArrayList<String>();
        IncludeGroupStyle previousParentStyle = null;
        List[] listArray = groupedPrototypes;
        int prototypes = groupedPrototypes.length;
        int position = 0;
        while (position < prototypes) {
            List prototypes2 = listArray[position];
            if (prototypes2 != null && !prototypes2.isEmpty()) {
                Collections.sort(prototypes2);
                IncludeGroupStyle style3 = ((IncludePrototype)prototypes2.get((int)0)).style;
                IncludeGroupStyle groupingStyle = this.getGroupingStyle(style3);
                IncludeGroupStyle parentStyle = this.getParentStyle(groupingStyle);
                boolean blankLineBefore = groupingStyle.isBlankLineBefore() || parentStyle != null && parentStyle != previousParentStyle && parentStyle.isKeepTogether() && parentStyle.isBlankLineBefore();
                previousParentStyle = parentStyle;
                if (!includeDirectives.isEmpty() && blankLineBefore) {
                    includeDirectives.add("");
                }
                for (IncludePrototype prototype4 : prototypes2) {
                    String directive;
                    String trailingComment = "";
                    IASTPreprocessorIncludeStatement include = prototype4.existingInclude;
                    if (include != null && (!allowReordering || !this.isContainedInRegion((IASTNode)include, includeReplacementRegion))) continue;
                    if (include != null) {
                        List comments = commentedNodeMap.getTrailingCommentsForNode((IASTNode)include);
                        StringBuilder buf = new StringBuilder();
                        for (IASTComment comment : comments) {
                            buf.append(this.getPrecedingWhitespace((IASTNode)comment));
                            buf.append(comment.getRawSignature());
                        }
                        trailingComment = buf.toString();
                    }
                    if ((directive = this.createIncludeDirective(prototype4, trailingComment)) == null) continue;
                    includeDirectives.add(directive);
                }
            }
            ++position;
        }
        StringBuilder buf = new StringBuilder();
        for (String include : includeDirectives) {
            buf.append(include);
            buf.append(this.fLineDelimiter);
        }
        if (buf.length() != 0 && !typeForwardDeclarations.isEmpty()) {
            buf.append(this.fLineDelimiter);
        }
        for (String declaration : typeForwardDeclarations) {
            buf.append(declaration);
            buf.append(this.fLineDelimiter);
        }
        if (buf.length() != 0 && !functionForwardDeclarations.isEmpty()) {
            buf.append(this.fLineDelimiter);
        }
        for (String declaration : functionForwardDeclarations) {
            buf.append(declaration);
            buf.append(this.fLineDelimiter);
        }
        int offset = includeReplacementRegion.getOffset();
        int length = includeReplacementRegion.getLength();
        if (allowReordering) {
            if (buf.length() != 0) {
                if (offset != 0 && !this.isPreviousLineBlank(offset)) {
                    buf.insert(0, this.fLineDelimiter);
                }
                if (!this.isBlankLineOrEndOfFile(offset + length)) {
                    buf.append(this.fLineDelimiter);
                }
            }
            String text = buf.toString();
            if (!CharArrayUtils.equals((char[])this.fContext.getTranslationUnit().getContents(), (int)offset, (int)length, (String)text)) {
                edits.add((TextEdit)new ReplaceEdit(offset, length, text));
            }
        } else if (buf.length() != 0) {
            if (!this.isBlankLineOrEndOfFile(offset += length)) {
                buf.append(this.fLineDelimiter);
            }
            edits.add((TextEdit)new InsertEdit(offset, buf.toString()));
        }
        return edits;
    }

    private void createForwardDeclarations(IASTTranslationUnit ast, BindingClassifier classifier, List<String> forwardDeclarations, List<String> functionForwardDeclarations, Set<IBinding> bindingsToDefine) throws CoreException {
        IIndexFileSet reachableHeaders = ast.getIndexFileSet();
        Set<IBinding> bindings = this.removeBindingsDefinedInIncludedHeaders(classifier.getBindingsToDeclare(), reachableHeaders);
        for (IBinding binding : bindings) {
            StringBuilder declarationText = new StringBuilder();
            ArrayList<IName> scopeNames = new ArrayList<IName>();
            try {
                IScope scope = binding.getScope();
                while (scope != null && scope.getKind() == EScopeKind.eNamespace) {
                    IName scopeName = scope.getScopeName();
                    if (scopeName != null) {
                        scopeNames.add(scopeName);
                    }
                    scope = scope.getParent();
                }
            }
            catch (DOMException dOMException) {}
            Collections.reverse(scopeNames);
            for (IName scopeName : scopeNames) {
                declarationText.append("namespace ");
                declarationText.append(scopeName.toString());
                declarationText.append(" { ");
            }
            List<String> forwardDeclarationListToUse = forwardDeclarations;
            if (binding instanceof ICompositeType) {
                ICompositeType compositeType = (ICompositeType)binding;
                ICPPTemplateDefinition templateDefinition = null;
                if (compositeType instanceof ICPPTemplateDefinition) {
                    templateDefinition = (ICPPTemplateDefinition)compositeType;
                } else if (compositeType instanceof ICPPTemplateInstance) {
                    templateDefinition = ((ICPPTemplateInstance)compositeType).getTemplateDefinition();
                }
                if (templateDefinition != null) {
                    declarationText.append("template ");
                    ICPPTemplateParameter[] templateParameters = templateDefinition.getTemplateParameters();
                    int i = 0;
                    while (i < templateParameters.length) {
                        ICPPTemplateParameter templateParameter = templateParameters[i];
                        if (i == 0) {
                            declarationText.append("<");
                        }
                        declarationText.append("typename ");
                        declarationText.append(templateParameter.getName());
                        if (i != templateParameters.length - 1) {
                            declarationText.append(", ");
                        }
                        ++i;
                    }
                    if (templateParameters.length > 0) {
                        declarationText.append("> ");
                    }
                }
                switch (compositeType.getKey()) {
                    case 3: {
                        declarationText.append("class");
                        break;
                    }
                    case 1: {
                        declarationText.append("struct");
                        break;
                    }
                    case 2: {
                        declarationText.append("union");
                    }
                }
                declarationText.append(' ');
                declarationText.append(binding.getName());
                declarationText.append(';');
            } else if (binding instanceof IEnumeration) {
                declarationText.append("enum class ");
                declarationText.append(binding.getName());
                declarationText.append(';');
            } else if (binding instanceof IFunction && !(binding instanceof ICPPMethod)) {
                IFunction function = (IFunction)binding;
                IFunctionType functionType = function.getType();
                declarationText.append(ASTTypeUtil.getType((IType)functionType.getReturnType(), (boolean)false));
                declarationText.append(' ');
                declarationText.append(function.getName());
                declarationText.append('(');
                IType[] parameterTypes = functionType.getParameterTypes();
                IParameter[] parameters = function.getParameters();
                int i = 0;
                while (i < parameterTypes.length && i < parameters.length) {
                    if (i != 0) {
                        declarationText.append(", ");
                    }
                    declarationText.append(ASTTypeUtil.getType((IType)parameterTypes[i], (boolean)false));
                    char lastChar = declarationText.charAt(declarationText.length() - 1);
                    if (lastChar != '*' && lastChar != '&') {
                        declarationText.append(' ');
                    }
                    declarationText.append(parameters[i].getName());
                    ++i;
                }
                declarationText.append(");");
                forwardDeclarationListToUse = functionForwardDeclarations;
            } else {
                bindingsToDefine.add(binding);
                continue;
            }
            int i = 0;
            while (i < scopeNames.size()) {
                declarationText.append(" }");
                ++i;
            }
            forwardDeclarationListToUse.add(declarationText.toString());
        }
        Collections.sort(forwardDeclarations, COLLATOR);
        Collections.sort(functionForwardDeclarations, COLLATOR);
    }

    private void createCommentOut(IASTPreprocessorIncludeStatement include, List<TextEdit> edits) {
        IASTFileLocation location = include.getFileLocation();
        int offset = location.getNodeOffset();
        if (this.fContext.getTranslationUnit().isCXXLanguage()) {
            offset = this.getLineStart(offset);
            edits.add((TextEdit)new InsertEdit(offset, "//"));
        } else {
            edits.add((TextEdit)new InsertEdit(offset, "/*"));
            int endOffset = offset + location.getNodeLength();
            edits.add((TextEdit)new InsertEdit(endOffset, "*/"));
        }
    }

    private void createDelete(IASTPreprocessorIncludeStatement include, List<TextEdit> edits) {
        IASTFileLocation location = include.getFileLocation();
        int offset = location.getNodeOffset();
        int endOffset = offset + location.getNodeLength();
        offset = this.getLineStart(offset);
        endOffset = this.skipToNextLine(endOffset);
        edits.add((TextEdit)new DeleteEdit(offset, endOffset - offset));
    }

    private void updateIncludePrototypes(Map<IncludePrototype, IncludePrototype> includePrototypes, IncludePrototype prototype) {
        IncludePrototype existing = includePrototypes.get(prototype);
        if (existing == null) {
            includePrototypes.put(prototype, prototype);
        } else {
            existing.updateFrom(prototype);
        }
    }

    private boolean isContainedInRegion(IASTNode node, IRegion region) {
        return ASTTranslationUnit.getNodeOffset((IASTNode)node) >= region.getOffset() && ASTTranslationUnit.getNodeEndOffset((IASTNode)node) <= region.getOffset() + region.getLength();
    }

    private IRegion getSafeIncludeReplacementRegion(IASTTranslationUnit ast, NodeCommentMap commentMap) {
        int maxSafeOffset = ast.getFileLocation().getNodeLength();
        IASTDeclaration[] declarations = ast.getDeclarations(true);
        if (declarations.length != 0) {
            maxSafeOffset = declarations[0].getFileLocation().getNodeOffset();
        }
        boolean topCommentSkipped = false;
        int includeOffset = -1;
        int includeEndOffset = -1;
        int includeGuardStatementsToSkip = this.getNumberOfIncludeGuardStatementsToSkip(ast);
        int includeGuardEndOffset = -1;
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = ast.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement.isPartOfTranslationUnitFile()) {
                IASTFileLocation fileLocation = statement.getFileLocation();
                int offset = fileLocation.getNodeOffset();
                if (offset >= maxSafeOffset) break;
                int endOffset = offset + fileLocation.getNodeLength();
                if (includeGuardStatementsToSkip > 0) {
                    --includeGuardStatementsToSkip;
                    includeGuardEndOffset = endOffset;
                    if (!commentMap.getLeadingCommentsForNode((IASTNode)statement).isEmpty()) {
                        topCommentSkipped = true;
                    }
                } else {
                    if (!(statement instanceof IASTPreprocessorIncludeStatement)) break;
                    if (includeOffset < 0) {
                        includeOffset = offset;
                    }
                    includeEndOffset = endOffset;
                    includeGuardStatementsToSkip = 0;
                }
            }
            ++n2;
        }
        if (includeOffset <= 0) {
            includeOffset = includeGuardEndOffset >= 0 ? this.skipToNextLine(includeGuardEndOffset) : 0;
            if (!topCommentSkipped) {
                includeOffset = this.skipStandaloneCommentBlock(includeOffset, maxSafeOffset, ast.getComments(), commentMap);
            }
            includeEndOffset = includeOffset;
        } else {
            includeEndOffset = this.skipToNextLine(includeEndOffset);
        }
        return new Region(includeOffset, includeEndOffset - includeOffset);
    }

    private int getNumberOfIncludeGuardStatementsToSkip(IASTTranslationUnit ast) {
        IASTPreprocessorStatement statement = this.findFirstPreprocessorStatement(ast);
        if (statement == null) {
            return 0;
        }
        int num = 0;
        int offset = 0;
        if (this.isPragmaOnce(statement)) {
            ++num;
            offset = ASTTranslationUnit.getNodeEndOffset((IASTNode)statement);
        }
        char[] contents = ast.getRawSignature().toCharArray();
        if (offset != 0) {
            Arrays.copyOfRange(contents, offset, contents.length);
        }
        CharArrayIntMap ppKeywords = new CharArrayIntMap(40, -1);
        Keywords.addKeywordsPreprocessor((CharArrayIntMap)ppKeywords);
        if (IncludeGuardDetection.detectIncludeGuard((AbstractCharArray)new CharArray(contents), (Lexer.LexerOptions)new Lexer.LexerOptions(), (CharArrayIntMap)ppKeywords) != null) {
            num += 2;
        }
        return num;
    }

    private IASTPreprocessorStatement findFirstPreprocessorStatement(IASTTranslationUnit ast) {
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = ast.getAllPreprocessorStatements();
        int n = iASTPreprocessorStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement.isPartOfTranslationUnitFile()) {
                return statement;
            }
            ++n2;
        }
        return null;
    }

    private boolean isPragmaOnce(IASTPreprocessorStatement statement) {
        if (!(statement instanceof IASTPreprocessorPragmaStatement)) {
            return false;
        }
        return CharArrayUtils.equals((char[])((IASTPreprocessorPragmaStatement)statement).getMessage(), (String)"once");
    }

    private int skipToNextLine(int offset) {
        char[] contents = this.fContext.getTranslationUnit().getContents();
        while (offset < contents.length) {
            if (contents[offset++] == '\n') break;
        }
        return offset;
    }

    private int getLineStart(int offset) {
        char[] contents = this.fContext.getTranslationUnit().getContents();
        while (--offset >= 0) {
            if (contents[offset] == '\n') break;
        }
        return offset + 1;
    }

    private int skipToNextLineAfterNode(IASTNode node) {
        return this.skipToNextLine(ASTTranslationUnit.getNodeEndOffset((IASTNode)node));
    }

    private boolean isBlankLineOrEndOfFile(int offset) {
        char[] contents = this.fContext.getTranslationUnit().getContents();
        while (offset < contents.length) {
            char c;
            if ((c = contents[offset++]) == '\n') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isPreviousLineBlank(int offset) {
        char[] contents = this.fContext.getTranslationUnit().getContents();
        while (--offset >= 0) {
            if (contents[offset] == '\n') break;
        }
        while (--offset >= 0) {
            char c = contents[offset];
            if (c == '\n') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return false;
    }

    private String getPrecedingWhitespace(IASTNode node) {
        int offset = ASTTranslationUnit.getNodeOffset((IASTNode)node);
        if (offset >= 0) {
            char[] contents = this.fContext.getTranslationUnit().getContents();
            int i = offset;
            while (--i >= 0) {
                char c = contents[i];
                if (c == '\n' || !Character.isWhitespace(c)) break;
            }
            return new String(contents, ++i, offset - i);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private int skipStandaloneCommentBlock(int offset, int endOffset, IASTComment[] comments, NodeCommentMap commentMap) {
        void var7_10;
        HashMap<IASTComment, Object> inverseLeadingMap = new HashMap<IASTComment, Object>();
        for (Map.Entry entry : commentMap.getLeadingMap().entrySet()) {
            IASTNode node = (IASTNode)entry.getKey();
            if (ASTTranslationUnit.getNodeOffset((IASTNode)node) > endOffset) continue;
            for (IASTComment comment : (List)entry.getValue()) {
                inverseLeadingMap.put(comment, node);
            }
        }
        HashMap<IASTComment, IASTNode> inverseFreestandingMap = new HashMap<IASTComment, IASTNode>();
        for (Map.Entry entry : commentMap.getFreestandingMap().entrySet()) {
            IASTNode node = (IASTNode)entry.getKey();
            if (ASTTranslationUnit.getNodeEndOffset((IASTNode)node) >= endOffset) continue;
            for (IASTComment comment : (List)entry.getValue()) {
                inverseFreestandingMap.put(comment, node);
            }
        }
        boolean bl = false;
        while (var7_10 < comments.length) {
            IASTComment comment = comments[var7_10];
            int commentOffset = ASTTranslationUnit.getNodeOffset((IASTNode)comment);
            if (commentOffset >= offset) {
                int j;
                IASTComment previous;
                if (commentOffset >= endOffset) break;
                IASTNode node = (IASTNode)inverseLeadingMap.get(comment);
                if (node != null) {
                    List leadingComments = (List)commentMap.getLeadingMap().get(node);
                    previous = (IASTComment)leadingComments.get(0);
                    j = 1;
                    while (j < leadingComments.size()) {
                        comment = (IASTComment)leadingComments.get(j);
                        if (ASTTranslationUnit.getStartingLineNumber((IASTNode)comment) > ASTTranslationUnit.getEndingLineNumber((IASTNode)previous) + 1) {
                            return this.skipToNextLineAfterNode((IASTNode)previous);
                        }
                        previous = comment;
                        ++j;
                    }
                    if (ASTTranslationUnit.getStartingLineNumber((IASTNode)node) > ASTTranslationUnit.getEndingLineNumber((IASTNode)previous) + 1) {
                        return this.skipToNextLineAfterNode((IASTNode)previous);
                    }
                }
                if ((node = (IASTNode)inverseFreestandingMap.get(comment)) != null) {
                    List freestandingComments = (List)commentMap.getFreestandingMap().get(node);
                    previous = (IASTComment)freestandingComments.get(0);
                    j = 1;
                    while (j < freestandingComments.size()) {
                        comment = (IASTComment)freestandingComments.get(j);
                        if (ASTTranslationUnit.getStartingLineNumber((IASTNode)comment) > ASTTranslationUnit.getEndingLineNumber((IASTNode)previous) + 1) {
                            return this.skipToNextLineAfterNode((IASTNode)previous);
                        }
                        previous = comment;
                        ++j;
                    }
                }
            }
            ++var7_10;
        }
        return offset;
    }

    private IncludeGroupStyle getGroupingStyle(IncludeGroupStyle style) {
        if (style.isKeepTogether()) {
            return style;
        }
        IncludeGroupStyle parent = this.getParentStyle(style);
        if (parent != null && (parent.isKeepTogether() || parent.getIncludeKind() == IncludeGroupStyle.IncludeKind.OTHER)) {
            return parent;
        }
        return this.fContext.getPreferences().includeStyles.get((Object)IncludeGroupStyle.IncludeKind.OTHER);
    }

    private IncludeGroupStyle getParentStyle(IncludeGroupStyle style) {
        IncludeGroupStyle.IncludeKind kind = style.getIncludeKind().parent;
        if (kind == null) {
            return null;
        }
        return this.fContext.getPreferences().includeStyles.get((Object)kind);
    }

    private IncludeGroupStyle getIncludeStyle(IPath headerPath) {
        IncludeGroupStyle.IncludeKind includeKind;
        IncludeInfo includeInfo = this.fContext.getIncludeForHeaderFile(headerPath);
        if (includeInfo != null && includeInfo.isSystem()) {
            includeKind = headerPath.getFileExtension() == null ? IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION : IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION;
        } else if (this.isPartnerFile(headerPath)) {
            includeKind = IncludeGroupStyle.IncludeKind.PARTNER;
        } else {
            IPath dir = this.fContext.getCurrentDirectory();
            if (dir.isPrefixOf(headerPath)) {
                includeKind = headerPath.segmentCount() == dir.segmentCount() + 1 ? IncludeGroupStyle.IncludeKind.IN_SAME_FOLDER : IncludeGroupStyle.IncludeKind.IN_SUBFOLDER;
            } else {
                IFile[] files = ResourceLookup.findFilesForLocation((IPath)headerPath);
                if (files.length == 0) {
                    includeKind = IncludeGroupStyle.IncludeKind.EXTERNAL;
                } else {
                    IProject project = this.fContext.getProject();
                    includeKind = IncludeGroupStyle.IncludeKind.IN_OTHER_PROJECT;
                    IFile[] iFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file = iFileArray[n2];
                        if (file.getProject().equals((Object)project)) {
                            includeKind = IncludeGroupStyle.IncludeKind.IN_SAME_PROJECT;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.fContext.getPreferences().includeStyles.get((Object)includeKind);
    }

    private IncludeGroupStyle getIncludeStyle(IncludeInfo includeInfo) {
        IPath path = Path.fromPortableString((String)includeInfo.getName());
        IncludeGroupStyle.IncludeKind includeKind = includeInfo.isSystem() ? (path.getFileExtension() == null ? IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION : IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION) : (this.isPartnerFile(path) ? IncludeGroupStyle.IncludeKind.PARTNER : IncludeGroupStyle.IncludeKind.EXTERNAL);
        return this.fContext.getPreferences().includeStyles.get((Object)includeKind);
    }

    private Set<IBinding> removeBindingsDefinedInIncludedHeaders(Set<IBinding> bindings, IIndexFileSet reachableHeaders) throws CoreException {
        HashSet<IBinding> filteredBindings = new HashSet<IBinding>(bindings);
        List<InclusionRequest> requests = this.createInclusionRequests(bindings, reachableHeaders);
        HashSet<IPath> allIncludedHeaders = new HashSet<IPath>();
        allIncludedHeaders.addAll(this.fContext.getHeadersAlreadyIncluded());
        allIncludedHeaders.addAll(this.fContext.getHeadersToInclude());
        for (InclusionRequest request : requests) {
            if (!this.isSatisfiedByIncludedHeaders(request, allIncludedHeaders)) continue;
            filteredBindings.remove(request.getBinding());
        }
        return filteredBindings;
    }

    protected boolean isSatisfiedByIncludedHeaders(InclusionRequest request, Set<IPath> includedHeaders) throws CoreException {
        for (IIndexFile file : request.getDeclaringFiles().keySet()) {
            IIndexInclude[] includedBy;
            IIndexInclude[] iIndexIncludeArray = includedBy = this.fContext.getIndex().findIncludedBy(file, -1);
            int n = includedBy.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude include = iIndexIncludeArray[n2];
                IPath path = IncludeOrganizer.getPath(include.getIncludedByLocation());
                if (includedHeaders.contains(path)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void processInclusionRequests(List<InclusionRequest> requests, HeaderSubstitutor headerSubstitutor) throws CoreException {
        IPath path3;
        List<IPath> candidatePaths;
        HashSet<IIndexFile> includedByPartner = this.fContext.getPreferences().allowPartnerIndirectInclusion ? new HashSet<IIndexFile>() : null;
        for (InclusionRequest request : requests) {
            candidatePaths = request.getCandidatePaths();
            if (candidatePaths.size() != 1 || !this.isPartnerFile(path3 = candidatePaths.iterator().next())) continue;
            request.resolve(path3);
            this.fContext.addHeaderToInclude(path3);
            if (includedByPartner == null) continue;
            try {
                IIndexFile indexFile = request.getDeclaringFiles().keySet().iterator().next();
                if (includedByPartner.contains(indexFile)) continue;
                IIndexInclude[] iIndexIncludeArray = indexFile.getIncludes();
                int n = iIndexIncludeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexInclude include = iIndexIncludeArray[n2];
                    this.fContext.addHeaderAlreadyIncluded(IncludeOrganizer.getPath(include.getIncludesLocation()));
                    ++n2;
                }
                includedByPartner.add(indexFile);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        for (InclusionRequest request : requests) {
            IPath path22;
            if (request.isResolved()) continue;
            candidatePaths = request.getCandidatePaths();
            HashSet<IPath> representativeHeaders = new HashSet<IPath>();
            boolean allRepresented = true;
            for (IPath path22 : candidatePaths) {
                if (this.fContext.isIncluded(path22)) {
                    request.resolve(path22);
                    if (!DEBUG_HEADER_SUBSTITUTION) break;
                    System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path22) ? " (decided earlier)" : " (was previously included)"));
                    break;
                }
                IPath header = headerSubstitutor.getUniqueRepresentativeHeader(path22);
                if (header != null) {
                    representativeHeaders.add(header);
                    continue;
                }
                allRepresented = false;
            }
            if (request.isResolved() || !allRepresented || representativeHeaders.size() != 1) continue;
            path22 = (IPath)representativeHeaders.iterator().next();
            request.resolve(path22);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + " (unique representative)");
            }
            if (this.fContext.isAlreadyIncluded(path22)) continue;
            this.fContext.addHeaderToInclude(path22);
        }
        for (InclusionRequest request : requests) {
            if (request.isResolved() || (candidatePaths = request.getCandidatePaths()).size() != 1) continue;
            path3 = candidatePaths.iterator().next();
            if (this.fContext.isIncluded(path3)) {
                request.resolve(path3);
                if (!DEBUG_HEADER_SUBSTITUTION) continue;
                System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path3) ? " (decided earlier)" : " (was previously included)"));
                continue;
            }
            IPath header = headerSubstitutor.getPreferredRepresentativeHeader(path3);
            if (header.equals((Object)path3) && this.fContext.getPreferences().heuristicHeaderSubstitution) {
                header = headerSubstitutor.getPreferredRepresentativeHeaderByHeuristic(request);
            }
            request.resolve(header);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + " (preferred representative)");
            }
            if (this.fContext.isAlreadyIncluded(header)) continue;
            this.fContext.addHeaderToInclude(header);
        }
        for (InclusionRequest request : requests) {
            if (request.isResolved()) continue;
            candidatePaths = request.getCandidatePaths();
            for (IPath path3 : candidatePaths) {
                if (!this.fContext.isIncluded(path3)) continue;
                request.resolve(path3);
                if (!DEBUG_HEADER_SUBSTITUTION) break;
                System.out.println(String.valueOf(request.toString()) + (this.fContext.isToBeIncluded(path3) ? " (decided earlier)" : " (was previously included)"));
                break;
            }
            if (request.isResolved()) continue;
            IPath header = this.fHeaderChooser.chooseHeader(request.getBinding().getName(), candidatePaths);
            if (header == null) {
                throw new OperationCanceledException();
            }
            request.resolve(header);
            if (DEBUG_HEADER_SUBSTITUTION) {
                System.out.println(String.valueOf(request.toString()) + " (user's choice)");
            }
            if (this.fContext.isAlreadyIncluded(header)) continue;
            this.fContext.addHeaderToInclude(header);
        }
        this.fContext.removeExportedHeaders();
    }

    private static IPath getPath(IIndexFileLocation location) {
        return IndexLocationFactory.getAbsolutePath((IIndexFileLocation)location);
    }

    private boolean isPartnerFile(IPath path) {
        String sourceName;
        String headerName = path.removeFileExtension().lastSegment();
        if (headerName.equals(sourceName = this.fContext.getTranslationUnit().getLocation().removeFileExtension().lastSegment())) {
            return true;
        }
        if (sourceName.startsWith(headerName)) {
            int pos = headerName.length();
            while (pos < sourceName.length() && !Character.isLetterOrDigit(sourceName.charAt(pos))) {
                ++pos;
            }
            if (pos == sourceName.length()) {
                return true;
            }
            String suffix = sourceName.substring(pos);
            String[] stringArray = this.fContext.getPreferences().partnerFileSuffixes;
            int n = this.fContext.getPreferences().partnerFileSuffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (suffix.equalsIgnoreCase(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private List<InclusionRequest> createInclusionRequests(Set<IBinding> bindingsToDefine, IIndexFileSet reachableHeaders) throws CoreException {
        ArrayList<InclusionRequest> requests = new ArrayList<InclusionRequest>(bindingsToDefine.size());
        IIndex index = this.fContext.getIndex();
        block0: for (IBinding binding : bindingsToDefine) {
            IIndexName[] indexNames = binding instanceof IFunction ? index.findDeclarations(binding) : index.findDefinitions(binding);
            if (indexNames.length == 0) continue;
            IIndexName[] iIndexNameArray = indexNames;
            int n = indexNames.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName indexName = iIndexNameArray[n2];
                IIndexFile indexFile = indexName.getFile();
                if (indexFile.getLocation().getURI().equals(this.fContext.getTranslationUnit().getLocationURI())) continue block0;
                ++n2;
            }
            HashMap<IIndexFile, IPath> declaringHeaders = new HashMap<IIndexFile, IPath>();
            HashMap<IIndexFile, IPath> reachableDeclaringHeaders = new HashMap<IIndexFile, IPath>();
            IIndexName[] iIndexNameArray2 = indexNames;
            int n3 = indexNames.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexName indexName = iIndexNameArray2[n4];
                IIndexFile indexFile = indexName.getFile();
                if (!IncludeUtil.isSource(indexFile, this.fContext.getProject()) || index.findIncludedBy(indexFile, 0).length != 0) {
                    IPath path = IncludeOrganizer.getPath(indexFile.getLocation());
                    declaringHeaders.put(indexFile, path);
                    if (reachableHeaders.contains(indexFile)) {
                        reachableDeclaringHeaders.put(indexFile, path);
                    }
                }
                ++n4;
            }
            if (declaringHeaders.isEmpty()) continue;
            boolean reachable = false;
            if (!reachableDeclaringHeaders.isEmpty()) {
                reachable = true;
                declaringHeaders = reachableDeclaringHeaders;
            }
            requests.add(new InclusionRequest(binding, declaringHeaders, reachable));
        }
        return requests;
    }

    private IncludeInfo createIncludeInfo(IPath header, IncludeGroupStyle style) {
        IncludeInfo includeInfo;
        String name = null;
        if (style.isRelativePath()) {
            name = this.getRelativePath(header);
        }
        if (name == null && (name = (includeInfo = this.fContext.getIncludeForHeaderFile(header)) != null ? includeInfo.getName() : this.getRelativePath(header)) == null) {
            name = header.toPortableString();
        }
        return new IncludeInfo(name, style.isAngleBrackets());
    }

    private String getRelativePath(IPath header) {
        IPath relativePath = PathUtil.makeRelativePath((IPath)header, (IPath)this.fContext.getCurrentDirectory());
        if (relativePath == null) {
            return null;
        }
        return relativePath.toPortableString();
    }

    private String createIncludeDirective(IncludePrototype include, String lineComment) {
        StringBuilder buf = new StringBuilder();
        if (!include.required && include.header != null) {
            switch (this.fContext.getPreferences().unusedStatementsDisposition) {
                case REMOVE: {
                    return null;
                }
                case COMMENT_OUT: {
                    buf.append("//");
                    break;
                }
            }
        }
        buf.append("#include ");
        buf.append(include.includeInfo.toString());
        buf.append(lineComment);
        return buf.toString();
    }

    private static class IncludePrototype
    implements Comparable<IncludePrototype> {
        final IPath header;
        final IncludeInfo includeInfo;
        IASTPreprocessorIncludeStatement existingInclude;
        final boolean required;
        final IncludeGroupStyle style;

        IncludePrototype(IPath header, IncludeInfo includeInfo, IncludeGroupStyle style) {
            if (includeInfo == null) {
                throw new NullPointerException();
            }
            this.header = header;
            this.includeInfo = includeInfo;
            this.style = style;
            this.required = true;
        }

        IncludePrototype(IASTPreprocessorIncludeStatement include, IPath header, IncludeInfo includeInfo, IncludeGroupStyle style) {
            if (includeInfo == null) {
                throw new NullPointerException();
            }
            this.existingInclude = include;
            this.header = header;
            this.includeInfo = includeInfo;
            this.style = style;
            this.required = false;
        }

        public void updateFrom(IncludePrototype other) {
            this.existingInclude = other.existingInclude;
        }

        public int hashCode() {
            if (this.header != null) {
                return this.header.hashCode();
            }
            return this.includeInfo.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IncludePrototype other = (IncludePrototype)obj;
            if (this.header != null) {
                return this.header.equals((Object)other.header);
            }
            if (other.header != null) {
                return false;
            }
            return this.includeInfo.equals(other.includeInfo);
        }

        public String toString() {
            return this.header != null ? this.header.toPortableString() : this.includeInfo.toString();
        }

        @Override
        public int compareTo(IncludePrototype other) {
            return this.includeInfo.compareTo(other.includeInfo);
        }
    }
}

