/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class IncludePreferences {
    private static final String DEFAULT_PARTNER_FILE_SUFFIXES = "test,unittest";
    public final Map<IncludeGroupStyle.IncludeKind, IncludeGroupStyle> includeStyles = new HashMap<IncludeGroupStyle.IncludeKind, IncludeGroupStyle>();
    public final boolean allowReordering;
    public final boolean heuristicHeaderSubstitution;
    public final boolean allowPartnerIndirectInclusion;
    public final boolean forwardDeclareCompositeTypes;
    public final boolean forwardDeclareEnums;
    public final boolean forwardDeclareFunctions;
    public final boolean forwardDeclareExternalVariables = false;
    public final boolean forwardDeclareTemplates;
    public final boolean forwardDeclareNamespaceElements;
    public final UnusedStatementDisposition unusedStatementsDisposition;
    public final String[] partnerFileSuffixes;

    public IncludePreferences(ICProject project) {
        this.loadStyle(IncludeGroupStyle.IncludeKind.RELATED, "includeStyle.related", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.PARTNER, "includeStyle.partner", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.IN_SAME_FOLDER, "includeStyle.sameFolder", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.IN_SUBFOLDER, "includeStyle.subfolder", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.SYSTEM, "includeStyle.system", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION, "includeStyle.systemWithExtension", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION, "includeStyle.systemWithoutExtension", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.OTHER, "includeStyle.other", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.IN_SAME_PROJECT, "includeStyle.inSameProject", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.IN_OTHER_PROJECT, "includeStyle.inOtherProject", project);
        this.loadStyle(IncludeGroupStyle.IncludeKind.EXTERNAL, "includeStyle.external", project);
        this.includeStyles.get((Object)IncludeGroupStyle.IncludeKind.OTHER).setKeepTogether(true);
        ArrayList<IncludeGroupStyle> styles = new ArrayList<IncludeGroupStyle>(this.includeStyles.values());
        Collections.sort(styles);
        int i = 0;
        while (i < styles.size()) {
            ((IncludeGroupStyle)styles.get(i)).setOrder(i);
            ++i;
        }
        this.forwardDeclareCompositeTypes = PreferenceConstants.getPreference("forwardDeclare.compositeTypes", project, true);
        this.forwardDeclareEnums = PreferenceConstants.getPreference("forwardDeclare.enums", project, false);
        this.forwardDeclareFunctions = PreferenceConstants.getPreference("forwardDeclare.functions", project, false);
        this.forwardDeclareTemplates = PreferenceConstants.getPreference("forwardDeclare.templates", project, false);
        this.forwardDeclareNamespaceElements = PreferenceConstants.getPreference("forwardDeclare.namespaceElements", project, true);
        String value = PreferenceConstants.getPreference("includes.partnerFileSuffixes", project, DEFAULT_PARTNER_FILE_SUFFIXES);
        this.partnerFileSuffixes = value.split(",");
        this.heuristicHeaderSubstitution = PreferenceConstants.getPreference("organizeIncludes.heuristicHeader_substitution", project, true);
        this.allowReordering = PreferenceConstants.getPreference("organizeIncludes.allowReordering", project, true);
        this.allowPartnerIndirectInclusion = false;
        value = PreferenceConstants.getPreference("organizeIncludes.unusedStatements", project, null);
        UnusedStatementDisposition disposition = null;
        if (value != null) {
            disposition = UnusedStatementDisposition.valueOf(value);
        }
        if (disposition == null) {
            disposition = UnusedStatementDisposition.COMMENT_OUT;
        }
        this.unusedStatementsDisposition = disposition;
    }

    private void loadStyle(IncludeGroupStyle.IncludeKind includeKind, String preferenceKey, ICProject project) {
        String value = PreferenceConstants.getPreference(preferenceKey, project, null);
        IncludeGroupStyle style = null;
        if (value != null) {
            style = IncludeGroupStyle.fromString(value, includeKind);
        }
        if (style == null) {
            style = new IncludeGroupStyle(includeKind);
        }
        this.includeStyles.put(includeKind, style);
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        IncludeGroupStyle style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.RELATED);
        store.setDefault("includeStyle.related", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.PARTNER);
        style.setKeepTogether(true);
        style.setBlankLineBefore(true);
        style.setOrder(0);
        store.setDefault("includeStyle.partner", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.IN_SAME_FOLDER);
        store.setDefault("includeStyle.sameFolder", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.IN_SUBFOLDER);
        store.setDefault("includeStyle.subfolder", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.SYSTEM);
        style.setKeepTogether(true);
        style.setBlankLineBefore(true);
        store.setDefault("includeStyle.system", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION);
        style.setKeepTogether(true);
        style.setAngleBrackets(true);
        style.setOrder(1);
        store.setDefault("includeStyle.systemWithExtension", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION);
        style.setKeepTogether(true);
        style.setAngleBrackets(true);
        style.setOrder(2);
        store.setDefault("includeStyle.systemWithoutExtension", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.OTHER);
        style.setKeepTogether(true);
        style.setBlankLineBefore(true);
        style.setOrder(3);
        store.setDefault("includeStyle.other", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.IN_SAME_PROJECT);
        store.setDefault("includeStyle.inSameProject", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.IN_OTHER_PROJECT);
        store.setDefault("includeStyle.inOtherProject", style.toString());
        style = new IncludeGroupStyle(IncludeGroupStyle.IncludeKind.EXTERNAL);
        store.setDefault("includeStyle.external", style.toString());
        store.setDefault("includeStyle.matchingPattern", "");
        store.setDefault("includes.partnerFileSuffixes", DEFAULT_PARTNER_FILE_SUFFIXES);
        store.setDefault("organizeIncludes.heuristicHeader_substitution", true);
        store.setDefault("organizeIncludes.allowReordering", true);
        store.setDefault("forwardDeclare.compositeTypes", true);
        store.setDefault("forwardDeclare.enums", false);
        store.setDefault("forwardDeclare.functions", false);
        store.setDefault("forwardDeclare.templates", false);
        store.setDefault("forwardDeclare.namespaceElements", true);
        store.setDefault("organizeIncludes.unusedStatements", UnusedStatementDisposition.COMMENT_OUT.toString());
    }

    public static enum UnusedStatementDisposition {
        REMOVE,
        COMMENT_OUT,
        KEEP;

    }
}

