/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.canvas;

import java.util.ArrayList;
import org.eclipse.cdt.visualizer.ui.canvas.BufferedCanvas;
import org.eclipse.cdt.visualizer.ui.canvas.IGraphicObject;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;

public class GraphicCanvas
extends BufferedCanvas {
    protected ArrayList<IGraphicObject> m_objects = new ArrayList();

    public GraphicCanvas(Composite parent) {
        super(parent);
    }

    @Override
    public void dispose() {
        if (this.m_objects != null) {
            this.m_objects.clear();
            this.m_objects = null;
        }
        super.dispose();
    }

    public void clear() {
        this.m_objects.clear();
    }

    public IGraphicObject add(IGraphicObject element) {
        if (!this.m_objects.contains(element)) {
            this.m_objects.add(element);
        }
        return element;
    }

    public void remove(IGraphicObject element) {
        this.m_objects.remove(element);
    }

    public void raiseToFront(IGraphicObject element) {
        if (this.m_objects.contains(element)) {
            this.m_objects.remove(element);
            this.m_objects.add(element);
        }
    }

    public void lowerToBack(IGraphicObject element) {
        if (this.m_objects.contains(element)) {
            this.m_objects.remove(element);
            this.m_objects.add(0, element);
        }
    }

    @Override
    public void paintCanvas(GC gc) {
        this.clearCanvas(gc);
        for (IGraphicObject gobj : this.m_objects) {
            gobj.paint(gc, false);
        }
        for (IGraphicObject gobj : this.m_objects) {
            if (!gobj.hasDecorations()) continue;
            gobj.paint(gc, true);
        }
    }

    public IGraphicObject getGraphicObject(int x, int y) {
        return this.getGraphicObject(null, x, y);
    }

    public IGraphicObject getGraphicObject(Class<?> type, int x, int y) {
        IGraphicObject result = null;
        int count = this.m_objects == null ? 0 : this.m_objects.size();
        int i = count - 1;
        while (i >= 0) {
            Class<?> objType;
            IGraphicObject gobj = this.m_objects.get(i);
            if (gobj.contains(x, y) && (type == null || type.isAssignableFrom(objType = gobj.getClass()))) {
                result = gobj;
                break;
            }
            --i;
        }
        return result;
    }

    public IGraphicObject getGraphicObjectFor(Object value) {
        IGraphicObject result = null;
        for (IGraphicObject gobj : this.m_objects) {
            if (gobj.getData() != value) continue;
            result = gobj;
            break;
        }
        return result;
    }

    public Object getDataFor(IGraphicObject IGraphicObject2) {
        return IGraphicObject2 == null ? null : IGraphicObject2.getData();
    }
}

