/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class TypeTraits {
    private TypeTraits() {
    }

    public static boolean isTrivial(ICPPClassType classType, IASTNode point) {
        ICPPClassType[] baseClasses;
        ICPPMethod[] iCPPMethodArray = ClassTypeHelper.getDeclaredMethods(classType, point);
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isVirtual()) {
                return false;
            }
            switch (ClassTypeHelper.getMethodKind(classType, method)) {
                case DEFAULT_CTOR: 
                case COPY_CTOR: 
                case MOVE_CTOR: 
                case COPY_ASSIGNMENT_OP: 
                case MOVE_ASSIGNMENT_OP: 
                case DTOR: {
                    return false;
                }
            }
            ++n2;
        }
        ICPPField[] fields = ClassTypeHelper.getDeclaredFields(classType, point);
        Object[] objectArray = fields;
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            IType fieldType;
            ICPPField field = objectArray[n];
            if (!field.isStatic() && (fieldType = SemanticUtil.getNestedType(field.getType(), 1)) instanceof ICPPClassType && !TypeTraits.isTrivial((ICPPClassType)fieldType, point)) {
                return false;
            }
            ++n;
        }
        objectArray = ClassTypeHelper.getBases(classType, point);
        n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object base = objectArray[n];
            if (base.isVirtual()) {
                return false;
            }
            ++n;
        }
        ICPPClassType[] iCPPClassTypeArray = baseClasses = ClassTypeHelper.getAllBases(classType, point);
        int n4 = baseClasses.length;
        n3 = 0;
        while (n3 < n4) {
            ICPPClassType baseClass = iCPPClassTypeArray[n3];
            if (!TypeTraits.isTrivial(baseClass, point)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean isStandardLayout(IType type, IASTNode point) {
        ICPPClassType[] baseClasses;
        if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPReferenceType) {
            return false;
        }
        if (!(type instanceof ICPPClassType)) {
            return true;
        }
        ICPPClassType classType = (ICPPClassType)type;
        int visibility = 0;
        ICPPField firstNonStaticField = null;
        ICPPField[] fields = ClassTypeHelper.getDeclaredFields(classType, point);
        Object[] objectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPField field = objectArray[n2];
            if (!field.isStatic()) {
                if (!TypeTraits.isStandardLayout(field.getType(), point)) {
                    return false;
                }
                int vis = field.getVisibility();
                if (visibility == 0) {
                    visibility = vis;
                } else if (vis != visibility) {
                    return false;
                }
                if (firstNonStaticField == null) {
                    firstNonStaticField = field;
                }
            }
            ++n2;
        }
        if (TypeTraits.hasDeclaredVirtualMethod(classType, point)) {
            return false;
        }
        objectArray = ClassTypeHelper.getBases(classType, point);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object base = objectArray[n2];
            if (base.isVirtual()) {
                return false;
            }
            ++n2;
        }
        ICPPClassType[] iCPPClassTypeArray = baseClasses = ClassTypeHelper.getAllBases(classType, point);
        int n3 = baseClasses.length;
        n = 0;
        while (n < n3) {
            ICPPClassType baseClass = iCPPClassTypeArray[n];
            if (!TypeTraits.isStandardLayout(baseClass, point)) {
                return false;
            }
            if (firstNonStaticField != null) {
                if (TypeTraits.hasNonStaticFields(baseClass, point)) {
                    return false;
                }
                if (firstNonStaticField.getType().isSameType(baseClass)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static boolean isPOD(IType type, IASTNode point) {
        if (!TypeTraits.isStandardLayout(type, point)) {
            return false;
        }
        if (!((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType)) {
            return true;
        }
        return TypeTraits.isTrivial((ICPPClassType)type, point);
    }

    public static boolean isAggregateClass(ICPPClassType classType, IASTNode point) {
        ICPPField[] fields;
        ICPPMethod[] methods;
        if (ClassTypeHelper.getBases(classType, point).length > 0) {
            return false;
        }
        ICPPMethod[] iCPPMethodArray = methods = ClassTypeHelper.getDeclaredMethods(classType, point);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod m = iCPPMethodArray[n2];
            if (m instanceof ICPPConstructor) {
                return false;
            }
            if (m.isVirtual()) {
                return false;
            }
            ++n2;
        }
        ICPPField[] iCPPFieldArray = fields = ClassTypeHelper.getDeclaredFields(classType, point);
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            ICPPField field = iCPPFieldArray[n];
            if (field.getVisibility() != 1 && !field.isStatic()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean hasTrivialCopyCtor(ICPPClassType classType, IASTNode point) {
        if (TypeTraits.getImplicitCopyCtor(classType, point) == null) {
            return false;
        }
        if (TypeTraits.isPolymorphic(classType, point)) {
            return false;
        }
        Object[] objectArray = ClassTypeHelper.getBases(classType, point);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = objectArray[n2];
            if (base.isVirtual()) {
                return false;
            }
            ++n2;
        }
        objectArray = ClassTypeHelper.getAllBases(classType, point);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Cloneable baseClass = objectArray[n2];
            if (!classType.isSameType((IType)baseClass) && !TypeTraits.hasTrivialCopyCtor((ICPPClassType)baseClass, point)) {
                return false;
            }
            ++n2;
        }
        objectArray = classType.getDeclaredFields();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            if (!field.isStatic()) {
                IType type = field.getType();
                if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType && !classType.isSameType(type) && !TypeTraits.hasTrivialCopyCtor((ICPPClassType)type, point)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean hasTrivialDefaultConstructor(ICPPClassType classType, IASTNode point) {
        ICPPBinding[] iCPPBindingArray = ClassTypeHelper.getConstructors(classType, point);
        int n = iCPPBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPBindingArray[n2];
            if (!ctor.isImplicit() && ctor.getParameters().length == 0) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = ClassTypeHelper.getAllBases(classType, null);
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding baseClass = iCPPBindingArray[n2];
            if (!classType.isSameType((IType)((Object)baseClass)) && !TypeTraits.hasTrivialDefaultConstructor((ICPPClassType)baseClass, point)) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = ClassTypeHelper.getDeclaredFields(classType, point);
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding field = iCPPBindingArray[n2];
            if (!field.isStatic()) {
                IType type = field.getType();
                if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType && !classType.isSameType(type) && !TypeTraits.hasTrivialDefaultConstructor((ICPPClassType)type, point)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean hasTrivialDestructor(ICPPClassType classType, IASTNode point) {
        ICPPBinding[] iCPPBindingArray = ClassTypeHelper.getDeclaredMethods(classType, point);
        int n = iCPPBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPBindingArray[n2];
            if (method.isDestructor()) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = ClassTypeHelper.getAllBases(classType, null);
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding baseClass = iCPPBindingArray[n2];
            if (!classType.isSameType((IType)((Object)baseClass)) && !TypeTraits.hasTrivialDestructor((ICPPClassType)baseClass, point)) {
                return false;
            }
            ++n2;
        }
        iCPPBindingArray = ClassTypeHelper.getDeclaredFields(classType, point);
        n = iCPPBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            ICPPBinding field = iCPPBindingArray[n2];
            if (!field.isStatic()) {
                IType type = field.getType();
                if ((type = SemanticUtil.getNestedType(type, 137)) instanceof ICPPClassType && !classType.isSameType(type) && !TypeTraits.hasTrivialDestructor((ICPPClassType)type, point)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean isPolymorphic(ICPPClassType classType, IASTNode point) {
        if (TypeTraits.hasDeclaredVirtualMethod(classType, point)) {
            return true;
        }
        ICPPClassType[] iCPPClassTypeArray = ClassTypeHelper.getAllBases(classType, point);
        int n = iCPPClassTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType baseClass = iCPPClassTypeArray[n2];
            if (TypeTraits.hasDeclaredVirtualMethod(baseClass, point)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasNonStaticFields(ICPPClassType classType, IASTNode point) {
        ICPPField[] fields;
        ICPPField[] iCPPFieldArray = fields = ClassTypeHelper.getDeclaredFields(classType, point);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPField field = iCPPFieldArray[n2];
            if (!field.isStatic()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAbstract(ICPPClassType classType, IASTNode point) {
        return SemanticQueries.getPureVirtualMethods(classType, point).length != 0;
    }

    private static ICPPConstructor getImplicitCopyCtor(ICPPClassType classType, IASTNode point) {
        ICPPConstructor[] iCPPConstructorArray = ClassTypeHelper.getConstructors(classType, point);
        int n = iCPPConstructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor ctor = iCPPConstructorArray[n2];
            if (ctor.isImplicit() && ClassTypeHelper.getMethodKind(classType, ctor) == ClassTypeHelper.MethodKind.COPY_CTOR) {
                return ctor;
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasDeclaredVirtualMethod(ICPPClassType classType, IASTNode point) {
        ICPPMethod[] iCPPMethodArray = ClassTypeHelper.getDeclaredMethods(classType, point);
        int n = iCPPMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.isVirtual()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

