/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.actions.FoldingActionGroup;
import org.eclipse.cdt.make.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditorMessages;
import org.eclipse.cdt.make.internal.ui.editor.MakefileSourceConfiguration;
import org.eclipse.cdt.make.internal.ui.editor.OpenDeclarationAction;
import org.eclipse.cdt.make.internal.ui.editor.ProjectionMakefileUpdater;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileWordDetector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MakefileEditor
extends TextEditor
implements ISelectionChangedListener,
IReconcilingParticipant {
    protected MakefileContentOutlinePage page;
    ProjectionSupport projectionSupport;
    ProjectionMakefileUpdater fProjectionMakefileUpdater;
    private FindReplaceDocumentAdapter fFindReplaceDocumentAdapter;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected DefaultCharacterPairMatcher fBracketMatcher = new DefaultCharacterPairMatcher(BRACKETS);
    private FoldingActionGroup fFoldingGroup;
    private ListenerList fReconcilingListeners = new ListenerList(1);

    MakefileSourceConfiguration getMakefileSourceConfiguration() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof MakefileSourceConfiguration) {
            return (MakefileSourceConfiguration)configuration;
        }
        return null;
    }

    public MakefileContentOutlinePage getOutlinePage() {
        if (this.page == null) {
            this.page = new MakefileContentOutlinePage(this);
            this.page.addSelectionChangedListener(this);
            this.page.setInput(this.getEditorInput());
        }
        return this.page;
    }

    protected void initializeEditor() {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(MakeUIPlugin.getDefault().getMakefileDocumentProvider());
        IPreferenceStore chainedStore = MakeUIPlugin.getDefault().getCombinedPreferenceStore();
        this.setPreferenceStore(chainedStore);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new MakefileSourceConfiguration(chainedStore, this));
    }

    public void dispose() {
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.uninstall();
            this.fProjectionMakefileUpdater = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        super.dispose();
    }

    boolean isFoldingEnabled() {
        return MakeUIPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(MakefileEditorMessages.MakefileEditor_menu_folding, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        this.fProjectionMakefileUpdater = new ProjectionMakefileUpdater();
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.install(this, projectionViewer);
            this.fProjectionMakefileUpdater.initialize();
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public Object getAdapter(Class key) {
        if (ProjectionAnnotationModel.class.equals((Object)key)) {
            Object result;
            if (this.projectionSupport != null && (result = this.projectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
                return result;
            }
        } else if (key.equals(IContentOutlinePage.class)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.page != null) {
            this.page.update();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = MakeUIPlugin.getDefault().getResourceBundle();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "Comment.", (ITextEditor)this, 11);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.comment");
        this.setAction("Comment", (IAction)a);
        this.markAsStateDependentAction("Comment", true);
        a = new TextOperationAction(bundle, "Uncomment.", (ITextEditor)this, 12);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.uncomment");
        this.setAction("Uncomment", (IAction)a);
        this.markAsStateDependentAction("Uncomment", true);
        a = new OpenDeclarationAction((ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.opendecl");
        this.setAction("OpenDeclarationAction", (IAction)a);
        this.markAsStateDependentAction("OpenDeclarationAction", true);
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getSourceViewer());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else if (selection instanceof IStructuredSelection) {
            Object element;
            if (!this.isActivePart() && MakeUIPlugin.getActivePage() != null) {
                MakeUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
            }
            if ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof IDirective) {
                IDirective statement = (IDirective)element;
                this.setSelection(statement, !this.isActivePart());
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals(this);
    }

    private FindReplaceDocumentAdapter getFindReplaceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(doc);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    public void setSelection(IDirective directive, boolean moveCursor) {
        int startLine = directive.getStartLine() - 1;
        int endLine = directive.getEndLine() - 1;
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int start = doc.getLineOffset(startLine);
            int len = doc.getLineLength(endLine) - 1;
            int length = doc.getLineOffset(endLine) + len - start;
            this.setHighlightRange(start, length, true);
            if (moveCursor) {
                IRegion region;
                String var = directive.toString().trim();
                MakefileWordDetector detector = new MakefileWordDetector();
                len = 0;
                while (len < var.length()) {
                    char c = var.charAt(len);
                    if (!detector.isWordPart(c) && !detector.isWordStart(c) && c != '-' && c != '_') break;
                    ++len;
                }
                if (len > 0) {
                    var = var.substring(0, len);
                }
                if ((region = this.getFindReplaceDocumentAdapter().find(start, var, true, true, true, false)) != null) {
                    len = region.getOffset();
                    length = region.getLength();
                    this.getSourceViewer().revealRange(len, length);
                    this.getSourceViewer().setSelectedRange(len, length);
                    this.markInNavigationHistory();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resetHighlightRange();
        }
        catch (BadLocationException badLocationException) {
            this.resetHighlightRange();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeReconcilingParticipant(IReconcilingParticipant listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)listener);
        }
    }

    @Override
    public void reconciled() {
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IReconcilingParticipant)listeners[i]).reconciled();
            ++i;
        }
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.install(this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    public void resetProjection() {
        if (this.fProjectionMakefileUpdater != null) {
            this.fProjectionMakefileUpdater.initialize();
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        String property = event.getProperty();
        MakefileSourceConfiguration makeConf = this.getMakefileSourceConfiguration();
        if (makeConf != null && makeConf.affectsBehavior(event)) {
            makeConf.adaptToPreferenceChange(event);
            sourceViewer.invalidateTextPresentation();
        }
        if ("editor_folding_enabled".equals(property)) {
            if (sourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.uninstall();
                }
                this.fProjectionMakefileUpdater = new ProjectionMakefileUpdater();
                if (this.fProjectionMakefileUpdater != null) {
                    this.fProjectionMakefileUpdater.install(this, projectionViewer);
                }
            }
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] parentPrefPageIds = super.collectContextMenuPreferencePages();
        String[] prefPageIds = new String[parentPrefPageIds.length + 2];
        int nIds = 0;
        prefPageIds[nIds++] = "org.eclipse.cdt.make.ui.preferences.MakeFileEditorPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.make.ui.preferences.MakefileSettingPreferencePage";
        System.arraycopy(parentPrefPageIds, 0, prefPageIds, nIds, parentPrefPageIds.length);
        return prefPageIds;
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.cdt.make.ui.makefileEditorScope"});
    }

    public int getOrientation() {
        return 0x2000000;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("editor_matching_brackets", "org.eclipse.cdt.make.ui.editor.matching.brackets.color");
    }
}

