/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.MulticoreVisualizerUIPlugin;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerCore;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerModel;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizer;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvas;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFDebugModel;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public class MulticoreVisualizerEventListener {
    protected MulticoreVisualizer fVisualizer;

    public MulticoreVisualizerEventListener(MulticoreVisualizer visualizer) {
        this.fVisualizer = visualizer;
    }

    @DsfServiceEventHandler
    public void handleEvent(final IRunControl.ISuspendedDMEvent event) {
        final VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)context;
            IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IProcesses.IThreadDMContext.class);
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), execDmc.getSessionId());
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            tracker.dispose();
            procService.getExecutionData(threadContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(){

                protected void handleSuccess() {
                    String[] cores;
                    IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                    if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
                        if (!$assertionsDisabled && cores.length != 1) {
                            throw new AssertionError();
                        }
                        int coreId = Integer.parseInt(cores[0]);
                        VisualizerCore vCore = model.getCore(coreId);
                        int tid = execDmc.getThreadId();
                        VisualizerThread thread = model.getThread(tid);
                        if (thread != null) {
                            String signalName;
                            Object miEvent;
                            if (!$assertionsDisabled && thread.getState() != VisualizerExecutionState.RUNNING) {
                                throw new AssertionError();
                            }
                            VisualizerExecutionState newState = VisualizerExecutionState.SUSPENDED;
                            if (event.getReason() == IRunControl.StateChangeReason.SIGNAL && event instanceof IMIDMEvent && (miEvent = ((IMIDMEvent)event).getMIEvent()) instanceof MISignalEvent && DSFDebugModel.isCrashSignal(signalName = ((MISignalEvent)miEvent).getName())) {
                                newState = VisualizerExecutionState.CRASHED;
                            }
                            thread.setState(newState);
                            thread.setCore(vCore);
                            MulticoreVisualizerEventListener.this.fVisualizer.refresh();
                        }
                    }
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        int tid;
        VisualizerThread thread;
        VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext && (thread = model.getThread(tid = ((IMIExecutionDMContext)context).getThreadId())) != null) {
            assert (thread.getState() == VisualizerExecutionState.SUSPENDED || thread.getState() == VisualizerExecutionState.CRASHED);
            thread.setState(VisualizerExecutionState.RUNNING);
            this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IStartedDMEvent event) {
        final VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        if (!(context instanceof IRunControl.IContainerDMContext) && context instanceof IMIExecutionDMContext) {
            final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)context;
            final IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IMIProcessDMContext.class);
            IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IProcesses.IThreadDMContext.class);
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), execDmc.getSessionId());
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            tracker.dispose();
            procService.getExecutionData(threadContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>(){

                protected void handleSuccess() {
                    String[] cores;
                    IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                    if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
                        if (!$assertionsDisabled && cores.length != 1) {
                            throw new AssertionError();
                        }
                        int coreId = Integer.parseInt(cores[0]);
                        VisualizerCore vCore = model.getCore(coreId);
                        if (vCore == null) {
                            return;
                        }
                        int pid = Integer.parseInt(processContext.getProcId());
                        int tid = execDmc.getThreadId();
                        int osTid = 0;
                        try {
                            osTid = Integer.parseInt(data.getId());
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (model.getThread(tid) == null) {
                            model.addThread(new VisualizerThread(vCore, pid, osTid, tid, VisualizerExecutionState.RUNNING));
                            MulticoreVisualizerEventListener.this.fVisualizer.getMulticoreVisualizerCanvas().requestUpdate();
                        }
                    }
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        final VisualizerModel model = this.fVisualizer.getModel();
        if (model == null) {
            return;
        }
        IDMContext context = event.getDMContext();
        final MulticoreVisualizerCanvas canvas = this.fVisualizer.getMulticoreVisualizerCanvas();
        if (context instanceof IRunControl.IContainerDMContext) {
            DsfServicesTracker tracker = new DsfServicesTracker(MulticoreVisualizerUIPlugin.getBundleContext(), context.getSessionId());
            IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
            tracker.dispose();
            procService.getProcessesBeingDebugged(context, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(){

                protected void handleSuccess() {
                    IDMContext[] contexts;
                    if (!$assertionsDisabled && this.getData() == null) {
                        throw new AssertionError();
                    }
                    IDMContext[] iDMContextArray = contexts = (IDMContext[])this.getData();
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDMContext c = iDMContextArray[n2];
                        if (c instanceof IMIExecutionDMContext) {
                            int tid = ((IMIExecutionDMContext)c).getThreadId();
                            model.markThreadExited(tid);
                        }
                        ++n2;
                    }
                    if (canvas != null) {
                        canvas.requestUpdate();
                    }
                }
            });
        } else if (context instanceof IMIExecutionDMContext) {
            int tid = ((IMIExecutionDMContext)context).getThreadId();
            model.markThreadExited(tid);
            if (canvas != null) {
                canvas.requestUpdate();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(DataModelInitializedEvent event) {
        this.fVisualizer.update();
    }
}

