/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOptionCategoryApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.EnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.internal.core.HoldsOptions;
import org.eclipse.cdt.managedbuilder.internal.core.IMatchKeyProvider;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.MatchKey;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OutputType;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.SupportedProperties;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildEntryStorage;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfoProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.framework.Version;

public class Tool
extends HoldsOptions
implements ITool,
IOptionCategory,
IMatchKeyProvider<Tool>,
IRealBuildObjectAssociation {
    public static final String DEFAULT_PATTERN = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG} ${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
    public static final String DEFAULT_CBS_PATTERN = "${COMMAND}";
    private static final String REBUILD_STATE = "rebuildState";
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = new String();
    private static final String EMPTY_QUOTED_STRING = "\"\"";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String DEFAULT_ANNOUNCEMENT_PREFIX = "Tool.default.announcement";
    private static final String WHITESPACE = " ";
    private static final boolean resolvedDefault = true;
    public static final String DEFAULT_TOOL_ID = "org.eclipse.cdt.build.core.default.tool";
    private String superClassId;
    private IBuildObject parent;
    private Vector<InputType> inputTypeList;
    private Map<String, InputType> inputTypeMap;
    private Vector<OutputType> outputTypeList;
    private Map<String, OutputType> outputTypeMap;
    private List<IEnvVarBuildPath> envVarBuildPathList;
    private String unusedChildren;
    private Boolean isAbstract;
    private String command;
    private List<String> inputExtensions;
    private List<String> interfaceExtensions;
    private Integer natureFilter;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    private String errorParserIds;
    private String commandLinePattern;
    private String versionsSupported;
    private String convertToId;
    private Boolean advancedInputCategory;
    private Boolean customBuildStep;
    private String announcement;
    private IConfigurationElement commandLineGeneratorElement = null;
    private IManagedCommandLineGenerator commandLineGenerator = null;
    private IConfigurationElement dependencyGeneratorElement = null;
    private IManagedDependencyGeneratorType dependencyGenerator = null;
    private URL iconPathURL;
    private IConfigurationElement pathconverterElement = null;
    private IOptionPathConverter optionPathConverter = null;
    private SupportedProperties supportedProperties;
    private Boolean supportsManagedBuild;
    private boolean isTest;
    private boolean isExtensionTool = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;
    private boolean rebuildState;
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private HashMap<IInputType, CLanguageData> typeToDataMap = new HashMap(2);
    private boolean fDataMapInited;
    private List<Tool> identicalList;
    private HashMap<String, CfgDiscoveredPathManager.PathInfoCache> discoveredInfoMap = new HashMap(2);
    private String scannerConfigDiscoveryProfileId;

    public Tool(IManagedConfigElement element, String managedBuildRevision) {
        super(false);
        this.resolved = false;
        this.isExtensionTool = true;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionTool(this);
        this.addOptionCategory(this);
        IManagedConfigElement[] enablements = element.getChildren("enablement");
        if (enablements.length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        IManagedConfigElement[] toolElements = element.getChildren();
        int l = 0;
        while (l < toolElements.length) {
            IManagedConfigElement toolElement = toolElements[l];
            if (!this.loadChild(toolElement)) {
                if (toolElement.getName().equals("inputType")) {
                    InputType inputType = new InputType((ITool)this, toolElement);
                    this.addInputType(inputType);
                } else if (toolElement.getName().equals("outputType")) {
                    OutputType outputType = new OutputType((ITool)this, toolElement);
                    this.addOutputType(outputType);
                } else if (toolElement.getName().equals("envVarBuildPath")) {
                    this.addEnvVarBuildPath(new EnvVarBuildPath(this, toolElement));
                } else if (toolElement.getName().equals("supportedProperties")) {
                    this.loadProperties(toolElement);
                }
            }
            ++l;
        }
    }

    public Tool(IBuildObject parent, IManagedConfigElement element, String managedBuildRevision) {
        this(element, managedBuildRevision);
        this.parent = parent;
    }

    public Tool(ToolChain parent, ITool superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.parent = parent;
        this.setSuperClassInternal(superClass);
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionTool = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTool(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public Tool(ResourceConfiguration parent, ITool superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.parent = parent;
        this.setSuperClassInternal(superClass);
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionTool = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTool(this);
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public Tool(IBuildObject parent, ICStorageElement element, String managedBuildRevision) {
        super(true);
        this.parent = parent;
        this.isExtensionTool = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        this.addOptionCategory(this);
        ICStorageElement[] toolElements = element.getChildren();
        int i = 0;
        while (i < toolElements.length) {
            ICStorageElement toolElement = toolElements[i];
            if (!this.loadChild(toolElement)) {
                if (toolElement.getName().equals("inputType")) {
                    InputType inputType = new InputType((ITool)this, toolElement);
                    this.addInputType(inputType);
                } else if (toolElement.getName().equals("outputType")) {
                    OutputType outputType = new OutputType((ITool)this, toolElement);
                    this.addOutputType(outputType);
                }
            }
            ++i;
        }
        String rebuild = PropertyManager.getInstance().getProperty(this, REBUILD_STATE);
        if (rebuild == null || Boolean.valueOf(rebuild).booleanValue()) {
            this.rebuildState = true;
        }
    }

    public Tool(IBuildObject parent, ITool toolSuperClass, String Id, String name, Tool tool) {
        this(parent, toolSuperClass.getId(), Id, name, tool);
        this.setSuperClassInternal(toolSuperClass);
    }

    public Tool(IBuildObject parent, String toolSuperClassId, String Id, String name, Tool tool) {
        super(true);
        this.parent = parent;
        this.superClassId = toolSuperClassId;
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(tool.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionTool = false;
        boolean copyIds = Id.equals(tool.id);
        if (tool.versionsSupported != null) {
            this.versionsSupported = new String(tool.versionsSupported);
        }
        if (tool.convertToId != null) {
            this.convertToId = new String(tool.convertToId);
        }
        if (tool.unusedChildren != null) {
            this.unusedChildren = new String(tool.unusedChildren);
        }
        if (tool.errorParserIds != null) {
            this.errorParserIds = new String(tool.errorParserIds);
        }
        if (tool.isAbstract != null) {
            this.isAbstract = new Boolean(tool.isAbstract);
        }
        if (tool.command != null) {
            this.command = new String(tool.command);
        }
        if (tool.commandLinePattern != null) {
            this.commandLinePattern = new String(tool.commandLinePattern);
        }
        if (tool.inputExtensions != null) {
            this.inputExtensions = new ArrayList<String>(tool.inputExtensions);
        }
        if (tool.interfaceExtensions != null) {
            this.interfaceExtensions = new ArrayList<String>(tool.interfaceExtensions);
        }
        if (tool.natureFilter != null) {
            this.natureFilter = new Integer(tool.natureFilter);
        }
        if (tool.outputExtensions != null) {
            this.outputExtensions = new String(tool.outputExtensions);
        }
        if (tool.outputFlag != null) {
            this.outputFlag = new String(tool.outputFlag);
        }
        if (tool.outputPrefix != null) {
            this.outputPrefix = new String(tool.outputPrefix);
        }
        if (tool.advancedInputCategory != null) {
            this.advancedInputCategory = new Boolean(tool.advancedInputCategory);
        }
        if (tool.customBuildStep != null) {
            this.customBuildStep = new Boolean(tool.customBuildStep);
        }
        if (tool.announcement != null) {
            this.announcement = new String(tool.announcement);
        }
        this.supportsManagedBuild = tool.supportsManagedBuild;
        this.commandLineGenerator = tool.commandLineGenerator;
        if (this.commandLineGenerator == null) {
            this.commandLineGeneratorElement = tool.commandLineGeneratorElement;
        }
        this.dependencyGenerator = tool.dependencyGenerator;
        if (this.dependencyGenerator == null) {
            this.dependencyGeneratorElement = tool.dependencyGeneratorElement;
        }
        this.pathconverterElement = tool.pathconverterElement;
        this.optionPathConverter = tool.optionPathConverter;
        if (tool.envVarBuildPathList != null) {
            this.envVarBuildPathList = new ArrayList<IEnvVarBuildPath>(tool.envVarBuildPathList);
        }
        super.copyChildren(tool);
        if (tool.inputTypeList != null) {
            HashMap clone;
            this.discoveredInfoMap = clone = (HashMap)tool.discoveredInfoMap.clone();
            for (InputType inputType : tool.getInputTypeList()) {
                String subName;
                String subId;
                CfgDiscoveredPathManager.PathInfoCache cache = this.discoveredInfoMap.remove(this.getTypeKey(inputType));
                int nnn = ManagedBuildManager.getRandomNumber();
                if (inputType.getSuperClass() != null) {
                    subId = copyIds ? inputType.id : String.valueOf(inputType.getSuperClass().getId()) + "." + nnn;
                    subName = inputType.getSuperClass().getName();
                } else {
                    subId = copyIds ? inputType.id : String.valueOf(inputType.getId()) + "." + nnn;
                    subName = inputType.getName();
                }
                InputType newInputType = new InputType(this, subId, subName, inputType);
                this.addInputType(newInputType);
                if (cache == null) continue;
                this.discoveredInfoMap.put(this.getTypeKey(newInputType), cache);
            }
        }
        if (tool.outputTypeList != null) {
            for (OutputType outputType : tool.getOutputTypeList()) {
                String subName;
                String subId;
                int nnn = ManagedBuildManager.getRandomNumber();
                if (outputType.getSuperClass() != null) {
                    subId = copyIds ? outputType.id : String.valueOf(outputType.getSuperClass().getId()) + "." + nnn;
                    subName = outputType.getSuperClass().getName();
                } else {
                    subId = copyIds ? outputType.id : String.valueOf(outputType.getId()) + "." + nnn;
                    subName = outputType.getName();
                }
                OutputType newOutputType = new OutputType(this, subId, subName, outputType);
                this.addOutputType(newOutputType);
            }
        }
        if (tool.iconPathURL != null) {
            this.iconPathURL = tool.iconPathURL;
        }
        if (copyIds) {
            this.isDirty = tool.isDirty;
            this.rebuildState = tool.rebuildState;
        } else {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    void copyNonoverriddenSettings(Tool tool) {
        String subName;
        String subId;
        int nnn;
        if (this.name == null) {
            this.setName(tool.name);
        }
        if (this.versionsSupported == null) {
            this.versionsSupported = tool.versionsSupported;
        }
        if (this.convertToId == null) {
            this.convertToId = tool.convertToId;
        }
        if (this.unusedChildren == null) {
            this.unusedChildren = tool.unusedChildren;
        }
        if (this.errorParserIds == null) {
            this.errorParserIds = tool.errorParserIds;
        }
        if (this.isAbstract == null) {
            this.isAbstract = tool.isAbstract;
        }
        if (this.command == null) {
            this.command = tool.command;
        }
        if (this.commandLinePattern == null) {
            this.commandLinePattern = tool.commandLinePattern;
        }
        if (this.inputExtensions == null && tool.inputExtensions != null) {
            this.inputExtensions = new ArrayList<String>(tool.inputExtensions);
        }
        if (this.interfaceExtensions == null && tool.interfaceExtensions != null) {
            this.interfaceExtensions = new ArrayList<String>(tool.interfaceExtensions);
        }
        if (this.natureFilter == null) {
            this.natureFilter = tool.natureFilter;
        }
        if (this.outputExtensions == null) {
            this.outputExtensions = tool.outputExtensions;
        }
        if (this.outputFlag == null) {
            this.outputFlag = tool.outputFlag;
        }
        if (this.outputPrefix == null) {
            this.outputPrefix = tool.outputPrefix;
        }
        if (this.advancedInputCategory == null) {
            this.advancedInputCategory = tool.advancedInputCategory;
        }
        if (this.customBuildStep == null) {
            this.customBuildStep = tool.customBuildStep;
        }
        if (this.announcement == null) {
            this.announcement = tool.announcement;
        }
        if (this.supportsManagedBuild == null) {
            this.supportsManagedBuild = tool.supportsManagedBuild;
        }
        if (this.commandLineGenerator == null) {
            this.commandLineGenerator = tool.commandLineGenerator;
            if (this.commandLineGenerator == null && this.commandLineGeneratorElement == null) {
                this.commandLineGeneratorElement = tool.commandLineGeneratorElement;
            }
        }
        if (this.dependencyGenerator == null) {
            this.dependencyGenerator = tool.dependencyGenerator;
            if (this.dependencyGenerator == null && this.dependencyGeneratorElement == null) {
                this.dependencyGeneratorElement = tool.dependencyGeneratorElement;
            }
        }
        if (this.optionPathConverter == null) {
            this.optionPathConverter = tool.optionPathConverter;
            if (this.optionPathConverter == null && this.pathconverterElement == null) {
                this.pathconverterElement = tool.pathconverterElement;
            }
        }
        if (this.envVarBuildPathList == null && tool.envVarBuildPathList != null) {
            this.envVarBuildPathList = new ArrayList<IEnvVarBuildPath>(tool.envVarBuildPathList);
        }
        super.copyNonoverriddenSettings(tool);
        if (this.inputTypeList == null && tool.inputTypeList != null) {
            for (InputType inputType : tool.getInputTypeList()) {
                nnn = ManagedBuildManager.getRandomNumber();
                if (inputType.getSuperClass() != null) {
                    subId = String.valueOf(inputType.getSuperClass().getId()) + "." + nnn;
                    subName = inputType.getSuperClass().getName();
                } else {
                    subId = String.valueOf(inputType.getId()) + "." + nnn;
                    subName = inputType.getName();
                }
                InputType newInputType = new InputType(this, subId, subName, inputType);
                this.addInputType(newInputType);
            }
        }
        if (this.outputTypeList == null && tool.outputTypeList != null) {
            for (OutputType outputType : tool.getOutputTypeList()) {
                nnn = ManagedBuildManager.getRandomNumber();
                if (outputType.getSuperClass() != null) {
                    subId = String.valueOf(outputType.getSuperClass().getId()) + "." + nnn;
                    subName = outputType.getSuperClass().getName();
                } else {
                    subId = String.valueOf(outputType.getId()) + "." + nnn;
                    subName = outputType.getName();
                }
                OutputType newOutputType = new OutputType(this, subId, subName, outputType);
                this.addOutputType(newOutputType);
            }
        }
        if (this.iconPathURL == null) {
            this.iconPathURL = tool.iconPathURL;
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String tmp;
        String pathconverterTypeName;
        String depGenerator;
        String cbs;
        String headers;
        String inputs;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.setVersion(this.getVersionFromId());
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        this.versionsSupported = SafeStringInterner.safeIntern((String)element.getAttribute("versionsSupported"));
        this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.errorParserIds = SafeStringInterner.safeIntern((String)SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers")));
        String nature = element.getAttribute("natureFilter");
        if (nature != null) {
            this.natureFilter = "both".equals(nature) ? new Integer(2) : ("cnature".equals(nature) ? new Integer(0) : ("ccnature".equals(nature) ? new Integer(1) : new Integer(2)));
        }
        if ((inputs = element.getAttribute("sources")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
        }
        if ((headers = element.getAttribute("headerExtensions")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInterfaceExtensionsList().add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
        }
        this.outputExtensions = SafeStringInterner.safeIntern((String)element.getAttribute("outputs"));
        this.command = SafeStringInterner.safeIntern((String)element.getAttribute("command"));
        this.outputFlag = SafeStringInterner.safeIntern((String)element.getAttribute("outputFlag"));
        this.outputPrefix = SafeStringInterner.safeIntern((String)element.getAttribute("outputPrefix"));
        this.commandLinePattern = SafeStringInterner.safeIntern((String)element.getAttribute("commandLinePattern"));
        String advInput = element.getAttribute("advancedInputCategory");
        if (advInput != null) {
            this.advancedInputCategory = new Boolean("true".equals(advInput));
        }
        if ((cbs = element.getAttribute("customBuildStep")) != null) {
            this.customBuildStep = new Boolean("true".equals(cbs));
        }
        this.announcement = SafeStringInterner.safeIntern((String)element.getAttribute("announcement"));
        String commandLineGenerator = element.getAttribute("commandLineGenerator");
        if (commandLineGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.commandLineGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((depGenerator = element.getAttribute("dependencyCalculator")) != null && element instanceof DefaultManagedConfigElement) {
            this.dependencyGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if (element.getAttribute("icon") != null && element instanceof DefaultManagedConfigElement) {
            String icon = element.getAttribute("icon");
            this.iconPathURL = ManagedBuildManager.getURLInBuildDefinitions((DefaultManagedConfigElement)element, (IPath)new Path(icon));
        }
        if ((pathconverterTypeName = element.getAttribute("optionPathConverter")) != null && element instanceof DefaultManagedConfigElement) {
            this.pathconverterElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((tmp = element.getAttribute("supportsManagedBuild")) != null) {
            this.supportsManagedBuild = Boolean.valueOf(tmp);
        }
        this.scannerConfigDiscoveryProfileId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerConfigDiscoveryProfileId"));
        tmp = element.getAttribute("isSystem");
        if (tmp != null) {
            this.isTest = Boolean.valueOf(tmp);
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String cbs;
        String advInput;
        String headers;
        StringTokenizer tokenizer;
        String inputs;
        String nature;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        this.setVersion(this.getVersionFromId());
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        if (element.getAttribute("unusedChildren") != null) {
            this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        }
        if (element.getAttribute("isAbstract") != null && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.getAttribute("versionsSupported") != null) {
            this.versionsSupported = SafeStringInterner.safeIntern((String)element.getAttribute("versionsSupported"));
        }
        if (element.getAttribute("convertToId") != null) {
            this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
        }
        if (element.getAttribute("errorParsers") != null) {
            this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        }
        if (element.getAttribute("natureFilter") != null && (nature = element.getAttribute("natureFilter")) != null) {
            this.natureFilter = "both".equals(nature) ? new Integer(2) : ("cnature".equals(nature) ? new Integer(0) : ("ccnature".equals(nature) ? new Integer(1) : new Integer(2)));
        }
        if (element.getAttribute("sources") != null && (inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
        }
        if (element.getAttribute("headerExtensions") != null && (headers = element.getAttribute("headerExtensions")) != null) {
            tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInterfaceExtensionsList().add(SafeStringInterner.safeIntern((String)tokenizer.nextToken()));
            }
        }
        if (element.getAttribute("outputs") != null) {
            this.outputExtensions = SafeStringInterner.safeIntern((String)element.getAttribute("outputs"));
        }
        if (element.getAttribute("command") != null) {
            this.command = SafeStringInterner.safeIntern((String)element.getAttribute("command"));
        }
        if (element.getAttribute("outputFlag") != null) {
            this.outputFlag = SafeStringInterner.safeIntern((String)element.getAttribute("outputFlag"));
        }
        if (element.getAttribute("outputPrefix") != null) {
            this.outputPrefix = SafeStringInterner.safeIntern((String)element.getAttribute("outputPrefix"));
        }
        if (element.getAttribute("commandLinePattern") != null) {
            this.commandLinePattern = SafeStringInterner.safeIntern((String)element.getAttribute("commandLinePattern"));
        }
        if (element.getAttribute("advancedInputCategory") != null && (advInput = element.getAttribute("advancedInputCategory")) != null) {
            this.advancedInputCategory = new Boolean("true".equals(advInput));
        }
        if (element.getAttribute("customBuildStep") != null && (cbs = element.getAttribute("customBuildStep")) != null) {
            this.customBuildStep = new Boolean("true".equals(cbs));
        }
        if (element.getAttribute("announcement") != null) {
            this.announcement = SafeStringInterner.safeIntern((String)element.getAttribute("announcement"));
        }
        if (element.getAttribute("icon") != null) {
            String iconPath = element.getAttribute("icon");
            try {
                this.iconPathURL = new URL(iconPath);
            }
            catch (MalformedURLException malformedURLException) {
                ManagedBuildManager.outputIconError(iconPath);
                this.iconPathURL = null;
            }
        }
        this.scannerConfigDiscoveryProfileId = SafeStringInterner.safeIntern((String)element.getAttribute("scannerConfigDiscoveryProfileId"));
    }

    void resolveProjectReferences(boolean onLoad) {
        if (this.superClassId != null && this.superClassId.length() > 0) {
            ITool tool = ManagedBuildManager.getExtensionTool(this.superClassId);
            if (tool == null) {
                Configuration cfg = (Configuration)this.getParentResourceInfo().getParent();
                tool = cfg.findToolById(this.superClassId);
            }
            if (tool != null) {
                this.superClass = tool;
            }
            if (onLoad) {
                this.checkForMigrationSupport();
            }
        }
    }

    private void loadProperties(IManagedConfigElement el) {
        this.supportedProperties = new SupportedProperties(el);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(ICStorageElement element) {
        try {
            if (this.getSuperClass() != null) {
                element.setAttribute("superClass", this.getSuperClass().getId());
            }
            element.setAttribute("id", this.id);
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.unusedChildren != null) {
                element.setAttribute("unusedChildren", this.unusedChildren);
            }
            if (this.isAbstract != null) {
                element.setAttribute("isAbstract", this.isAbstract.toString());
            }
            if (this.versionsSupported != null) {
                element.setAttribute("versionsSupported", this.versionsSupported);
            }
            if (this.convertToId != null) {
                element.setAttribute("convertToId", this.convertToId);
            }
            if (this.errorParserIds != null) {
                element.setAttribute("errorParsers", this.errorParserIds);
            }
            if (this.natureFilter != null) {
                void var2_5;
                if (this.natureFilter == 0) {
                    String string = "cnature";
                } else if (this.natureFilter == 1) {
                    String string = "ccnature";
                } else {
                    String string = "both";
                }
                element.setAttribute("natureFilter", (String)var2_5);
            }
            if (this.getInputExtensionsList().size() > 0) {
                ListIterator<String> listIterator = this.getInputExtensionsList().listIterator();
                String inputs = (String)listIterator.next();
                while (listIterator.hasNext()) {
                    inputs = String.valueOf(inputs) + DEFAULT_SEPARATOR;
                    inputs = String.valueOf(inputs) + (String)listIterator.next();
                }
                element.setAttribute("sources", inputs);
            }
            if (this.getInterfaceExtensionsList().size() > 0) {
                ListIterator<String> listIterator = this.getInterfaceExtensionsList().listIterator();
                String headers = (String)listIterator.next();
                while (listIterator.hasNext()) {
                    headers = String.valueOf(headers) + DEFAULT_SEPARATOR;
                    headers = String.valueOf(headers) + (String)listIterator.next();
                }
                element.setAttribute("headerExtensions", headers);
            }
            if (this.outputExtensions != null) {
                element.setAttribute("outputs", this.outputExtensions);
            }
            if (this.command != null) {
                element.setAttribute("command", this.command);
            }
            if (this.outputFlag != null) {
                element.setAttribute("outputFlag", this.outputFlag);
            }
            if (this.outputPrefix != null) {
                element.setAttribute("outputPrefix", this.outputPrefix);
            }
            if (this.commandLinePattern != null) {
                element.setAttribute("commandLinePattern", this.commandLinePattern);
            }
            if (this.advancedInputCategory != null) {
                element.setAttribute("advancedInputCategory", this.advancedInputCategory.toString());
            }
            if (this.customBuildStep != null) {
                element.setAttribute("customBuildStep", this.customBuildStep.toString());
            }
            if (this.announcement != null) {
                element.setAttribute("announcement", this.announcement);
            }
            super.serialize(element);
            for (InputType inputType : this.getInputTypeList()) {
                inputType.serialize(element.createChild("inputType"));
            }
            for (OutputType outputType : this.getOutputTypeList()) {
                outputType.serialize(element.createChild("outputType"));
            }
            if (this.iconPathURL != null) {
                element.setAttribute("icon", this.iconPathURL.toString());
            }
            if (this.scannerConfigDiscoveryProfileId != null) {
                element.setAttribute("scannerConfigDiscoveryProfileId", this.scannerConfigDiscoveryProfileId);
            }
            this.saveRebuildState();
            this.isDirty = false;
        }
        catch (Exception exception) {}
    }

    @Override
    public IBuildObject getParent() {
        return this.parent;
    }

    public void setToolParent(IBuildObject newParent) {
        this.parent = newParent;
    }

    @Override
    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    @Override
    public IInputType createInputType(IInputType superClass, String Id, String name, boolean isExtensionElement) {
        BuildLanguageData data;
        InputType type;
        InputType inputType = type = superClass == null || superClass.isExtensionElement() ? new InputType(this, superClass, Id, name, isExtensionElement) : new InputType(this, Id, name, (InputType)superClass);
        if (superClass != null && (data = (BuildLanguageData)this.typeToDataMap.remove(superClass)) != null) {
            data.updateInputType(type);
            this.typeToDataMap.put(type, data);
        }
        this.addInputType(type);
        this.setDirty(true);
        return type;
    }

    @Override
    public void removeInputType(IInputType type) {
        this.getInputTypeList().remove(type);
        this.getInputTypeMap().remove(type.getId());
        this.setDirty(true);
    }

    @Override
    public IInputType[] getInputTypes() {
        IInputType[] types = this.getAllInputTypes();
        return this.filterInputTypes(types);
    }

    public IInputType[] getAllInputTypes() {
        IInputType[] types = null;
        if (this.getSuperClass() != null) {
            types = ((Tool)this.getSuperClass()).getAllInputTypes();
        }
        Vector<InputType> ourTypes = this.getInputTypeList();
        if (types != null) {
            boolean[] typesWasReplaced = new boolean[types.length];
            int i = 0;
            while (i < ourTypes.size()) {
                IInputType ourType = ourTypes.get(i);
                int j = 0;
                while (j < types.length) {
                    IInputType otherTypeToCheck = ManagedBuildManager.getExtensionInputType(types[j]);
                    if (otherTypeToCheck == null) {
                        otherTypeToCheck = types[j];
                    }
                    if (ourType.getSuperClass() != null && ourType.getSuperClass().getId().equals(otherTypeToCheck.getId()) && !typesWasReplaced[j]) {
                        types[j] = ourType;
                        typesWasReplaced[j] = true;
                        break;
                    }
                    ++j;
                }
                if (j == types.length) {
                    IInputType[] newTypes = new IInputType[types.length + 1];
                    boolean[] newTypesWasReplaced = new boolean[types.length + 1];
                    int k = 0;
                    while (k < types.length) {
                        newTypes[k] = types[k];
                        newTypesWasReplaced[k] = typesWasReplaced[k];
                        ++k;
                    }
                    newTypes[j] = ourType;
                    types = newTypes;
                    typesWasReplaced = newTypesWasReplaced;
                }
                ++i;
            }
        } else {
            types = ourTypes.toArray(new IInputType[ourTypes.size()]);
        }
        return types;
    }

    private boolean hasInputTypes() {
        return this.getInputTypeList().size() > 0;
    }

    @Override
    public IInputType getInputTypeById(String id) {
        InputType type = (InputType)this.getAllInputTypeById(id);
        if (this.isExtensionTool || type == null || type.isEnabled(this)) {
            return type;
        }
        return null;
    }

    public IInputType getAllInputTypeById(String id) {
        IInputType type = this.getInputTypeMap().get(id);
        if (type == null && this.getSuperClass() != null) {
            return ((Tool)this.getSuperClass()).getAllInputTypeById(id);
        }
        return type;
    }

    @Override
    public IOutputType createOutputType(IOutputType superClass, String Id, String name, boolean isExtensionElement) {
        OutputType type = new OutputType(this, superClass, Id, name, isExtensionElement);
        this.addOutputType(type);
        this.setDirty(true);
        return type;
    }

    @Override
    public void removeOutputType(IOutputType type) {
        this.getOutputTypeList().remove(type);
        this.getOutputTypeMap().remove(type.getId());
        this.setDirty(true);
    }

    @Override
    public IOutputType[] getOutputTypes() {
        IOutputType[] types = this.getAllOutputTypes();
        return this.filterOutputTypes(types);
    }

    public IOutputType[] getAllOutputTypes() {
        IOutputType[] types = null;
        if (this.getSuperClass() != null) {
            types = ((Tool)this.getSuperClass()).getAllOutputTypes();
        }
        Vector<OutputType> ourTypes = this.getOutputTypeList();
        if (types != null) {
            int i = 0;
            while (i < ourTypes.size()) {
                IOutputType ourType = ourTypes.get(i);
                int j = 0;
                while (j < types.length) {
                    if (ourType.getSuperClass() != null && ourType.getSuperClass().getId().equals(types[j].getId())) {
                        types[j] = ourType;
                        break;
                    }
                    ++j;
                }
                if (j == types.length) {
                    IOutputType[] newTypes = new IOutputType[types.length + 1];
                    int k = 0;
                    while (k < types.length) {
                        newTypes[k] = types[k];
                        ++k;
                    }
                    newTypes[j] = ourType;
                    types = newTypes;
                }
                ++i;
            }
        } else {
            types = ourTypes.toArray(new IOutputType[ourTypes.size()]);
        }
        return types;
    }

    private IOutputType[] filterOutputTypes(IOutputType[] types) {
        if (this.isExtensionTool || types.length == 0) {
            return types;
        }
        ArrayList<OutputType> list = new ArrayList<OutputType>(types.length);
        IOutputType[] iOutputTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IOutputType itype = iOutputTypeArray[n2];
            OutputType type = (OutputType)itype;
            if (type.isEnabled(this)) {
                list.add(type);
            }
            ++n2;
        }
        return list.toArray(new OutputType[list.size()]);
    }

    private IInputType[] filterInputTypes(IInputType[] types) {
        if (this.isExtensionTool || types.length == 0) {
            return types;
        }
        ArrayList<InputType> list = new ArrayList<InputType>(types.length);
        IInputType[] iInputTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType itype = iInputTypeArray[n2];
            InputType type = (InputType)itype;
            if (type.isEnabled(this)) {
                list.add(type);
            }
            ++n2;
        }
        return list.toArray(new InputType[list.size()]);
    }

    private boolean hasOutputTypes() {
        Vector<OutputType> ourTypes = this.getOutputTypeList();
        return ourTypes.size() > 0;
    }

    @Override
    public IOutputType getPrimaryOutputType() {
        IOutputType type = null;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (i == 0) {
                    type = types[0];
                }
                if (types[i].getPrimaryOutput()) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    @Override
    public IOutputType getOutputTypeById(String id) {
        OutputType type = (OutputType)this.getAllOutputTypeById(id);
        if (this.isExtensionTool || type == null || type.isEnabled(this)) {
            return type;
        }
        return null;
    }

    public IOutputType getAllOutputTypeById(String id) {
        IOutputType type = this.getOutputTypeMap().get(id);
        if (type == null && this.getSuperClass() != null) {
            return ((Tool)this.getSuperClass()).getAllOutputTypeById(id);
        }
        return type;
    }

    @Override
    public IOptionCategory getOwner() {
        return null;
    }

    @Override
    public URL getIconPath() {
        if (this.iconPathURL == null && this.getSuperClass() != null) {
            return this.getSuperClass().getTopOptionCategory().getIconPath();
        }
        return this.iconPathURL;
    }

    @Override
    public Object[][] getOptions(IConfiguration configuration, IHoldsOptions optionHolder) {
        if (optionHolder != this) {
            return null;
        }
        return this.getOptions(configuration);
    }

    @Override
    public Object[][] getOptions(IConfiguration configuration) {
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            return this.getOptions(tools);
        }
        return this.getAllOptions(this);
    }

    @Override
    public Object[][] getOptions(IResourceInfo resInfo, IHoldsOptions optionHolder) {
        if (optionHolder != this) {
            return null;
        }
        return this.getOptions(resInfo);
    }

    @Override
    public Object[][] getOptions(IResourceConfiguration resConfig) {
        ITool[] tools = resConfig.getTools();
        return this.getOptions(tools);
    }

    public Object[][] getOptions(IResourceInfo resConfig) {
        ITool[] tools = resConfig.getTools();
        return this.getOptions(tools);
    }

    private Object[][] getOptions(ITool[] tools) {
        Tool catTool = this;
        ITool tool = null;
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool curTool;
            ITool superTool = curTool = iToolArray[n2];
            do {
                if (catTool != superTool) continue;
                tool = curTool;
                break;
            } while ((superTool = superTool.getSuperClass()) != null);
            if (tool != null) break;
            ++n2;
        }
        if (tool == null) {
            return null;
        }
        return this.getAllOptions(tool);
    }

    private Object[][] getAllOptions(ITool tool) {
        IOption[] allOptions = tool.getOptions();
        Object[][] myOptions = new Object[allOptions.length][2];
        int index = 0;
        IOption[] iOptionArray = allOptions;
        int n = allOptions.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            IOptionCategory optCat = option.getCategory();
            if (optCat instanceof ITool) {
                ITool current = this;
                boolean match = false;
                do {
                    if (optCat != current) continue;
                    match = true;
                    break;
                } while ((current = current.getSuperClass()) != null);
                if (match) {
                    myOptions[index] = new Object[2];
                    myOptions[index][0] = tool;
                    myOptions[index][1] = option;
                    ++index;
                }
            }
            ++n2;
        }
        return myOptions;
    }

    @Override
    public ITool getTool() {
        return this;
    }

    @Override
    public IHoldsOptions getOptionHolder() {
        return this;
    }

    private Vector<InputType> getInputTypeList() {
        if (this.inputTypeList == null) {
            this.inputTypeList = new Vector();
        }
        return this.inputTypeList;
    }

    private Map<String, InputType> getInputTypeMap() {
        if (this.inputTypeMap == null) {
            this.inputTypeMap = new HashMap<String, InputType>();
        }
        return this.inputTypeMap;
    }

    public void addInputType(InputType type) {
        this.getInputTypeList().add(type);
        this.getInputTypeMap().put(type.getId(), type);
    }

    private Vector<OutputType> getOutputTypeList() {
        if (this.outputTypeList == null) {
            this.outputTypeList = new Vector();
        }
        return this.outputTypeList;
    }

    private Map<String, OutputType> getOutputTypeMap() {
        if (this.outputTypeMap == null) {
            this.outputTypeMap = new HashMap<String, OutputType>();
        }
        return this.outputTypeMap;
    }

    public void addOutputType(OutputType type) {
        this.getOutputTypeList().add(type);
        this.getOutputTypeMap().put(type.getId(), type);
    }

    @Override
    public ITool getSuperClass() {
        return (ITool)this.superClass;
    }

    private void setSuperClassInternal(ITool superClass) {
        this.superClass = superClass;
    }

    public void setSuperClass(ITool superClass) {
        if (this.superClass != superClass) {
            this.superClass = superClass;
            this.superClassId = this.superClass == null ? null : this.superClass.getId();
            if (!this.isExtensionElement()) {
                this.setDirty(true);
            }
        }
    }

    @Override
    public String getName() {
        return this.name == null && this.getSuperClass() != null ? this.getSuperClass().getName() : this.name;
    }

    @Override
    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    @Override
    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    @Override
    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    @Override
    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = this.getSuperClass().getErrorParserIds();
        }
        return ids;
    }

    @Override
    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public Set<String> contributeErrorParsers(Set<String> set) {
        if (this.getErrorParserIds() != null) {
            String[] ids;
            if (set == null) {
                set = new HashSet<String>();
            }
            if ((ids = this.getErrorParserList()).length != 0) {
                set.addAll(Arrays.asList(ids));
            }
        }
        return set;
    }

    @Override
    public List<String> getInputExtensions() {
        String[] exts = this.getPrimaryInputExtensions();
        ArrayList<String> extList = new ArrayList<String>();
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extList.add(ext);
            ++n2;
        }
        return extList;
    }

    private List<String> getInputExtensionsAttribute() {
        if (this.inputExtensions == null || this.inputExtensions.size() == 0) {
            if (this.getSuperClass() != null) {
                return ((Tool)this.getSuperClass()).getInputExtensionsAttribute();
            }
            this.inputExtensions = new ArrayList<String>();
        }
        return this.inputExtensions;
    }

    private List<String> getInputExtensionsList() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList<String>();
        }
        return this.inputExtensions;
    }

    @Override
    public String getDefaultInputExtension() {
        String[] exts;
        IInputType type = this.getPrimaryInputType();
        if (type != null && (exts = type.getSourceExtensions(this)).length > 0) {
            return exts[0];
        }
        List<String> extsList = this.getInputExtensionsAttribute();
        if (extsList != null && extsList.size() > 0) {
            return extsList.get(0);
        }
        return EMPTY_STRING;
    }

    @Override
    public String[] getPrimaryInputExtensions() {
        String[] exts;
        IInputType type = this.getPrimaryInputType();
        if (type != null && (exts = type.getSourceExtensions(this)).length > 0) {
            return exts;
        }
        List<String> extsList = this.getInputExtensionsAttribute();
        if (extsList != null && extsList.size() > 0) {
            return extsList.toArray(new String[extsList.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getAllInputExtensions() {
        return this.getAllInputExtensions(this.getProject());
    }

    public String[] getAllInputExtensions(IProject project) {
        List<String> extsList;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            ArrayList<String> allExts = new ArrayList<String>();
            IInputType[] iInputTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String[] exts;
                IInputType type = iInputTypeArray[n2];
                String[] stringArray = exts = ((InputType)type).getSourceExtensions(this, project);
                int n3 = exts.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ext = stringArray[n4];
                    allExts.add(ext);
                    ++n4;
                }
                ++n2;
            }
            if (allExts.size() > 0) {
                return allExts.toArray(new String[allExts.size()]);
            }
        }
        if ((extsList = this.getInputExtensionsAttribute()) != null && extsList.size() > 0) {
            return extsList.toArray(new String[extsList.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public IInputType getPrimaryInputType() {
        IInputType type = null;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (i == 0) {
                    type = types[0];
                }
                if (types[i].getPrimaryInput()) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    @Override
    public IInputType getInputType(String inputExtension) {
        return this.getInputType(inputExtension, this.getProject());
    }

    public IInputType getInputType(String inputExtension, IProject project) {
        IInputType type = null;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            IInputType[] iInputTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IInputType t = iInputTypeArray[n2];
                if (((InputType)t).isSourceExtension(this, inputExtension, project)) {
                    type = t;
                    break;
                }
                ++n2;
            }
        }
        return type;
    }

    @Override
    public IPath[] getAdditionalDependencies() {
        IInputType[] types;
        ArrayList<Object> allDeps = new ArrayList<Object>();
        IInputType[] iInputTypeArray = types = this.getInputTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType type = iInputTypeArray[n2];
            IPath[] iPathArray = type.getAdditionalDependencies();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath p = iPathArray[n4];
                allDeps.add(p);
                ++n4;
            }
            if (type != this.getPrimaryInputType()) {
                if (type.getOptionId() != null) {
                    IOption option = this.getOptionBySuperClassId(type.getOptionId());
                    if (option != null) {
                        try {
                            ArrayList<IPath> inputs = new ArrayList<IPath>();
                            int optType = option.getValueType();
                            if (optType == 2) {
                                inputs.add(Path.fromOSString((String)option.getStringValue()));
                            } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                                List inputNames = (List)option.getValue();
                                this.filterValues(optType, inputNames);
                                for (String s : inputNames) {
                                    inputs.add(Path.fromOSString((String)s));
                                }
                            }
                            allDeps.addAll(inputs);
                        }
                        catch (BuildException buildException) {}
                    }
                } else if (type.getBuildVariable() != null && type.getBuildVariable().length() > 0) {
                    allDeps.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
                }
            }
            ++n2;
        }
        return allDeps.toArray(new IPath[allDeps.size()]);
    }

    @Override
    public IPath[] getAdditionalResources() {
        ArrayList<IPath> allRes = new ArrayList<IPath>();
        IInputType[] iInputTypeArray = this.getInputTypes();
        int n = iInputTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String var;
            IInputType type = iInputTypeArray[n2];
            IPath[] iPathArray = type.getAdditionalResources();
            int n3 = iPathArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath r = iPathArray[n4];
                allRes.add(r);
                ++n4;
            }
            if (type != this.getPrimaryInputType() && (var = type.getBuildVariable()) != null && var.length() > 0) {
                allRes.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
            }
            ++n2;
        }
        return allRes.toArray(new IPath[allRes.size()]);
    }

    @Override
    public String[] getAllDependencyExtensions() {
        List<String> extsList;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            ArrayList<String> allExts = new ArrayList<String>();
            IInputType[] iInputTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IInputType t = iInputTypeArray[n2];
                String[] stringArray = t.getDependencyExtensions(this);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    allExts.add(s);
                    ++n4;
                }
                ++n2;
            }
            if (allExts.size() > 0) {
                return allExts.toArray(new String[allExts.size()]);
            }
        }
        if ((extsList = this.getHeaderExtensionsAttribute()) != null && extsList.size() > 0) {
            return extsList.toArray(new String[extsList.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public List<String> getInterfaceExtensions() {
        return this.getHeaderExtensionsAttribute();
    }

    private List<String> getHeaderExtensionsAttribute() {
        if (this.interfaceExtensions == null || this.interfaceExtensions.size() == 0) {
            if (this.getSuperClass() != null) {
                return ((Tool)this.getSuperClass()).getHeaderExtensionsAttribute();
            }
            if (this.interfaceExtensions == null) {
                this.interfaceExtensions = new ArrayList<String>();
            }
        }
        return this.interfaceExtensions;
    }

    private List<String> getInterfaceExtensionsList() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList<String>();
        }
        return this.interfaceExtensions;
    }

    @Override
    public String getOutputFlag() {
        if (this.outputFlag == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOutputFlag();
            }
            return EMPTY_STRING;
        }
        return this.outputFlag;
    }

    @Override
    public String getOutputPrefix() {
        IOutputType type = null;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (i == 0) {
                    type = types[0];
                }
                if (types[i].getPrimaryOutput()) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        if (type != null) {
            return type.getOutputPrefix();
        }
        if (this.outputPrefix == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOutputPrefix();
            }
            return EMPTY_STRING;
        }
        return this.outputPrefix;
    }

    @Override
    public String getToolCommand() {
        if (this.command == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getToolCommand();
            }
            return EMPTY_STRING;
        }
        return this.command;
    }

    @Override
    public String getCommandLinePattern() {
        if (this.commandLinePattern == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getCommandLinePattern();
            }
            if (this.getCustomBuildStep()) {
                return new String(DEFAULT_CBS_PATTERN);
            }
            return new String(DEFAULT_PATTERN);
        }
        return this.commandLinePattern;
    }

    @Override
    public boolean getAdvancedInputCategory() {
        if (this.advancedInputCategory == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getAdvancedInputCategory();
            }
            return false;
        }
        return this.advancedInputCategory;
    }

    @Override
    public boolean getCustomBuildStep() {
        if (this.customBuildStep == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getCustomBuildStep();
            }
            return false;
        }
        return this.customBuildStep;
    }

    @Override
    public String getAnnouncement() {
        String an = this.getAnnouncementAttribute();
        if (an == null) {
            an = String.valueOf(ManagedMakeMessages.getResourceString(DEFAULT_ANNOUNCEMENT_PREFIX)) + WHITESPACE + this.getName();
        }
        return an;
    }

    public String getAnnouncementAttribute() {
        if (this.announcement == null) {
            if (this.getSuperClass() != null) {
                return ((Tool)this.getSuperClass()).getAnnouncementAttribute();
            }
            return null;
        }
        return this.announcement;
    }

    public IConfigurationElement getCommandLineGeneratorElement() {
        if (this.commandLineGeneratorElement == null && this.getSuperClass() != null) {
            return ((Tool)this.getSuperClass()).getCommandLineGeneratorElement();
        }
        return this.commandLineGeneratorElement;
    }

    public void setCommandLineGeneratorElement(IConfigurationElement element) {
        this.commandLineGeneratorElement = element;
        this.setDirty(true);
    }

    @Override
    public IManagedCommandLineGenerator getCommandLineGenerator() {
        if (this.commandLineGenerator != null) {
            return this.commandLineGenerator;
        }
        IConfigurationElement element = this.getCommandLineGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("commandLineGenerator") != null) {
                    this.commandLineGenerator = (IManagedCommandLineGenerator)element.createExecutableExtension("commandLineGenerator");
                    this.commandLineGeneratorElement = null;
                    return this.commandLineGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        IConfigurationElement primary;
        IInputType type = this.getPrimaryInputType();
        if (type != null && (primary = ((InputType)type).getDependencyGeneratorElement()) != null) {
            return primary;
        }
        return this.getToolDependencyGeneratorElement();
    }

    public IConfigurationElement getDependencyGeneratorElementForExtension(String sourceExt) {
        IInputType[] types = this.getInputTypes();
        if (types != null) {
            IInputType[] iInputTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IInputType type = iInputTypeArray[n2];
                if (type.isSourceExtension(this, sourceExt)) {
                    return ((InputType)type).getDependencyGeneratorElement();
                }
                ++n2;
            }
        }
        return this.getToolDependencyGeneratorElement();
    }

    private IConfigurationElement getToolDependencyGeneratorElement() {
        if (this.dependencyGeneratorElement == null && this.getSuperClass() != null) {
            return ((Tool)this.getSuperClass()).getToolDependencyGeneratorElement();
        }
        return this.dependencyGeneratorElement;
    }

    @Override
    public IManagedDependencyGenerator getDependencyGenerator() {
        if (this.dependencyGenerator != null) {
            if (this.dependencyGenerator instanceof IManagedDependencyGenerator) {
                return (IManagedDependencyGenerator)this.dependencyGenerator;
            }
            return null;
        }
        IConfigurationElement element = this.getDependencyGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGeneratorType)element.createExecutableExtension("dependencyCalculator");
                    if (this.dependencyGenerator != null) {
                        if (this.dependencyGenerator instanceof IManagedDependencyGenerator) {
                            this.dependencyGeneratorElement = null;
                            return (IManagedDependencyGenerator)this.dependencyGenerator;
                        }
                        return null;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    @Override
    public IManagedDependencyGeneratorType getDependencyGeneratorForExtension(String sourceExt) {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElementForExtension(sourceExt);
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGeneratorType)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    @Override
    public int getNatureFilter() {
        if (this.natureFilter == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getNatureFilter();
            }
            return 2;
        }
        return this.natureFilter;
    }

    public String[] getAllOutputExtensions(IProject project) {
        String[] extsList;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            ArrayList<String> allExts = new ArrayList<String>();
            IOutputType[] iOutputTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IOutputType t = iOutputTypeArray[n2];
                String[] exts = ((OutputType)t).getOutputExtensions(this, project);
                if (exts != null) {
                    String[] stringArray = exts;
                    int n3 = exts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        allExts.add(s);
                        ++n4;
                    }
                }
                ++n2;
            }
            if (allExts.size() > 0) {
                return allExts.toArray(new String[allExts.size()]);
            }
        }
        if ((extsList = this.getOutputsAttribute()) != null && extsList.length > 0) {
            return extsList;
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getAllOutputExtensions() {
        return this.getAllOutputExtensions(this.getProject());
    }

    @Override
    public String[] getOutputExtensions() {
        return this.getOutputsAttribute();
    }

    @Override
    public String[] getOutputsAttribute() {
        if (this.outputExtensions == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOutputsAttribute();
            }
            return null;
        }
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    @Override
    public String getOutputExtension(String inputExtension) {
        String[] exts;
        int i;
        IOutputType[] types = this.getOutputTypes();
        if (types != null) {
            IOutputType outType;
            i = 0;
            while (i < types.length) {
                IInputType inputType = types[i].getPrimaryInputType();
                if (inputType != null && inputType.isSourceExtension(this, inputExtension) && (exts = types[i].getOutputExtensions(this)) != null && exts.length > 0) {
                    return exts[0];
                }
                ++i;
            }
            if (this.getInputType(inputExtension) != null && (exts = (outType = this.getPrimaryOutputType()).getOutputExtensions(this)) != null && exts.length > 0) {
                return exts[0];
            }
        }
        String[] inputExts = this.getAllInputExtensions();
        i = 0;
        while (i < inputExts.length) {
            if (inputExts[i].equals(inputExtension) && (exts = this.getOutputsAttribute()) != null) {
                if (i < exts.length) {
                    return exts[i];
                }
                return exts[exts.length - 1];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IOutputType getOutputType(String outputExtension) {
        IOutputType type = null;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            IOutputType[] iOutputTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IOutputType t = iOutputTypeArray[n2];
                if (t.isOutputExtension(this, outputExtension)) {
                    type = t;
                    break;
                }
                ++n2;
            }
        }
        return type;
    }

    @Override
    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    @Override
    public boolean setToolCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return false;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.isDirty = true;
            this.setRebuildState(true);
            return true;
        }
        return false;
    }

    @Override
    public void setCommandLinePattern(String pattern) {
        if (pattern == null && this.commandLinePattern == null) {
            return;
        }
        if (pattern == null || this.commandLinePattern == null || !pattern.equals(this.commandLinePattern)) {
            this.commandLinePattern = pattern;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    @Override
    public void setOutputFlag(String flag) {
        if (flag == null && this.outputFlag == null) {
            return;
        }
        if (this.outputFlag == null || flag == null || !flag.equals(this.outputFlag)) {
            this.outputFlag = flag;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    @Override
    public void setOutputPrefix(String prefix) {
        if (prefix == null && this.outputPrefix == null) {
            return;
        }
        if (this.outputPrefix == null || prefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.setRebuildState(true);
            this.isDirty = true;
        }
    }

    @Override
    public void setOutputPrefixForPrimaryOutput(String prefix) {
        if (prefix != null && prefix.equals(this.getOutputPrefix())) {
            return;
        }
        IOutputType type = this.getPrimaryOutputType();
        if (type == null) {
            this.setOutputPrefix(prefix);
        } else {
            this.setOutputPrefixForType(type, prefix);
        }
    }

    private void setOutputPrefixForType(IOutputType type, String prefix) {
        if (prefix == null && type.getParent() != this) {
            return;
        }
        type = this.getEditableOutputType(type);
        type.setOutputPrefix(prefix);
        this.setRebuildState(true);
        this.isDirty = true;
    }

    @Override
    public void setOutputsAttribute(String ext) {
        if (ext == null && this.outputExtensions == null) {
            return;
        }
        if (this.outputExtensions == null || ext == null || !ext.equals(this.outputExtensions)) {
            this.outputExtensions = ext;
            this.isDirty = true;
        }
    }

    @Override
    public void setAdvancedInputCategory(boolean b) {
        if (this.advancedInputCategory == null || b != this.advancedInputCategory) {
            this.advancedInputCategory = new Boolean(b);
            this.setDirty(true);
        }
    }

    @Override
    public void setCustomBuildStep(boolean b) {
        if (this.customBuildStep == null || b != this.customBuildStep) {
            this.customBuildStep = new Boolean(b);
            this.setDirty(true);
        }
    }

    @Override
    public void setAnnouncement(String newText) {
        if (newText == null && this.announcement == null) {
            return;
        }
        if (this.announcement == null || newText == null || !newText.equals(this.announcement)) {
            this.announcement = newText;
            this.setDirty(true);
        }
    }

    @Override
    public String[] getCommandFlags() throws BuildException {
        return this.getToolCommandFlags(null, null);
    }

    @Override
    public String getToolFlags() throws BuildException {
        return this.getToolCommandFlagsString(null, null);
    }

    public String[] getToolCommandFlags(IPath inputFileLocation, IPath outputFileLocation, SupplierBasedCdtVariableSubstitutor macroSubstitutor, IMacroContextInfoProvider provider) {
        IOption[] opts = this.getOptions();
        ArrayList<String> flags = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        IOption[] iOptionArray = opts;
        int n = opts.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (option != null) {
                sb.setLength(0);
                IOptionApplicability applicabilityCalculator = option.getApplicabilityCalculator();
                IOptionCategory cat = option.getCategory();
                IOptionCategoryApplicability catApplicabilityCalculator = cat.getApplicabilityCalculator();
                IBuildObject config = null;
                IBuildObject parent = this.getParent();
                if (parent instanceof IResourceConfiguration) {
                    config = parent;
                } else if (parent instanceof IToolChain) {
                    config = ((IToolChain)parent).getParent();
                }
                if ((catApplicabilityCalculator == null || catApplicabilityCalculator.isOptionCategoryVisible(config, this, cat)) && (applicabilityCalculator == null || applicabilityCalculator.isOptionUsedInCommandLine(config, this, option))) {
                    Status s;
                    if (applicabilityCalculator != null && !(applicabilityCalculator instanceof BooleanExpressionApplicabilityCalculator)) {
                        option = option.getSuperClass() != null ? this.getOptionBySuperClassId(option.getSuperClass().getId()) : (option.isExtensionElement() ? this.getOptionBySuperClassId(option.getId()) : this.getOptionById(option.getId()));
                    }
                    try {
                        IMacroContextInfo info;
                        boolean generateDefaultCommand = true;
                        IOptionCommandGenerator commandGenerator = option.getCommandGenerator();
                        if (commandGenerator != null && (info = provider.getMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this))) != null) {
                            macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info);
                            String command = commandGenerator.generateCommand(option, (IVariableSubstitutor)macroSubstitutor);
                            if (command != null) {
                                sb.append(command);
                                generateDefaultCommand = false;
                            }
                        }
                        if (generateDefaultCommand) {
                            switch (option.getValueType()) {
                                case 0: {
                                    String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                                    if (boolCmd == null || boolCmd.length() <= 0) break;
                                    sb.append(boolCmd);
                                    break;
                                }
                                case 1: {
                                    String enumVal = option.getEnumCommand(option.getSelectedEnum());
                                    if (enumVal.length() <= 0) break;
                                    sb.append(enumVal);
                                    break;
                                }
                                case 12: {
                                    String treeVal = option.getCommand(option.getStringValue());
                                    if (treeVal.length() <= 0) break;
                                    sb.append(treeVal);
                                    break;
                                }
                                case 2: {
                                    String strCmd = option.getCommand();
                                    String val = option.getStringValue();
                                    IMacroContextInfo info2 = provider.getMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                                    if (info2 == null) break;
                                    macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info2);
                                    if (val.length() <= 0 || (val = CdtVariableResolver.resolveToString((String)val, (IVariableSubstitutor)macroSubstitutor)).length() <= 0) break;
                                    sb.append(this.evaluateCommand(strCmd, val));
                                    break;
                                }
                                case -11: 
                                case -10: 
                                case -9: 
                                case -8: 
                                case -4: 
                                case 3: 
                                case 4: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: {
                                    String temp;
                                    String listCmd = option.getCommand();
                                    IMacroContextInfo info3 = provider.getMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                                    if (info3 == null) break;
                                    macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info3);
                                    String[] list = CdtVariableResolver.resolveStringListValues((String[])option.getBasicStringListValue(), (IVariableSubstitutor)macroSubstitutor, (boolean)true);
                                    if (list == null) break;
                                    String[] stringArray = list;
                                    int n3 = list.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        temp = stringArray[n4];
                                        if (temp.length() > 0 && !temp.equals(EMPTY_QUOTED_STRING)) {
                                            sb.append(String.valueOf(this.evaluateCommand(listCmd, temp)) + WHITESPACE);
                                        }
                                        ++n4;
                                    }
                                    break;
                                }
                                case -5: 
                                case 5: {
                                    String temp;
                                    String defCmd = option.getCommand();
                                    IMacroContextInfo info3 = provider.getMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                                    if (info3 == null) break;
                                    macroSubstitutor.setMacroContextInfo((IVariableContextInfo)info3);
                                    String[] symbols = CdtVariableResolver.resolveStringListValues((String[])option.getBasicStringListValue(), (IVariableSubstitutor)macroSubstitutor, (boolean)true);
                                    if (symbols == null) break;
                                    String[] stringArray = symbols;
                                    int n3 = symbols.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        temp = stringArray[n4];
                                        if (temp.length() > 0) {
                                            sb.append(String.valueOf(this.evaluateCommand(defCmd, temp)) + WHITESPACE);
                                        }
                                        ++n4;
                                    }
                                    break;
                                }
                            }
                        }
                        if (sb.toString().trim().length() > 0) {
                            flags.add(sb.toString().trim());
                        }
                    }
                    catch (BuildException e) {
                        s = new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), MessageFormat.format(ManagedMakeMessages.getString("Tool_Problem_Discovering_Args_For_Option"), option, option.getId()), (Throwable)e);
                        ManagedBuilderCorePlugin.log(new CoreException((IStatus)s));
                    }
                    catch (CdtVariableException e) {
                        s = new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), MessageFormat.format(ManagedMakeMessages.getString("Tool_Problem_Discovering_Args_For_Option"), option, option.getId()), (Throwable)e);
                        ManagedBuilderCorePlugin.log(new CoreException((IStatus)s));
                    }
                }
            }
            ++n2;
        }
        String[] f = new String[flags.size()];
        return flags.toArray(f);
    }

    @Override
    public String[] getToolCommandFlags(IPath inputFileLocation, IPath outputFileLocation) throws BuildException {
        BuildfileMacroSubstitutor macroSubstitutor = new BuildfileMacroSubstitutor(null, EMPTY_STRING, WHITESPACE);
        return this.getToolCommandFlags(inputFileLocation, outputFileLocation, macroSubstitutor, BuildMacroProvider.getDefault());
    }

    @Override
    public String getToolCommandFlagsString(IPath inputFileLocation, IPath outputFileLocation) throws BuildException {
        String[] flags;
        StringBuilder buf = new StringBuilder();
        String[] stringArray = flags = this.getToolCommandFlags(inputFileLocation, outputFileLocation);
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            if (flag != null) {
                buf.append(String.valueOf(flag) + WHITESPACE);
            }
            ++n2;
        }
        return buf.toString().trim();
    }

    @Override
    public boolean isHeaderFile(String ext) {
        String[] exts;
        if (ext == null) {
            return false;
        }
        String[] stringArray = exts = this.getAllDependencyExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String dep = stringArray[n2];
            if (ext.equals(dep)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean buildsFileType(String extension) {
        return this.buildsFileType(extension, this.getProject());
    }

    public boolean buildsFileType(String extension, IProject project) {
        if (extension == null) {
            return false;
        }
        IInputType it = this.getInputType(extension, project);
        if (it != null) {
            if (it == this.getPrimaryInputType()) {
                return true;
            }
            if (it.getOptionId() != null && it.getOptionId().length() > 0) {
                return false;
            }
            return it.getAssignToOptionId() == null || it.getAssignToOptionId().length() <= 0;
        }
        if (!this.hasInputTypes()) {
            return this.getInputExtensionsAttribute().contains(extension);
        }
        return false;
    }

    @Override
    public boolean isInputFileType(String extension) {
        if (extension == null) {
            return false;
        }
        IInputType it = this.getInputType(extension);
        if (it != null) {
            return true;
        }
        if (!this.hasInputTypes()) {
            return this.getInputExtensionsAttribute().contains(extension);
        }
        return false;
    }

    @Override
    public boolean producesFileType(String extension) {
        String[] exts;
        if (extension == null) {
            return false;
        }
        if (this.getOutputType(extension) != null) {
            return true;
        }
        if (!this.hasOutputTypes() && (exts = this.getOutputsAttribute()) != null) {
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.equals(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IConfigurationElement getPathconverterElement() {
        return this.pathconverterElement;
    }

    @Override
    public IOptionPathConverter getOptionPathConverter() {
        if (this.optionPathConverter != null) {
            return this.optionPathConverter;
        }
        if (this.optionPathConverter == null) {
            IResourceConfiguration resourceConfiguration;
            IConfiguration configuration;
            IConfigurationElement element = this.getPathconverterElement();
            if (element != null) {
                try {
                    if (element.getAttribute("optionPathConverter") != null) {
                        this.optionPathConverter = (IOptionPathConverter)element.createExecutableExtension("optionPathConverter");
                    }
                }
                catch (CoreException coreException) {}
            }
            if (this.optionPathConverter == null && this.getSuperClass() != null) {
                ITool superTool = this.getSuperClass();
                this.optionPathConverter = superTool.getOptionPathConverter();
            }
            if (this.optionPathConverter == null && this.getParent() instanceof IResourceConfiguration && (configuration = (resourceConfiguration = (IResourceConfiguration)this.getParent()).getParent()) != null) {
                IToolChain toolchain = configuration.getToolChain();
                this.optionPathConverter = toolchain.getOptionPathConverter();
            }
            if (this.optionPathConverter == null && this.getParent() instanceof IToolChain) {
                IToolChain toolchain = (IToolChain)this.getParent();
                this.optionPathConverter = toolchain.getOptionPathConverter();
            }
        }
        this.pathconverterElement = null;
        return this.optionPathConverter;
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionTool;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionTool) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        for (InputType inputType : this.getInputTypeList()) {
            if (!inputType.isDirty()) continue;
            return true;
        }
        for (OutputType outputType : this.getOutputTypeList()) {
            if (!outputType.isDirty()) continue;
            return true;
        }
        if (super.isDirty()) {
            return true;
        }
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        super.setDirty(isDirty);
        if (!isDirty) {
            for (InputType inputType : this.getInputTypeList()) {
                inputType.setDirty(false);
            }
            for (OutputType outputType : this.getOutputTypeList()) {
                outputType.setDirty(false);
            }
        }
    }

    @Override
    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.setSuperClassInternal(ManagedBuildManager.getExtensionTool(this.superClassId));
                if (this.getSuperClass() == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "tool", this.getId());
                } else {
                    ((Tool)this.getSuperClass()).resolveReferences();
                }
            }
            super.resolveReferences();
            for (InputType inputType : this.getInputTypeList()) {
                inputType.resolveReferences();
            }
            for (OutputType outputType : this.getOutputTypeList()) {
                outputType.resolveReferences();
            }
        }
    }

    public String evaluateCommand(String command, String values) {
        int len;
        int index;
        if (command == null) {
            return values.trim();
        }
        String ret = command;
        boolean found = false;
        int start = 0;
        while ((index = ret.indexOf("${", start)) >= 0 && (len = ret.length()) >= index + 8) {
            start = index;
            char ch = ret.charAt(index += 2);
            if (!(ch != 'v' && ch != 'V' || (ch = ret.charAt(++index)) != 'a' && ch != 'A' || (ch = ret.charAt(++index)) != 'l' && ch != 'L' || (ch = ret.charAt(++index)) != 'u' && ch != 'U' || (ch = ret.charAt(++index)) != 'e' && ch != 'E' || (ch = ret.charAt(++index)) != '}')) {
                String temp = "";
                ++index;
                found = true;
                if (start > 0) {
                    temp = ret.substring(0, start);
                }
                temp = temp.concat(values.trim());
                if (len > index) {
                    start = temp.length();
                    ret = temp.concat(ret.substring(index));
                    index = start;
                } else {
                    ret = temp;
                    break;
                }
            }
            start = index;
        }
        if (found) {
            return ret.trim();
        }
        return new String(String.valueOf(command) + values).trim();
    }

    @Override
    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    @Override
    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    @Override
    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    @Override
    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    @Override
    public IEnvVarBuildPath[] getEnvVarBuildPaths() {
        if (this.envVarBuildPathList != null) {
            return this.envVarBuildPathList.toArray(new IEnvVarBuildPath[this.envVarBuildPathList.size()]);
        }
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getEnvVarBuildPaths();
        }
        return null;
    }

    private void addEnvVarBuildPath(IEnvVarBuildPath path) {
        if (path == null) {
            return;
        }
        if (this.envVarBuildPathList == null) {
            this.envVarBuildPathList = new ArrayList<IEnvVarBuildPath>();
        }
        this.envVarBuildPathList.add(path);
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = ManagedBuildManager.getExtensionToolMap().lastKey();
            SortedMap<String, ? extends ITool> subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IToolChain parent = (IToolChain)this.getParent();
                IConfiguration parentConfig = parent.getParent();
                IManagedProject iManagedProject = parentConfig.getManagedProject();
                if (iManagedProject != null) {
                    iManagedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionToolMap().subMap(this.superClassId, String.valueOf(high) + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.superClassId);
            for (ITool iTool : subMap.values()) {
                String[] tmpVersions;
                String versionsSupported;
                if (ManagedBuildManager.getIdFromIdAndVersion(iTool.getId()).compareTo(baseId) > 0) break;
                if (!ManagedBuildManager.getIdFromIdAndVersion(iTool.getId()).equals(baseId) || (versionsSupported = iTool.getVersionsSupported()) == null || versionsSupported.equals("")) continue;
                String[] stringArray = tmpVersions = versionsSupported.split(DEFAULT_SEPARATOR);
                int n = tmpVersions.length;
                int n2 = 0;
                while (n2 < n) {
                    String tmpVersion = stringArray[n2];
                    if (new Version(version).equals((Object)new Version(tmpVersion))) {
                        String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(iTool.getId());
                        this.setId(String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(this.getId())) + "_" + supportedVersion);
                        this.setSuperClassInternal(iTool);
                        this.superClassId = this.getSuperClass().getId();
                        isExists = true;
                        break;
                    }
                    ++n2;
                }
                if (!isExists) continue;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.equals("")) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IToolChain parent = (IToolChain)this.getParent();
            IConfiguration parentConfig = parent.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IToolChain parent;
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            Version currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.compareTo(new Version(mbsVersion)) > 0) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if ((managedProject = (parentConfig = (parent = (IToolChain)this.getParent()).getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    public IProject getProject() {
        IBuildObject toolParent = this.getParent();
        if (toolParent != null) {
            if (toolParent instanceof IToolChain) {
                IConfiguration config = ((IToolChain)toolParent).getParent();
                if (config == null) {
                    return null;
                }
                return (IProject)config.getOwner();
            }
            if (toolParent instanceof IResourceConfiguration) {
                return (IProject)((IResourceConfiguration)toolParent).getOwner();
            }
        }
        return null;
    }

    public String[] getContentTypeFileSpecs(IContentType type) {
        return this.getContentTypeFileSpecs(type, this.getProject());
    }

    public String[] getContentTypeFileSpecs(IContentType type, IProject project) {
        String[] globalSpecs = type.getFileSpecs(8);
        IContentTypeSettings settings = null;
        if (project != null) {
            String[] specs;
            ProjectScope projectScope = new ProjectScope(project);
            try {
                settings = type.getSettings((IScopeContext)projectScope);
            }
            catch (Exception exception) {}
            if (settings != null && (specs = settings.getFileSpecs(8)).length > 0) {
                String spec;
                int total = globalSpecs.length + specs.length;
                String[] projSpecs = new String[total];
                int i = 0;
                String[] stringArray = specs;
                int n = specs.length;
                int n2 = 0;
                while (n2 < n) {
                    projSpecs[i] = spec = stringArray[n2];
                    ++i;
                    ++n2;
                }
                stringArray = globalSpecs;
                n = globalSpecs.length;
                n2 = 0;
                while (n2 < n) {
                    projSpecs[i] = spec = stringArray[n2];
                    ++i;
                    ++n2;
                }
                return projSpecs;
            }
        }
        return globalSpecs;
    }

    @Override
    public boolean needsRebuild() {
        if (this.rebuildState) {
            return true;
        }
        for (InputType inputType : this.getInputTypeList()) {
            if (!inputType.needsRebuild()) continue;
            return true;
        }
        for (OutputType outputType : this.getOutputTypeList()) {
            if (!outputType.needsRebuild()) continue;
            return true;
        }
        return super.needsRebuild();
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        if (this.rebuildState != rebuild) {
            this.rebuildState = rebuild;
            this.saveRebuildState();
        }
        if (!rebuild) {
            super.setRebuildState(rebuild);
            if (!rebuild) {
                for (InputType inputType : this.getInputTypeList()) {
                    inputType.setRebuildState(false);
                }
                for (OutputType outputType : this.getOutputTypeList()) {
                    outputType.setRebuildState(false);
                }
            }
        }
    }

    private void saveRebuildState() {
        PropertyManager.getInstance().setProperty(this, REBUILD_STATE, Boolean.toString(this.rebuildState));
    }

    @Override
    public CLanguageData getCLanguageData(IInputType type) {
        this.initDataMap();
        return this.typeToDataMap.get(type);
    }

    private void initDataMap() {
        if (this.fDataMapInited) {
            return;
        }
        List<IInputType> types = this.getLanguageInputTypes();
        if (types != null) {
            if (types.size() == 0) {
                CLanguageData data = this.typeToDataMap.get(null);
                if (data == null) {
                    data = new BuildLanguageData(this, null);
                    if (this.typeToDataMap.size() != 0) {
                        this.typeToDataMap.clear();
                    }
                    this.typeToDataMap.put(null, data);
                }
            } else {
                ListIterator<IInputType> iter = types.listIterator();
                while (iter.hasNext()) {
                    IInputType type = iter.next();
                    iter.set(this.getEditableInputType(type));
                }
                Map map = (Map)this.typeToDataMap.clone();
                for (IInputType type : types) {
                    CLanguageData data = (CLanguageData)map.remove(type);
                    if (data != null) continue;
                    data = new BuildLanguageData(this, type);
                    this.typeToDataMap.put(type, data);
                }
                if (map.size() > 0) {
                    for (IInputType it : map.keySet()) {
                        this.typeToDataMap.remove(it);
                    }
                }
            }
        }
        this.fDataMapInited = true;
    }

    private boolean isLanguageInputType(IInputType type, boolean checkLangSettings) {
        boolean supports;
        boolean bl = supports = type.getLanguageId(this) != null || this.typeContributesToScannerConfig((InputType)type);
        if (supports && checkLangSettings) {
            supports = this.supportsLanguageSettings();
        }
        return supports;
    }

    public boolean supportsLanguageSettings() {
        IOption[] options = this.getOptions();
        boolean found = false;
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            try {
                int type = option.getValueType();
                if (ManagedBuildManager.optionTypeToEntryKind(type) != 0) {
                    found = true;
                    break;
                }
            }
            catch (BuildException buildException) {}
            ++n2;
        }
        return found;
    }

    private List<IInputType> getLanguageInputTypes() {
        boolean found;
        IInputType t;
        IInputType[] types;
        ArrayList<IInputType> list = new ArrayList<IInputType>();
        IInputType[] iInputTypeArray = types = this.getInputTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            t = iInputTypeArray[n2];
            InputType type = (InputType)t;
            if (this.isLanguageInputType(type, false)) {
                list.add(type);
            }
            ++n2;
        }
        if (list.size() == 0) {
            if (types.length == 1) {
                list.add(types[0]);
            } else {
                iInputTypeArray = types;
                n = types.length;
                n2 = 0;
                while (n2 < n) {
                    t = iInputTypeArray[n2];
                    if (t.getPrimaryInput()) {
                        list.add(t);
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (!(found = this.supportsLanguageSettings())) {
            return null;
        }
        return list;
    }

    @Override
    public CLanguageData[] getCLanguageDatas() {
        this.initDataMap();
        return this.typeToDataMap.values().toArray(new BuildLanguageData[this.typeToDataMap.size()]);
    }

    @Override
    public IInputType getInputTypeForCLanguageData(CLanguageData data) {
        if (data instanceof BuildLanguageData) {
            return ((BuildLanguageData)data).getInputType();
        }
        return null;
    }

    @Override
    public IResourceInfo getParentResourceInfo() {
        if (this.parent instanceof IFileInfo) {
            return (IResourceInfo)this.parent;
        }
        if (this.parent instanceof IToolChain) {
            return ((IToolChain)this.parent).getParentFolderInfo();
        }
        return null;
    }

    @Override
    public IInputType getEditableInputType(IInputType base) {
        IAdditionalInput[] addlInputs;
        if (base.getParent() == this) {
            return base;
        }
        IInputType extType = base;
        while (extType != null && !extType.isExtensionElement()) {
            extType = extType.getSuperClass();
        }
        String id = extType != null ? ManagedBuildManager.calculateChildId(extType.getId(), null) : ManagedBuildManager.calculateChildId(this.getId(), null);
        InputType newType = (InputType)this.createInputType(base, id, base.getName(), false);
        IAdditionalInput[] iAdditionalInputArray = addlInputs = base.getAdditionalInputs();
        int n = addlInputs.length;
        int n2 = 0;
        while (n2 < n) {
            IAdditionalInput addlInput = iAdditionalInputArray[n2];
            newType.createAdditionalInput(addlInput);
            ++n2;
        }
        return newType;
    }

    @Override
    public IOutputType getEditableOutputType(IOutputType base) {
        if (base.getParent() == this) {
            return base;
        }
        IOutputType extType = base;
        while (extType != null && !extType.isExtensionElement()) {
            extType = extType.getSuperClass();
        }
        String id = extType != null ? ManagedBuildManager.calculateChildId(extType.getId(), null) : ManagedBuildManager.calculateChildId(this.getId(), null);
        IOutputType newType = this.createOutputType(base, id, base.getName(), false);
        return newType;
    }

    @Override
    public boolean supportsType(IBuildPropertyType type) {
        return this.supportsType(type.getId());
    }

    @Override
    public boolean supportsType(String type) {
        boolean suports = false;
        SupportedProperties props = this.findSupportedProperties();
        if (props != null) {
            suports = props.supportsType(type);
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            if (calc != null) {
                suports = calc.referesProperty(type);
            }
            if (!suports) {
                suports = super.supportsType(type);
            }
        }
        return suports;
    }

    @Override
    public boolean supportsValue(String type, String value) {
        boolean suports = false;
        SupportedProperties props = this.findSupportedProperties();
        if (props != null) {
            suports = props.supportsValue(type, value);
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            if (calc != null) {
                suports = calc.referesPropertyValue(type, value);
            }
            if (!suports) {
                suports = super.supportsValue(type, value);
            }
        }
        return suports;
    }

    @Override
    public boolean supportsValue(IBuildPropertyType type, IBuildPropertyValue value) {
        return this.supportsValue(type.getId(), value.getId());
    }

    @Override
    public void propertiesChanged() {
        if (this.isExtensionTool) {
            return;
        }
        BooleanExpressionApplicabilityCalculator calculator = this.getBooleanExpressionCalculator();
        if (calculator != null) {
            calculator.adjustTool(this.getParentResourceInfo(), this, false);
        }
        super.propertiesChanged();
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.superClass != null) {
            return ((Tool)this.superClass).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled(this.getParentResourceInfo());
    }

    public boolean isEnabled(IResourceInfo rcInfo) {
        BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
        if (calc == null) {
            return true;
        }
        return calc.isToolUsedInCommandLine(rcInfo, this);
    }

    @Override
    public boolean matches(ITool tool) {
        if (tool == this) {
            return true;
        }
        ITool rT = ManagedBuildManager.getRealTool(this);
        if (rT == null) {
            return false;
        }
        return rT == ManagedBuildManager.getRealTool(tool);
    }

    private SupportedProperties findSupportedProperties() {
        if (this.supportedProperties == null && this.superClass != null) {
            return ((Tool)this.superClass).findSupportedProperties();
        }
        return this.supportedProperties;
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        if (this.supportsManagedBuild == null) {
            if (this.superClass != null) {
                return ((Tool)this.superClass).supportsBuild(managed);
            }
            return true;
        }
        return this.supportsManagedBuild;
    }

    @Override
    public MatchKey<Tool> getMatchKey() {
        if (this.isAbstract()) {
            return null;
        }
        if (!this.isExtensionTool) {
            return null;
        }
        return new MatchKey<Tool>(this);
    }

    @Override
    public void setIdenticalList(List<Tool> list) {
        this.identicalList = list;
    }

    public String getNameAndVersion() {
        String name = this.getName();
        String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
        if (version != null && version.length() != 0) {
            return name + " (" + version + "";
        }
        return name;
    }

    public IConfigurationElement getConverterModificationElement(ITool toTool) {
        Map<String, IConfigurationElement> map = ManagedBuildManager.getConversionElements(this);
        IConfigurationElement element = null;
        if (!map.isEmpty()) {
            for (IConfigurationElement el : map.values()) {
                String toId = el.getAttribute("toId");
                ITool to = toTool;
                if (toId != null) {
                    while (to != null) {
                        if (toId.equals(to.getId())) break;
                        to = to.getSuperClass();
                    }
                }
                if (to == null) continue;
                element = el;
                break;
            }
        }
        return element;
    }

    void updateParent(IBuildObject parent) {
        this.parent = parent;
    }

    void updateParentResourceInfo(IResourceInfo rcInfo) {
        this.parent = rcInfo instanceof IFileInfo ? rcInfo : ((IFolderInfo)rcInfo).getToolChain();
    }

    @Override
    public List<Tool> getIdenticalList() {
        return this.identicalList;
    }

    @Override
    public String[] getRequiredTypeIds() {
        SupportedProperties props = this.findSupportedProperties();
        String[] required = null;
        required = props != null ? props.getRequiredTypeIds() : super.getRequiredTypeIds();
        return required;
    }

    @Override
    public String[] getSupportedTypeIds() {
        SupportedProperties props = this.findSupportedProperties();
        String[] supported = null;
        if (props != null) {
            supported = props.getSupportedTypeIds();
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            ArrayList<String> list = new ArrayList<String>();
            if (calc != null) {
                list.addAll(Arrays.asList(calc.getReferencedPropertyIds()));
            }
            list.addAll(Arrays.asList(super.getSupportedTypeIds()));
            supported = list.toArray(new String[list.size()]);
        }
        return supported;
    }

    @Override
    public String[] getSupportedValueIds(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        String[] supported = null;
        if (props != null) {
            supported = props.getSupportedValueIds(typeId);
        } else {
            BooleanExpressionApplicabilityCalculator calc = this.getBooleanExpressionCalculator();
            ArrayList<String> list = new ArrayList<String>();
            if (calc != null) {
                list.addAll(Arrays.asList(calc.getReferencedValueIds(typeId)));
            }
            list.addAll(Arrays.asList(super.getSupportedValueIds(typeId)));
            supported = list.toArray(new String[list.size()]);
        }
        return supported;
    }

    @Override
    public boolean requiresType(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean required = props != null ? props.requiresType(typeId) : super.requiresType(typeId);
        return required;
    }

    public void resetErrorParsers() {
        this.errorParserIds = null;
    }

    void removeErrorParsers(Set<String> set) {
        Set<String> oldSet = this.contributeErrorParsers(null);
        if (oldSet == null) {
            oldSet = new HashSet<String>();
        }
        oldSet.removeAll(set);
        this.setErrorParserList(oldSet.toArray(new String[oldSet.size()]));
    }

    public void setErrorParserList(String[] ids) {
        if (ids == null) {
            this.errorParserIds = null;
        } else if (ids.length == 0) {
            this.errorParserIds = EMPTY_STRING;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(ids[0]);
            int i = 1;
            while (i < ids.length) {
                buf.append(";").append(ids[i]);
                ++i;
            }
            this.errorParserIds = buf.toString();
        }
    }

    @Override
    public boolean isSystemObject() {
        if (this.isTest) {
            return true;
        }
        if (this.getConvertToId().length() != 0) {
            return true;
        }
        IBuildObject bo = this.getParent();
        if (bo instanceof IToolChain) {
            return ((IToolChain)bo).isSystemObject();
        }
        return false;
    }

    @Override
    public String getUniqueRealName() {
        String name = this.getName();
        if (name == null) {
            name = this.getId();
        } else {
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.getId());
            if (version != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(name);
                buf.append(" (v").append(version).append(")");
                name = buf.toString();
            }
        }
        return name;
    }

    private boolean typeContributesToScannerConfig(InputType inType) {
        return inType.getDiscoveryProfileId(this) != null;
    }

    public boolean hasScannerConfigSettings(IInputType type) {
        if (type == null) {
            boolean has = this.hasScannerConfigSettings();
            if (has) {
                return has;
            }
            ITool superClass = this.getSuperClass();
            if (superClass != null && superClass instanceof Tool) {
                return ((Tool)superClass).hasScannerConfigSettings(type);
            }
            return false;
        }
        return ((InputType)type).hasScannerConfigSettings();
    }

    private boolean hasScannerConfigSettings() {
        return this.getDiscoveryProfileIdAttribute() != null;
    }

    public CfgDiscoveredPathManager.PathInfoCache setDiscoveredPathInfo(IInputType type, CfgDiscoveredPathManager.PathInfoCache info) {
        return this.discoveredInfoMap.put(this.getTypeKey(type), info);
    }

    public CfgDiscoveredPathManager.PathInfoCache getDiscoveredPathInfo(IInputType type) {
        return this.discoveredInfoMap.get(this.getTypeKey(type));
    }

    public CfgDiscoveredPathManager.PathInfoCache clearDiscoveredPathInfo(IInputType type) {
        return this.discoveredInfoMap.remove(this.getTypeKey(type));
    }

    public void clearAllDiscoveredPathInfo() {
        this.discoveredInfoMap.clear();
    }

    public void clearAllDiscoveredInfo() {
        this.discoveredInfoMap.clear();
    }

    private String getTypeKey(IInputType type) {
        if (type != null) {
            return type.getId();
        }
        return null;
    }

    public String getDiscoveryProfileIdAttribute() {
        if (this.scannerConfigDiscoveryProfileId == null && this.superClass != null) {
            return ((Tool)this.superClass).getDiscoveryProfileIdAttribute();
        }
        return this.scannerConfigDiscoveryProfileId;
    }

    private IToolChain getToolChain() {
        IBuildObject bo = this.getParent();
        IToolChain tCh = null;
        if (bo instanceof IToolChain) {
            tCh = (IToolChain)bo;
        } else if (bo instanceof IFileInfo) {
            tCh = ((ResourceConfiguration)bo).getBaseToolChain();
        }
        return tCh;
    }

    public String getDiscoveryProfileId() {
        IToolChain tc;
        String id = this.getDiscoveryProfileIdAttribute();
        if (id == null && (tc = this.getToolChain()) != null) {
            id = tc.getScannerConfigDiscoveryProfileId();
        }
        return id;
    }

    public boolean hasCustomSettings(Tool tool) {
        ITool otherRealTool;
        if (this.superClass == null) {
            return true;
        }
        ITool realTool = ManagedBuildManager.getRealTool(this);
        if (realTool != (otherRealTool = ManagedBuildManager.getRealTool(tool))) {
            return true;
        }
        if (this.hasCustomSettings()) {
            return true;
        }
        if (this.inputTypeList != null && this.inputTypeList.size() != 0) {
            for (InputType inType : this.inputTypeList) {
                if (!inType.hasCustomSettings()) continue;
                return true;
            }
        }
        if (this.outputTypeList != null && this.outputTypeList.size() != 0) {
            for (OutputType outType : this.outputTypeList) {
                if (!outType.hasCustomSettings()) continue;
                return true;
            }
        }
        Tool superTool = (Tool)this.superClass;
        if (this.command != null && !this.command.equals(superTool.getToolCommand())) {
            return true;
        }
        if (this.errorParserIds != null && !this.errorParserIds.equals(superTool.getErrorParserIds())) {
            return true;
        }
        if (this.commandLinePattern != null && !this.commandLinePattern.equals(superTool.getCommandLinePattern())) {
            return true;
        }
        if (this.customBuildStep != null && this.customBuildStep.booleanValue() != superTool.getCustomBuildStep()) {
            return true;
        }
        if (this.announcement != null && !this.announcement.equals(superTool.getAnnouncement())) {
            return true;
        }
        if (this.discoveredInfoMap != null && this.discoveredInfoMap.size() != 0) {
            return true;
        }
        return this.isAnyOptionModified(this, tool);
    }

    private boolean isAnyOptionModified(ITool t1, ITool t2) {
        IOption[] iOptionArray = t1.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption op1 = iOptionArray[n2];
            IOption[] iOptionArray2 = t2.getOptions();
            int n3 = iOptionArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IOption op2 = iOptionArray2[n4];
                try {
                    if (op1.getValueType() == op2.getValueType() && op1.getName().equals(op2.getName())) {
                        Object ob1 = op1.getValue();
                        Object ob2 = op2.getValue();
                        if (ob1 == null && ob2 == null || ob1 != null && ob2 != null && ob1.equals(ob2)) break;
                        return true;
                    }
                }
                catch (BuildException buildException) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public IOption[] getOptionsOfType(int type) {
        ArrayList<IOption> list = new ArrayList<IOption>();
        IOption[] iOptionArray = this.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption op = iOptionArray[n2];
            try {
                if (op.getValueType() == type) {
                    list.add(op);
                }
            }
            catch (BuildException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            ++n2;
        }
        return list.toArray(new Option[list.size()]);
    }

    public void filterValues(int type, List<String> values) {
        if (values.size() == 0) {
            return;
        }
        int opType = Option.getOppositeType(type);
        if (opType != 0) {
            HashSet filterSet = new HashSet();
            IOption[] iOptionArray = this.getOptionsOfType(opType);
            int n = iOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOption op = iOptionArray[n2];
                filterSet.addAll((List)op.getValue());
                ++n2;
            }
            if (filterSet.size() != 0) {
                Iterator<String> iterator = values.iterator();
                while (iterator.hasNext()) {
                    String oVal = iterator.next();
                    if (type == 5) {
                        String[] nameVal = BuildEntryStorage.macroNameValueFromValue(oVal);
                        oVal = nameVal[0];
                    }
                    if (!filterSet.contains(oVal)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private int getSuperClassNum() {
        int num = 0;
        ITool superTool = this.getSuperClass();
        while (superTool != null) {
            ++num;
            superTool = superTool.getSuperClass();
        }
        return num;
    }

    @Override
    public int compareTo(Tool other) {
        if (other.isSystemObject() != this.isSystemObject()) {
            return this.isSystemObject() ? 1 : -1;
        }
        return this.getSuperClassNum() - other.getSuperClassNum();
    }

    @Override
    public IRealBuildObjectAssociation getExtensionObject() {
        return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getExtensionTool(this));
    }

    @Override
    public IRealBuildObjectAssociation[] getIdenticBuildObjects() {
        return (IRealBuildObjectAssociation[])ManagedBuildManager.findIdenticalTools(this);
    }

    @Override
    public IRealBuildObjectAssociation getRealBuildObject() {
        return (IRealBuildObjectAssociation)((Object)ManagedBuildManager.getRealTool(this));
    }

    @Override
    public IRealBuildObjectAssociation getSuperClassObject() {
        return (IRealBuildObjectAssociation)((Object)this.getSuperClass());
    }

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    public boolean isRealBuildObject() {
        return this.getRealBuildObject() == this;
    }

    @Override
    public boolean isExtensionBuildObject() {
        return this.isExtensionElement();
    }

    @Override
    public IOptionCategoryApplicability getApplicabilityCalculator() {
        return null;
    }
}

