/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTTryBlockStatement
extends ASTAttributeOwner
implements ICPPASTTryBlockStatement,
IASTAmbiguityParent {
    private ICPPASTCatchHandler[] catchHandlers;
    private int catchHandlersPos = -1;
    private IASTStatement tryBody;

    public CPPASTTryBlockStatement() {
    }

    public CPPASTTryBlockStatement(IASTStatement tryBody) {
        this.setTryBody(tryBody);
    }

    @Override
    public CPPASTTryBlockStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTryBlockStatement copy(IASTNode.CopyStyle style) {
        CPPASTTryBlockStatement copy = new CPPASTTryBlockStatement(this.tryBody == null ? null : this.tryBody.copy(style));
        ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = this.getCatchHandlers();
        int n = iCPPASTCatchHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTCatchHandler handler = iCPPASTCatchHandlerArray[n2];
            copy.addCatchHandler(handler == null ? null : handler.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public void addCatchHandler(ICPPASTCatchHandler statement) {
        this.assertNotFrozen();
        if (statement != null) {
            this.catchHandlers = ArrayUtil.appendAt(ICPPASTCatchHandler.class, this.catchHandlers, ++this.catchHandlersPos, statement);
            statement.setParent(this);
            statement.setPropertyInParent(CATCH_HANDLER);
        }
    }

    @Override
    public ICPPASTCatchHandler[] getCatchHandlers() {
        if (this.catchHandlers == null) {
            return ICPPASTCatchHandler.EMPTY_CATCHHANDLER_ARRAY;
        }
        this.catchHandlers = ArrayUtil.trimAt(ICPPASTCatchHandler.class, this.catchHandlers, this.catchHandlersPos);
        return this.catchHandlers;
    }

    @Override
    public void setTryBody(IASTStatement tryBlock) {
        this.assertNotFrozen();
        this.tryBody = tryBlock;
        if (tryBlock != null) {
            tryBlock.setParent(this);
            tryBlock.setPropertyInParent(BODY);
        }
    }

    @Override
    public IASTStatement getTryBody() {
        return this.tryBody;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributes(action)) {
            return false;
        }
        if (this.tryBody != null && !this.tryBody.accept(action)) {
            return false;
        }
        ICPPASTCatchHandler[] handlers = this.getCatchHandlers();
        int i = 0;
        while (i < handlers.length) {
            if (!handlers[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.tryBody == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.tryBody = (IASTStatement)other;
        }
    }
}

