/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;

public class ASTUtil {
    public static final String EMPTY_STRING = "";
    private static final Map expressionKindStringMap = new HashMap();

    static {
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DYNAMIC_CAST, "dynamic_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_STATIC_CAST, "static_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_REINTERPRET_CAST, "reinterpret_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_CONST_CAST, "const_cast");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR, "char");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART, "wchar_t");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL, "bool");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT, "short");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT, "int");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG, "long");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED, "signed");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED, "unsigned");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT, "float");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE, "double");
        expressionKindStringMap.put(IASTExpression.Kind.THROWEXPRESSION, "throw");
        expressionKindStringMap.put(IASTExpression.Kind.ANDEXPRESSION, "&");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION, "&");
        expressionKindStringMap.put(IASTExpression.Kind.EXPRESSIONLIST, ",");
        expressionKindStringMap.put(IASTExpression.Kind.EXCLUSIVEOREXPRESSION, "^");
        expressionKindStringMap.put(IASTExpression.Kind.PM_DOTSTAR, ".*");
        expressionKindStringMap.put(IASTExpression.Kind.PM_ARROWSTAR, "->*");
        expressionKindStringMap.put(IASTExpression.Kind.LOGICALANDEXPRESSION, "&&");
        expressionKindStringMap.put(IASTExpression.Kind.LOGICALOREXPRESSION, "||");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_GREATERTHAN, ">");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_LESSTHAN, "<");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO, "<=");
        expressionKindStringMap.put(IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO, ">=");
        expressionKindStringMap.put(IASTExpression.Kind.EQUALITY_EQUALS, "==");
        expressionKindStringMap.put(IASTExpression.Kind.EQUALITY_NOTEQUALS, "!=");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION, "*");
        expressionKindStringMap.put(IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY, "*");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION, "+");
        expressionKindStringMap.put(IASTExpression.Kind.ADDITIVE_PLUS, "+");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION, "-");
        expressionKindStringMap.put(IASTExpression.Kind.ADDITIVE_MINUS, "-");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION, "!");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION, "~");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_DECREMENT, "--");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DECREMENT, "--");
        expressionKindStringMap.put(IASTExpression.Kind.UNARY_INCREMENT, "++");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_INCREMENT, "++");
        expressionKindStringMap.put(IASTExpression.Kind.INCLUSIVEOREXPRESSION, "|");
        expressionKindStringMap.put(IASTExpression.Kind.MULTIPLICATIVE_DIVIDE, "/");
        expressionKindStringMap.put(IASTExpression.Kind.MULTIPLICATIVE_MODULUS, "%");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS, ".");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION, ".");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR, ".");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP, "->");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR, "->");
        expressionKindStringMap.put(IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION, "->");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL, "=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT, "*=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV, "/=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD, "%=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS, "+=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS, "-=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT, ">>=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT, "<<=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND, "&=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR, "^=");
        expressionKindStringMap.put(IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR, "|=");
        expressionKindStringMap.put(IASTExpression.Kind.SHIFT_LEFT, "<<");
        expressionKindStringMap.put(IASTExpression.Kind.SHIFT_RIGHT, ">>");
    }

    public static String[] getTemplateParameters(IASTTemplateDeclaration templateDeclaration) {
        Iterator i = templateDeclaration.getTemplateParameters();
        return ASTUtil.getTemplateParameters(i);
    }

    public static String[] getTemplateParameters(Iterator templateParams) {
        ArrayList<String> paramList = new ArrayList<String>();
        while (templateParams.hasNext()) {
            StringBuffer paramType = new StringBuffer();
            IASTTemplateParameter parameter = (IASTTemplateParameter)templateParams.next();
            IASTTemplateParameter.ParamKind kind = parameter.getTemplateParameterKind();
            if (kind == IASTTemplateParameter.ParamKind.CLASS) {
                if (parameter.getIdentifier() != null && parameter.getIdentifier().length() != 0) {
                    paramType.append(parameter.getIdentifier().toString());
                } else {
                    paramType.append("class");
                }
            }
            if (kind == IASTTemplateParameter.ParamKind.TYPENAME) {
                if (parameter.getIdentifier() != null && parameter.getIdentifier().length() != 0) {
                    paramType.append(parameter.getIdentifier().toString());
                } else {
                    paramType.append("typename");
                }
            }
            if (kind == IASTTemplateParameter.ParamKind.TEMPLATE_LIST) {
                paramType.append("template<");
                String[] subParams = ASTUtil.getTemplateParameters(parameter.getTemplateParameters());
                int p = 0;
                if (subParams.length > 0) {
                    paramType.append(subParams[p++]);
                }
                while (p < subParams.length) {
                    paramType.append(", ");
                    paramType.append(subParams[p++]);
                }
                paramType.append(">");
            }
            if (kind == IASTTemplateParameter.ParamKind.PARAMETER) {
                paramType.append(ASTUtil.getType(parameter.getParameterDeclaration()));
            }
            paramList.add(paramType.toString());
        }
        String[] parameterTypes = new String[paramList.size()];
        int j = 0;
        while (j < paramList.size()) {
            parameterTypes[j] = (String)paramList.get(j);
            ++j;
        }
        return parameterTypes;
    }

    public static String getType(IASTAbstractDeclaration declaration) {
        StringBuffer type = new StringBuffer();
        type.append(ASTUtil.getDeclarationType(declaration));
        type.append(ASTUtil.getPointerOperation(declaration));
        type.append(ASTUtil.getArrayQualifiers(declaration));
        type.append(ASTUtil.getPointerToFunctionType(declaration));
        if (declaration instanceof IASTParameterDeclaration) {
            type.append(ASTUtil.getInitializerClause((IASTParameterDeclaration)declaration));
        }
        return type.toString();
    }

    public static String getInitializerClause(IASTParameterDeclaration declaration) {
        String init;
        IASTExpression expression;
        IASTInitializerClause clause;
        StringBuffer initializer = new StringBuffer();
        if (declaration != null && (clause = declaration.getDefaultValue()) != null && (expression = clause.getAssigmentExpression()) != null && (init = ASTUtil.getExpressionString(expression)).length() > 0) {
            initializer.append("=");
            initializer.append(init);
        }
        return initializer.toString();
    }

    public static String getPointerToFunctionType(IASTAbstractDeclaration declaration) {
        StringBuffer type = new StringBuffer();
        ASTPointerOperator po = declaration.getPointerToFunctionOperator();
        if (po != null) {
            type.append("(");
            type.append(ASTUtil.getPointerOperator(po));
            type.append(")");
            String[] parameters = ASTUtil.getParameterTypes(declaration.getParameters(), false);
            type.append(ASTUtil.getParametersString(parameters));
        }
        return type.toString();
    }

    public static String getDeclarationType(IASTAbstractDeclaration declaration) {
        IASTTypeSpecifier typeSpecifier;
        StringBuffer type = new StringBuffer();
        if (declaration.isConst()) {
            type.append("const ");
        }
        if ((typeSpecifier = declaration.getTypeSpecifier()) instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elab = (IASTElaboratedTypeSpecifier)typeSpecifier;
            type.append(ASTUtil.getElaboratedTypeSignature(elab));
        } else if (typeSpecifier instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleSpecifier = (IASTSimpleTypeSpecifier)typeSpecifier;
            type.append(simpleSpecifier.getTypename());
        } else if (typeSpecifier instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpecifier = (IASTClassSpecifier)typeSpecifier;
            type.append(classSpecifier.getName());
        } else if (typeSpecifier instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumSpecifier = (IASTEnumerationSpecifier)typeSpecifier;
            type.append(enumSpecifier.getName());
        }
        return type.toString();
    }

    public static String getElaboratedTypeSignature(IASTElaboratedTypeSpecifier elab) {
        StringBuffer type = new StringBuffer();
        ASTClassKind t = elab.getClassKind();
        if (t == ASTClassKind.CLASS) {
            type.append("class");
        } else if (t == ASTClassKind.STRUCT) {
            type.append("struct");
        } else if (t == ASTClassKind.UNION) {
            type.append("union");
        } else if (t == ASTClassKind.STRUCT) {
            type.append("enum");
        }
        type.append(" ");
        type.append(elab.getName().toString());
        return type.toString();
    }

    public static String getPointerOperation(IASTAbstractDeclaration declaration) {
        StringBuffer pointerString = new StringBuffer();
        Iterator i = declaration.getPointerOperators();
        while (i.hasNext()) {
            ASTPointerOperator po = (ASTPointerOperator)i.next();
            pointerString.append(ASTUtil.getPointerOperator(po));
        }
        return pointerString.toString();
    }

    public static String getPointerOperator(ASTPointerOperator po) {
        String pointerString = EMPTY_STRING;
        if (po == ASTPointerOperator.POINTER) {
            pointerString = "*";
        }
        if (po == ASTPointerOperator.REFERENCE) {
            pointerString = "&";
        }
        if (po == ASTPointerOperator.CONST_POINTER) {
            pointerString = "* const";
        }
        if (po == ASTPointerOperator.VOLATILE_POINTER) {
            pointerString = "* volatile";
        }
        return pointerString;
    }

    public static String getArrayQualifiers(IASTAbstractDeclaration declaration) {
        StringBuffer arrayString = new StringBuffer();
        Iterator i = declaration.getArrayModifiers();
        while (i.hasNext()) {
            i.next();
            arrayString.append("[]");
        }
        return arrayString.toString();
    }

    public static String[] getFunctionParameterTypes(IASTFunction functionDeclaration) {
        Iterator parameters = functionDeclaration.getParameters();
        return ASTUtil.getParameterTypes(parameters, functionDeclaration.takesVarArgs());
    }

    public static String[] getParameterTypes(Iterator parameters, boolean takesVarArgs) {
        ArrayList<String> paramList = new ArrayList<String>();
        while (parameters.hasNext()) {
            IASTParameterDeclaration param = (IASTParameterDeclaration)parameters.next();
            paramList.add(ASTUtil.getType(param));
        }
        int paramListSize = paramList.size();
        if (takesVarArgs) {
            ++paramListSize;
        }
        String[] parameterTypes = new String[paramListSize];
        int i = 0;
        while (i < paramList.size()) {
            parameterTypes[i] = (String)paramList.get(i);
            ++i;
        }
        if (takesVarArgs) {
            parameterTypes[paramListSize - 1] = "...";
        }
        return parameterTypes;
    }

    public static String getParametersString(String[] parameterTypes) {
        StringBuffer parameters = new StringBuffer(EMPTY_STRING);
        if (parameterTypes != null && parameterTypes.length > 0) {
            parameters.append("(");
            int i = 0;
            parameters.append(parameterTypes[i++]);
            while (i < parameterTypes.length) {
                parameters.append(", ");
                parameters.append(parameterTypes[i++]);
            }
            parameters.append(")");
        } else if (parameterTypes != null) {
            parameters.append("()");
        }
        return parameters.toString();
    }

    public static String getTypeId(IASTTypeId id) {
        StringBuffer type = new StringBuffer();
        if (id.isTypename()) {
            type.append("typename");
            type.append(' ');
        }
        type.append(id.getFullSignature());
        return type.toString();
    }

    public static String getExpressionString(IASTExpression expression) {
        if (expression.getExpressionKind().isExtensionKind()) {
            return expression.toString();
        }
        String literal = expression.getLiteralString();
        String idExpression = expression.getIdExpression();
        IASTExpression lhs = expression.getLHSExpression();
        IASTExpression rhs = expression.getRHSExpression();
        IASTExpression third = expression.getThirdExpression();
        IASTExpression.IASTNewExpressionDescriptor descriptor = expression.getNewExpressionDescriptor();
        IASTTypeId typeId = expression.getTypeId();
        if (literal != null && !literal.equals(EMPTY_STRING) && (idExpression == null || idExpression.equals(EMPTY_STRING))) {
            return ASTUtil.getLiteralExpression(expression);
        }
        if (idExpression != null && !idExpression.equals(EMPTY_STRING) && lhs == null) {
            return ASTUtil.getIdExpression(expression);
        }
        if (third != null) {
            return ASTUtil.getConditionalExpression(expression);
        }
        if (descriptor != null) {
            return ASTUtil.getNewExpression(expression);
        }
        if (lhs != null && rhs != null) {
            return ASTUtil.getBinaryExpression(expression);
        }
        if (lhs != null && typeId != null) {
            return ASTUtil.getUnaryTypeIdExpression(expression);
        }
        if (lhs != null && idExpression != null && !idExpression.equals(EMPTY_STRING)) {
            return ASTUtil.getUnaryIdExpression(expression);
        }
        if (lhs != null) {
            return ASTUtil.getUnaryExpression(expression);
        }
        if (typeId != null) {
            return ASTUtil.getTypeIdExpression(expression);
        }
        return ASTUtil.getEmptyExpression(expression);
    }

    private static String getEmptyExpression(IASTExpression expression) {
        if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_THIS) {
            return "this";
        }
        return EMPTY_STRING;
    }

    private static String getLiteralExpression(IASTExpression expression) {
        IASTExpression.Kind kind = expression.getExpressionKind();
        if (kind != IASTExpression.Kind.PRIMARY_CHAR_LITERAL && kind != IASTExpression.Kind.PRIMARY_STRING_LITERAL) {
            return expression.getLiteralString();
        }
        StringBuffer buffer = new StringBuffer();
        if (kind == IASTExpression.Kind.PRIMARY_CHAR_LITERAL) {
            buffer.append('\'');
            buffer.append(expression.getLiteralString());
            buffer.append('\'');
        } else if (kind == IASTExpression.Kind.PRIMARY_STRING_LITERAL) {
            buffer.append('\"');
            buffer.append(expression.getLiteralString());
            buffer.append('\"');
        }
        return buffer.toString();
    }

    private static String getIdExpression(IASTExpression expression) {
        return expression.getIdExpression();
    }

    private static String getConditionalExpression(IASTExpression expression) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ASTUtil.getExpressionString(expression.getLHSExpression()));
        buffer.append(" ? ");
        buffer.append(ASTUtil.getExpressionString(expression.getRHSExpression()));
        buffer.append(" : ");
        buffer.append(ASTUtil.getExpressionString(expression.getThirdExpression()));
        return buffer.toString();
    }

    private static String getNewExpression(IASTExpression expression) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new");
        buffer.append(' ');
        IASTExpression.IASTNewExpressionDescriptor descriptor = expression.getNewExpressionDescriptor();
        Iterator iter = descriptor.getNewPlacementExpressions();
        if (iter.hasNext()) {
            buffer.append('(');
            buffer.append(ASTUtil.getExpressionString((IASTExpression)iter.next()));
            buffer.append(") ");
        }
        if ((iter = descriptor.getNewTypeIdExpressions()).hasNext()) {
            buffer.append(ASTUtil.getExpressionString((IASTExpression)iter.next()));
            buffer.append(' ');
        }
        if (expression.getTypeId() != null) {
            buffer.append(ASTUtil.getTypeId(expression.getTypeId()));
        }
        if ((iter = descriptor.getNewInitializerExpressions()).hasNext()) {
            buffer.append('(');
            buffer.append(ASTUtil.getExpressionString((IASTExpression)iter.next()));
            buffer.append(')');
        }
        return buffer.toString();
    }

    private static String getBinaryExpression(IASTExpression expression) {
        IASTExpression.Kind kind = expression.getExpressionKind();
        StringBuffer buffer = new StringBuffer();
        buffer.append(ASTUtil.getExpressionString(expression.getLHSExpression()));
        boolean appendSpace = false;
        if (kind != IASTExpression.Kind.EXPRESSIONLIST && kind != IASTExpression.Kind.PM_DOTSTAR && kind != IASTExpression.Kind.PM_ARROWSTAR && kind != IASTExpression.Kind.POSTFIX_SUBSCRIPT && kind != IASTExpression.Kind.POSTFIX_FUNCTIONCALL && kind != IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS && kind != IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION && kind != IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR && kind != IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP && kind != IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION && kind != IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR) {
            appendSpace = true;
            buffer.append(' ');
        }
        if (kind == IASTExpression.Kind.ANDEXPRESSION || kind == IASTExpression.Kind.EXPRESSIONLIST || kind == IASTExpression.Kind.EXCLUSIVEOREXPRESSION || kind == IASTExpression.Kind.PM_DOTSTAR || kind == IASTExpression.Kind.PM_ARROWSTAR || kind == IASTExpression.Kind.LOGICALANDEXPRESSION || kind == IASTExpression.Kind.LOGICALOREXPRESSION || kind == IASTExpression.Kind.RELATIONAL_GREATERTHAN || kind == IASTExpression.Kind.RELATIONAL_LESSTHAN || kind == IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO || kind == IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO || kind == IASTExpression.Kind.EQUALITY_EQUALS || kind == IASTExpression.Kind.EQUALITY_NOTEQUALS || kind == IASTExpression.Kind.ADDITIVE_PLUS || kind == IASTExpression.Kind.ADDITIVE_MINUS || kind == IASTExpression.Kind.INCLUSIVEOREXPRESSION || kind == IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY || kind == IASTExpression.Kind.MULTIPLICATIVE_DIVIDE || kind == IASTExpression.Kind.MULTIPLICATIVE_MODULUS || kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || kind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP || kind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR || kind == IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR || kind == IASTExpression.Kind.SHIFT_LEFT || kind == IASTExpression.Kind.SHIFT_RIGHT) {
            buffer.append(ASTUtil.getStringForKind(kind));
        } else if (kind == IASTExpression.Kind.POSTFIX_SUBSCRIPT) {
            buffer.append('[');
        } else if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            buffer.append('(');
        }
        if (kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP) {
            buffer.append(' ');
            buffer.append("template");
            buffer.append(' ');
        }
        if (appendSpace || kind == IASTExpression.Kind.EXPRESSIONLIST) {
            buffer.append(' ');
        }
        buffer.append(ASTUtil.getExpressionString(expression.getRHSExpression()));
        if (kind == IASTExpression.Kind.POSTFIX_SUBSCRIPT) {
            buffer.append(']');
        } else if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    private static String getUnaryTypeIdExpression(IASTExpression expression) {
        StringBuffer buffer = new StringBuffer();
        IASTExpression.Kind kind = expression.getExpressionKind();
        if (kind == IASTExpression.Kind.CASTEXPRESSION) {
            buffer.append('(');
            buffer.append(ASTUtil.getTypeId(expression.getTypeId()));
            buffer.append(')');
            buffer.append(ASTUtil.getExpressionString(expression.getLHSExpression()));
        } else if (kind == IASTExpression.Kind.POSTFIX_DYNAMIC_CAST || kind == IASTExpression.Kind.POSTFIX_STATIC_CAST || kind == IASTExpression.Kind.POSTFIX_REINTERPRET_CAST || kind == IASTExpression.Kind.POSTFIX_CONST_CAST) {
            buffer.append(ASTUtil.getStringForKind(kind));
            buffer.append('<');
            buffer.append(ASTUtil.getTypeId(expression.getTypeId()));
            buffer.append(">(");
            buffer.append(ASTUtil.getExpressionString(expression.getLHSExpression()));
            buffer.append(')');
        }
        return buffer.toString();
    }

    private static String getUnaryIdExpression(IASTExpression expression) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("typename");
        buffer.append(' ');
        if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPENAME_TEMPLATEID) {
            buffer.append("template");
            buffer.append(' ');
        }
        buffer.append(expression.getIdExpression());
        buffer.append('(');
        buffer.append(ASTUtil.getExpressionString(expression.getLHSExpression()));
        buffer.append(')');
        return buffer.toString();
    }

    private static String getUnaryExpression(IASTExpression expression) {
        boolean bracketsAroundExpression;
        StringBuffer buffer = new StringBuffer();
        IASTExpression.Kind kind = expression.getExpressionKind();
        boolean bl = bracketsAroundExpression = kind == IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION;
        if (kind == IASTExpression.Kind.UNARY_SIZEOF_UNARYEXPRESSION) {
            buffer.append("sizeof");
            buffer.append(' ');
        } else if (kind == IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION || kind == IASTExpression.Kind.UNARY_DECREMENT || kind == IASTExpression.Kind.THROWEXPRESSION) {
            buffer.append(ASTUtil.getStringForKind(kind));
        } else if (kind == IASTExpression.Kind.UNARY_INCREMENT) {
            buffer.append("++");
        } else if (kind == IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION || kind == IASTExpression.Kind.DELETE_CASTEXPRESSION) {
            buffer.append("delete");
            buffer.append(' ');
            if (kind == IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION) {
                buffer.append("[ ] ");
            }
        } else if (kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT || kind == IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE) {
            buffer.append(ASTUtil.getStringForKind(kind));
            bracketsAroundExpression = true;
        } else if (kind == IASTExpression.Kind.POSTFIX_TYPEID_EXPRESSION) {
            buffer.append("typeid");
            bracketsAroundExpression = true;
        }
        if (bracketsAroundExpression) {
            buffer.append('(');
        }
        buffer.append(ASTUtil.getExpressionString(expression.getLHSExpression()));
        if (bracketsAroundExpression) {
            buffer.append(')');
        }
        if (kind == IASTExpression.Kind.POSTFIX_INCREMENT || kind == IASTExpression.Kind.POSTFIX_DECREMENT) {
            buffer.append(ASTUtil.getStringForKind(kind));
        }
        return buffer.toString();
    }

    private static String getTypeIdExpression(IASTExpression expression) {
        StringBuffer buffer = new StringBuffer();
        IASTExpression.Kind kind = expression.getExpressionKind();
        boolean addBrackets = false;
        if (kind == IASTExpression.Kind.UNARY_SIZEOF_TYPEID) {
            buffer.append("sizeof");
            buffer.append(' ');
            addBrackets = true;
        } else if (kind == IASTExpression.Kind.POSTFIX_TYPEID_TYPEID) {
            buffer.append("typeid");
            addBrackets = true;
        }
        if (addBrackets) {
            buffer.append('(');
        }
        buffer.append(ASTUtil.getTypeId(expression.getTypeId()));
        if (addBrackets) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    private static String getStringForKind(IASTExpression.Kind kind) {
        return (String)expressionKindStringMap.get(kind);
    }
}

