/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceAlias;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTNamespaceAlias
extends ASTSymbol
implements IASTNamespaceAlias {
    private NamedOffsets offsets = new NamedOffsets();
    private final String alias;
    private final IASTNamespaceDefinition namespace;
    private List references;

    public ASTNamespaceAlias(ISymbol s, String alias, IASTNamespaceDefinition namespaceDefinition, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endingLine, List references) {
        super(s);
        this.alias = alias;
        this.namespace = namespaceDefinition;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endOffset, endingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameEndOffset);
        this.references = references;
    }

    public String getAlias() {
        return this.alias;
    }

    public IASTNamespaceDefinition getNamespace() {
        return this.namespace;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.references, requestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }
}

