/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.Offsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;

public class ASTUsingDirective
extends ASTAnonymousDeclaration
implements IASTUsingDirective {
    private final IUsingDirectiveSymbol using;
    private Offsets offsets = new Offsets();
    private List references;

    public ASTUsingDirective(IContainerSymbol ownerSymbol, IUsingDirectiveSymbol usingDirective, int startingOffset, int startingLine, int endingOffset, int endingLine, List references) {
        super(ownerSymbol);
        this.using = usingDirective;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.references = references;
    }

    public String getNamespaceName() {
        IASTNamespaceDefinition namespace = this.getNamespaceDefinition();
        String[] fqn = namespace.getFullyQualifiedName();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < fqn.length) {
            buffer.append(fqn[i]);
            if (i + 1 != fqn.length) {
                buffer.append("::");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptUsingDirective(this);
        }
        catch (Exception exception) {}
        manager.processReferences(this.references, requestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public IASTNamespaceDefinition getNamespaceDefinition() {
        IContainerSymbol namespaceSymbol = this.using.getNamespace();
        return (IASTNamespaceDefinition)((Object)namespaceSymbol.getASTExtension().getPrimaryDeclaration());
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }
}

