/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.Offsets;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTTemplateDeclaration
extends ASTDeclaration
implements IASTTemplateDeclaration {
    private IASTDeclaration ownedDeclaration;
    private List templateParameters;
    private Offsets offsets = new Offsets();
    private final boolean isExported;

    public ASTTemplateDeclaration(IASTScope scope, List templateParameters, int startingOffset, int startingLine, boolean isExported) {
        super(scope);
        this.templateParameters = templateParameters;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.isExported = isExported;
    }

    public Iterator getTemplateParameters() {
        return this.templateParameters != null ? this.templateParameters.iterator() : EmptyIterator.EMPTY_ITERATOR;
    }

    public IASTDeclaration getOwnedDeclaration() {
        return this.ownedDeclaration;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void setOwnedDeclaration(IASTDeclaration declaration) {
        this.ownedDeclaration = declaration;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterTemplateDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitTemplateDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public Iterator getDeclarations() throws ASTNotImplementedException {
        ArrayList<IASTDeclaration> decls = new ArrayList<IASTDeclaration>(1);
        decls.add(this.getOwnedDeclaration());
        return decls.iterator();
    }
}

