/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.AddIncludeOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditorErrorTickUpdater;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotation;
import org.eclipse.cdt.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.internal.ui.editor.MouseClickListener;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.internal.ui.search.actions.OpenDeclarationsAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.text.CPairMatcher;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.cdt.ui.actions.ShowInCViewAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.tasklist.TaskList;

public class CEditor
extends TextEditor
implements ISelectionChangedListener,
IShowInSource,
IReconcilingParticipant {
    protected CContentOutlinePage fOutlinePage;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fRefactoringActionGroup;
    private ShowInCViewAction fShowInCViewAction;
    protected ISelectionChangedListener fStatusLineClearer;
    protected ISelectionChangedListener fSelectionUpdateListener;
    private PropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private MouseClickListener fMouseListener;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected CPairMatcher fBracketMatcher = new CPairMatcher(BRACKETS);
    private TabConverter fTabConverter;
    private CEditorErrorTickUpdater fCEditorErrorTickUpdater;
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    public static final String LINKED_POSITION_COLOR = "linkedPositionColor";
    private static final String TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    public static final String HYPERLINK_ENABLED = "hyperlinkEnable";
    public static final String LANGUAGE_CPP = "CEditor.language.cpp";
    public static final String LANGUAGE_C = "CEditor.language.c";
    protected String fOutlinerContextMenuId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void initializeEditor() {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        this.setSourceViewerConfiguration(new CSourceViewerConfiguration(textTools, this));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setEditorContextMenuId("#CEditorContext");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.setOutlinerContextMenuId("#CEditorOutlinerContext");
        IPreferenceStore[] stores = new IPreferenceStore[]{CUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        ChainedPreferenceStore store = new ChainedPreferenceStore(stores);
        this.setPreferenceStore((IPreferenceStore)store);
        this.fCEditorErrorTickUpdater = new CEditorErrorTickUpdater(this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.setAnnotationModel(this.getDocumentProvider().getAnnotationModel((Object)input));
        }
        this.setOutlinePageInput(this.fOutlinePage, input);
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput != null && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        this.setOutlinePageInput(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block15: {
            block18: {
                block17: {
                    AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
                    try {
                        String property;
                        block16: {
                            if (asv == null) break block15;
                            property = event.getProperty();
                            if ("org.eclipse.cdt.editor.tab.width".equals(property)) {
                                Object value;
                                SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
                                String[] types = configuration.getConfiguredContentTypes((ISourceViewer)asv);
                                int i = 0;
                                while (true) {
                                    if (i >= types.length) {
                                        if (this.fTabConverter != null) {
                                            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
                                        }
                                        if (!((value = event.getNewValue()) instanceof Integer)) break;
                                        asv.getTextWidget().setTabs(((Integer)value).intValue());
                                        break block16;
                                    }
                                    asv.setIndentPrefixes(configuration.getIndentPrefixes((ISourceViewer)asv, types[i]), types[i]);
                                    ++i;
                                }
                                if (value instanceof String) {
                                    asv.getTextWidget().setTabs(Integer.parseInt((String)value));
                                }
                            }
                        }
                        if (SPACES_FOR_TABS.equals(property)) {
                            if (this.isTabConversionEnabled()) {
                                this.startTabConversion();
                            } else {
                                this.stopTabConversion();
                            }
                            Object var7_8 = null;
                            break block17;
                        }
                        if (HYPERLINK_ENABLED.equals(property)) {
                            if (this.hyperLinkEnabled()) {
                                this.enableBrowserLikeLinks();
                                break block18;
                            } else {
                                this.disableBrowserLikeLinks();
                            }
                            break block18;
                        }
                        IContentAssistant c = asv.getContentAssistant();
                        if (c instanceof ContentAssistant) {
                            ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        super.handlePreferenceStoreChanged(event);
                        throw throwable;
                    }
                }
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var7_9 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var7_11 = null;
        super.handlePreferenceStoreChanged(event);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ICElement element) {
        if (element == null || element instanceof ITranslationUnit) {
            return;
        }
        if (element instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)element;
            this.setSelection(reference, true);
        }
    }

    public void setSelection(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            try {
                this.setSelection(element.getSourceRange(), moveCursor);
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        if (element == null) {
            return;
        }
        try {
            IRegion alternateRegion = null;
            int start = element.getStartPos();
            int length = element.getLength();
            if (start < 0 || length < 0) {
                start = 0;
                length = 0;
            }
            if (length == 0 && start == 0 && element.getStartLine() > 0) {
                start = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getStartLine() - 1);
                length = element.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getEndLine()) - start : start;
                alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine() - 1);
                if ((start == length || length < 0) && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
            }
            this.setHighlightRange(start, length, moveCursor);
            if (moveCursor) {
                start = element.getIdStartPos();
                length = element.getIdLength();
                if (start == 0 && length == 0 && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
                if (start > -1 && this.getSourceViewer() != null) {
                    this.getSourceViewer().revealRange(start, length);
                    this.getSourceViewer().setSelectedRange(start, length);
                }
                this.updateStatusField("CursorPosition");
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BadLocationException badLocationException) {}
        if (moveCursor) {
            this.resetHighlightRange();
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void dispose() {
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.setAnnotationModel(null);
            this.fCEditorErrorTickUpdater.dispose();
            this.fCEditorErrorTickUpdater = null;
        }
        if (this.fPropertyChangeListener != null) {
            Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
            preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPropertyChangeListener);
            IPreferenceStore preferenceStore = this.getPreferenceStore();
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fSelectionUpdateListener != null) {
            this.getSelectionProvider().addSelectionChangedListener(this.fSelectionUpdateListener);
            this.fSelectionUpdateListener = null;
        }
        if (this.fStatusLineClearer != null) {
            ISelectionProvider provider = this.getSelectionProvider();
            provider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.fShowInCViewAction != null) {
            this.fShowInCViewAction.dispose();
            this.fShowInCViewAction = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        this.stopTabConversion();
        this.disableBrowserLikeLinks();
        super.dispose();
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        ICFileType type;
        IFile file;
        ICFileType type2;
        IFile file2;
        String oldLanguage = "";
        if (originalElement instanceof IFileEditorInput && (file2 = ((IFileEditorInput)originalElement).getFile()) != null && (oldLanguage = (type2 = CCorePlugin.getDefault().getFileType(file2.getProject(), file2.getName())).getLanguage().getId()) == null) {
            return false;
        }
        String newLanguage = "";
        if (movedElement instanceof IFileEditorInput && (file = ((IFileEditorInput)movedElement).getFile()) != null && (newLanguage = (type = CCorePlugin.getDefault().getFileType(file.getProject(), file.getName())).getLanguage().getId()) == null) {
            return false;
        }
        return oldLanguage.equals(newLanguage);
    }

    protected void createActions() {
        super.createActions();
        Object action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        action = new ContentAssistAction(CEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)action);
        this.setAction("AddIncludeOnSelection", (IAction)new AddIncludeOnSelectionAction((ITextEditor)this));
        action = new OpenDeclarationsAction(this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
        this.setAction("OpenDeclarations", (IAction)action);
        this.fShowInCViewAction = new ShowInCViewAction((ITextEditor)this);
        action = this.fShowInCViewAction;
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.opencview");
        this.setAction("ShowInCView", (IAction)action);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        this.fRefactoringActionGroup = new RefactoringActionGroup(this, null);
        if (this.hyperLinkEnabled()) {
            this.enableBrowserLikeLinks();
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addGroup(menu, "group.edit", "group.reorganize");
        this.addGroup(menu, "group.edit", "group.generate");
        this.addGroup(menu, "group.edit", "group.new");
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
        this.addAction(menu, "group.find", "OpenDeclarations");
        this.addAction(menu, "group.generate", "ContentAssistProposal");
        this.addAction(menu, "group.generate", "AddIncludeOnSelection");
        this.addAction(menu, "group.generate", "ShowInCView");
        this.fRefactoringActionGroup.fillContextMenu(menu);
        this.fSelectionSearchGroup.fillContextMenu(menu);
    }

    public void setOutlinePageInput(CContentOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            page.setInput((ITranslationUnit)manager.getWorkingCopy(input));
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.editor_view");
        this.fSelectionUpdateListener = new ISelectionChangedListener(){
            private Runnable fRunnable = new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    CEditor.access$0(1.access$0(this.this$1), "CursorPosition");
                }
            };
            private Display fDisplay;

            public void selectionChanged(SelectionChangedEvent event) {
                if (this.fDisplay == null) {
                    this.fDisplay = CEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(this.fRunnable);
            }

            static /* synthetic */ CEditor access$0(1 var0) {
                return var0.CEditor.this;
            }
        };
        this.getSelectionProvider().addSelectionChangedListener(this.fSelectionUpdateListener);
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyChangeListener);
        Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPropertyChangeListener);
    }

    private IMarker getNextError(int offset, boolean forward) {
        IMarker nextError = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            MarkerAnnotation ma;
            IMarker marker;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof CMarkerAnnotation) || !MarkerUtilities.isMarkerType((IMarker)(marker = (ma = (MarkerAnnotation)a).getMarker()), (String)"org.eclipse.core.resources.problemmarker") || (p = model.getPosition(a)).includes(offset)) continue;
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument - offset + p.getOffset();
                }
            } else {
                currentDistance = offset - p.getOffset();
                if (currentDistance < 0) {
                    currentDistance = offset + endOfDocument - p.getOffset();
                }
            }
            if (nextError != null && (currentDistance >= distance || currentDistance == 0)) continue;
            distance = currentDistance;
            if (distance == 0) {
                distance = endOfDocument;
            }
            nextError = marker;
        }
        return nextError;
    }

    public void gotoError(boolean forward) {
        ITextSelection s;
        IMarker nextError;
        ISelectionProvider provider = this.getSelectionProvider();
        if (this.fStatusLineClearer != null) {
            provider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if ((nextError = this.getNextError((s = (ITextSelection)provider.getSelection()).getOffset(), forward)) != null) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)nextError);
            IWorkbenchPage page = this.getSite().getPage();
            IViewPart view = page.findView("org.eclipse.ui.views.TaskList");
            if (view instanceof TaskList) {
                StructuredSelection ss = new StructuredSelection((Object)nextError);
                ((TaskList)view).setSelection((ISelection)ss, true);
            }
            this.getStatusLineManager().setErrorMessage(nextError.getAttribute("message", ""));
            this.fStatusLineClearer = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CEditor.this.getSelectionProvider().removeSelectionChangedListener(CEditor.this.fStatusLineClearer);
                    CEditor.this.fStatusLineClearer = null;
                    CEditor.this.getStatusLineManager().setErrorMessage("");
                }
            };
            provider.addSelectionChangedListener(this.fStatusLineClearer);
        } else {
            this.getStatusLineManager().setErrorMessage("");
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), null);
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fTabConverter);
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(SPACES_FOR_TABS);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        IProject p;
        IWorkingCopyManager mgr = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy unit = mgr.getWorkingCopy(this.getEditorInput());
        String fileType = LANGUAGE_CPP;
        if (unit != null && !CoreModel.hasCCNature((IProject)(p = unit.getCProject().getProject()))) {
            fileType = unit.isCXXLanguage() ? LANGUAGE_CPP : LANGUAGE_C;
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        ISharedTextColors sharedColors = CUIPlugin.getDefault().getSharedTextColors();
        this.fOverviewRuler = this.createOverviewRuler(sharedColors);
        AdaptedSourceViewer sourceViewer = new AdaptedSourceViewer(parent, ruler, styles, this.fOverviewRuler, this.isOverviewRulerVisible(), fileType);
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, this.fOverviewRuler, this.fAnnotationAccess, sharedColors);
        this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        this.fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        this.fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        return sourceViewer;
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.cdt.ui.cEditorScope"});
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        AsmTextTools asmTools = CUIPlugin.getDefault().getAsmTextTools();
        return textTools.affectsBehavior(event) || asmTools.affectsBehavior(event);
    }

    protected void handlePreferencePropertyChanged(PropertyChangeEvent event) {
        ISourceViewer sourceViewer;
        if (TRANSLATION_TASK_TAGS.equals(event.getProperty()) && (sourceViewer = this.getSourceViewer()) != null && this.affectsTextPresentation(event)) {
            sourceViewer.invalidateTextPresentation();
        }
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    private void enableBrowserLikeLinks() {
        if (this.fMouseListener == null) {
            IAction openDeclAction = this.getAction("OpenDeclarations");
            this.fMouseListener = new MouseClickListener(this, this.getSourceViewer(), this.getPreferenceStore(), openDeclAction);
            this.fMouseListener.install();
        }
    }

    private void disableBrowserLikeLinks() {
        if (this.fMouseListener != null) {
            this.fMouseListener.uninstall();
            this.fMouseListener = null;
        }
    }

    private boolean hyperLinkEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(HYPERLINK_ENABLED);
    }

    public void reconciled(boolean somethingHasChanged) {
        if (somethingHasChanged && this.fOutlinePage != null) {
            this.fOutlinePage.contentUpdated();
        }
    }

    static /* synthetic */ void access$0(CEditor cEditor, String string) {
        cEditor.updateStatusField(string);
    }

    private class PropertyChangeListener
    implements Preferences.IPropertyChangeListener,
    IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            CEditor.this.handlePreferencePropertyChanged(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            CEditor.this.handlePreferencePropertyChanged(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }

    interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    static class TabConverter
    implements ITextConverter {
        private String fTabString = "";
        private int tabRatio = 0;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.tabRatio = ratio;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < ratio) {
                buffer.append(' ');
                ++i;
            }
            this.fTabString = buffer.toString();
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(text, "\t", true);
            int charCount = 0;
            try {
                charCount = command.offset - document.getLineInformationOfOffset(command.offset).getOffset();
            }
            catch (Exception exception) {}
            String nextToken = null;
            int spaces = 0;
            while (tokens.hasMoreTokens()) {
                nextToken = tokens.nextToken();
                if ("\t".equals(nextToken)) {
                    spaces = this.tabRatio - charCount % this.tabRatio;
                    int i = 0;
                    while (i < spaces) {
                        buffer.append(' ');
                        ++i;
                    }
                    charCount += spaces;
                    continue;
                }
                buffer.append(nextToken);
                charCount += nextToken.length();
            }
            command.text = buffer.toString();
        }
    }

    public class AdaptedSourceViewer
    extends SourceViewer
    implements ITextViewerExtension {
        private List fTextConverters;
        private String fDisplayLanguage;

        public AdaptedSourceViewer(Composite parent, IVerticalRuler ruler, int styles, IOverviewRuler fOverviewRuler, boolean isOverviewRulerShowing, String language) {
            super(parent, ruler, fOverviewRuler, isOverviewRulerShowing, styles);
            this.fDisplayLanguage = language;
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    CEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
            }
            super.doOperation(operation);
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public void setDisplayLanguage(String language) {
            this.fDisplayLanguage = language;
        }

        public String getDisplayLanguage() {
            return this.fDisplayLanguage;
        }
    }
}

