/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.internal.ui.text.BufferedDocumentScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastCPartitionScanner
implements IPartitionTokenScanner {
    private static final String SKIP = "__skip";
    public static final String C_STRING = "c_string";
    public static final String C_SINGLE_LINE_COMMENT = "c_single_line_comment";
    public static final String C_MULTI_LINE_COMMENT = "c_multi_line_comment";
    private static final int CCODE = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int CHARACTER = 3;
    private static final int STRING = 4;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int STAR = 4;
    private static final int CARRIAGE_RETURN = 5;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private static final boolean fgEmulate = false;
    private int fCOffset;
    private int fCLength;
    private final IToken[] fTokens = new IToken[]{new Token(null), new Token((Object)"c_single_line_comment"), new Token((Object)"c_multi_line_comment"), new Token((Object)"__skip"), new Token((Object)"c_string")};

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block47: while (true) {
            int ch = this.fScanner.read();
            switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    if (this.fLast != 5) {
                        this.fLast = 5;
                        ++this.fTokenLength;
                        continue block47;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                this.fLast = 5;
                                this.fPrefixLength = 1;
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block47;
                        }
                    }
                    this.consume();
                    continue block47;
                }
                case 10: {
                    switch (this.fState) {
                        case 1: 
                        case 3: 
                        case 4: {
                            return this.postFix(this.fState);
                        }
                    }
                    this.consume();
                    continue block47;
                }
            }
            if (this.fLast == 5) {
                switch (this.fState) {
                    case 1: 
                    case 3: 
                    case 4: {
                        int newState;
                        int last;
                        switch (ch) {
                            case 47: {
                                last = 2;
                                newState = 0;
                                break;
                            }
                            case 42: {
                                last = 4;
                                newState = 0;
                                break;
                            }
                            case 39: {
                                last = 0;
                                newState = 3;
                                break;
                            }
                            case 34: {
                                last = 0;
                                newState = 4;
                                break;
                            }
                            case 13: {
                                last = 5;
                                newState = 0;
                                break;
                            }
                            case 92: {
                                last = 1;
                                newState = 0;
                                break;
                            }
                            default: {
                                last = 0;
                                newState = 0;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                }
            }
            block22 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block22;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break block22;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastCPartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break block22;
                            }
                            this.consume();
                            break block22;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 3, 0, 1);
                            }
                            this.preFix(0, 3, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block22;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break block22;
                        }
                    }
                    this.consume();
                    break;
                }
                case 1: {
                    this.consume();
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 4;
                            break block22;
                        }
                        case 47: {
                            if (this.fLast == 4) {
                                return this.postFix(2);
                            }
                            this.consume();
                            break block22;
                        }
                    }
                    this.consume();
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block22;
                        }
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            break block22;
                        }
                    }
                    this.consume();
                    break;
                }
                case 3: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block22;
                        }
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(3);
                            }
                            this.consume();
                            break block22;
                        }
                    }
                    this.consume();
                }
            }
        }
    }

    private static final int getLastLength(int last) {
        switch (last) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 3: 
        }
        return 2;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        this.fTokenLength -= FastCPartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private static int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals(C_SINGLE_LINE_COMMENT)) {
            return 1;
        }
        if (contentType.equals(C_MULTI_LINE_COMMENT)) {
            return 2;
        }
        if (contentType.equals(C_STRING)) {
            return 4;
        }
        if (contentType.equals(SKIP)) {
            return 3;
        }
        return 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fState = offset == partitionOffset ? 0 : FastCPartitionScanner.getState(contentType);
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

