/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.help.WorkbenchHelp;

public class EditWorkingSetAction
extends Action {
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        super(WorkingSetMessages.getString("EditWorkingSetAction.text"));
        Assert.isNotNull((Object)((Object)actionGroup));
        this.setToolTipText(WorkingSetMessages.getString("EditWorkingSetAction.toolTip"));
        this.setEnabled(actionGroup.getWorkingSet() != null);
        this.fShell = shell;
        this.fActionGroup = actionGroup;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.edit_working_set_action");
    }

    public void run() {
        if (this.fShell == null) {
            this.fShell = CUIPlugin.getActiveWorkbenchShell();
        }
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = this.fActionGroup.getWorkingSet();
        if (workingSet == null) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(workingSet);
        if (wizard == null) {
            String title = WorkingSetMessages.getString("EditWorkingSetAction.nowizard.title");
            String message = WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message");
            MessageDialog.openError((Shell)this.fShell, (String)title, (String)message);
            return;
        }
        WizardDialog dialog = new WizardDialog(this.fShell, (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.fActionGroup.setWorkingSet(wizard.getSelection(), true);
        }
    }
}

