/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.workingsets.ClearWorkingSetAction;
import org.eclipse.cdt.internal.ui.workingsets.EditWorkingSetAction;
import org.eclipse.cdt.internal.ui.workingsets.SelectWorkingSetAction;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetComparator;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetFilter;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMenuContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetFilterActionGroup
extends ActionGroup {
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String SEPARATOR_ID = "workingSetGroupSeparator";
    private WorkingSetFilter fWorkingSetFilter;
    private IWorkingSet fWorkingSet = null;
    private ClearWorkingSetAction fClearWorkingSetAction;
    private SelectWorkingSetAction fSelectWorkingSetAction;
    private EditWorkingSetAction fEditWorkingSetAction;
    private IPropertyChangeListener fWorkingSetListener;
    private IPropertyChangeListener fChangeListener;
    private int fLRUMenuCount;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;

    public WorkingSetFilterActionGroup(String viewId, Shell shell, IPropertyChangeListener changeListener) {
        Assert.isNotNull((Object)viewId);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)changeListener);
        this.fChangeListener = changeListener;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, shell);
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetFilterActionGroup.this.doPropertyChange(event);
            }
        };
        this.fWorkingSetFilter = new WorkingSetFilter();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        manager.addPropertyChangeListener(this.fWorkingSetListener);
    }

    public boolean isFiltered(Object parent, Object object) {
        if (this.fWorkingSetFilter == null) {
            return false;
        }
        return !this.fWorkingSetFilter.select(null, parent, object);
    }

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet, boolean refreshViewer) {
        this.fClearWorkingSetAction.setEnabled(workingSet != null);
        this.fEditWorkingSetAction.setEnabled(workingSet != null);
        this.fWorkingSet = workingSet;
        this.fWorkingSetFilter.setWorkingSet(workingSet);
        if (refreshViewer) {
            this.fChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "workingSetContentChange", null, (Object)workingSet));
        }
    }

    public void saveState(IMemento memento) {
        String workingSetName = "";
        if (this.fWorkingSet != null) {
            workingSetName = this.fWorkingSet.getName();
        }
        memento.putString(TAG_WORKING_SET_NAME, workingSetName);
    }

    public void restoreState(IMemento memento) {
        String workingSetName = memento.getString(TAG_WORKING_SET_NAME);
        IWorkingSet ws = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName);
        this.setWorkingSet(ws, false);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
        this.contributeToMenu(actionBars.getMenuManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void contributeToMenu(IMenuManager mm) {
        mm.add((IAction)this.fSelectWorkingSetAction);
        mm.add((IAction)this.fClearWorkingSetAction);
        mm.add((IAction)this.fEditWorkingSetAction);
        mm.add((IContributionItem)new Separator());
        mm.add((IContributionItem)new Separator(SEPARATOR_ID));
        this.addLRUWorkingSetActions(mm);
        this.fMenuManager = mm;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkingSetFilterActionGroup.this.removePreviousLRUWorkingSetActions(manager);
                WorkingSetFilterActionGroup.this.addLRUWorkingSetActions(manager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void removePreviousLRUWorkingSetActions(IMenuManager mm) {
        int i = 1;
        while (i <= this.fLRUMenuCount) {
            mm.remove(WorkingSetMenuContributionItem.getId(i));
            ++i;
        }
    }

    private void addLRUWorkingSetActions(IMenuManager mm) {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        List<IWorkingSet> sortedWorkingSets = Arrays.asList(workingSets);
        Collections.sort(sortedWorkingSets, new WorkingSetComparator());
        Iterator<IWorkingSet> iter = sortedWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet workingSet = iter.next();
            if (workingSet == null) continue;
            WorkingSetMenuContributionItem item = new WorkingSetMenuContributionItem(++i, this, workingSet);
            mm.insertBefore(SEPARATOR_ID, (IContributionItem)item);
        }
        this.fLRUMenuCount = i;
    }

    public void dispose() {
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        this.fChangeListener = null;
        super.dispose();
    }

    public ViewerFilter getWorkingSetFilter() {
        return this.fWorkingSetFilter;
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        IWorkingSet newWorkingSet;
        String property = event.getProperty();
        if ("workingSetNameChange".equals(property)) {
            this.fChangeListener.propertyChange(event);
        } else if ("workingSetContentChange".equals(property) && (newWorkingSet = (IWorkingSet)event.getNewValue()).equals(this.fWorkingSet)) {
            this.fChangeListener.propertyChange(event);
        }
    }
}

