/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards.conversion;

import java.util.Vector;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.wizards.conversion.ConversionWizard;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public abstract class ConvertProjectWizardPage
extends WizardPage {
    public static final String KEY_TITLE = "ConvertionWizard.title";
    public static final String KEY_CONVERTING = "ConvertionWizard.converting";
    private static final String PROJECT_LIST = "ConversionWizard.projectlist";
    protected boolean convertToC = false;
    protected boolean convertToCC = true;
    protected Button cRadioButton;
    protected Button ccRadioButton;
    protected CheckboxTableViewer tableViewer;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    protected Object[] listItems = null;

    public ConvertProjectWizardPage(String pageName) {
        super(pageName);
        this.setTitle(this.getWzTitleResource());
        this.setDescription(this.getWzDescriptionResource());
    }

    protected abstract String getWzTitleResource();

    protected abstract String getWzDescriptionResource();

    protected Object[] getCheckedElements() {
        return this.tableViewer.getCheckedElements();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.setControl((Control)this.createAvailableProjectsGroup(container));
        this.addToMainPage(container);
        this.setPageComplete(this.validatePage());
    }

    protected void addToMainPage(Composite container) {
        Group area = ControlFactory.createGroup(container, CUIMessages.getString("ConvertProjectWizardPage.convertTo"), 2);
        SelectionAdapter cListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConvertProjectWizardPage.this.convertToC = ConvertProjectWizardPage.this.cRadioButton.getSelection();
                ConvertProjectWizardPage.this.convertToCC = ConvertProjectWizardPage.this.ccRadioButton.getSelection();
                ConvertProjectWizardPage.this.validatePage();
            }
        };
        this.cRadioButton = ControlFactory.createRadioButton((Composite)area, CUIMessages.getString("ConvertProjectWizardPage.CProject"), "C ", (SelectionListener)cListener);
        this.cRadioButton.setSelection(this.convertToC);
        this.ccRadioButton = ControlFactory.createRadioButton((Composite)area, CUIMessages.getString("ConvertProjectWizardPage.CppProject"), "C++", (SelectionListener)cListener);
        this.ccRadioButton.setSelection(this.convertToCC);
        area.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ConvertProjectWizardPage.this.cRadioButton = null;
                ConvertProjectWizardPage.this.ccRadioButton = null;
            }
        });
    }

    private final Composite createAvailableProjectsGroup(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CUIPlugin.getResourceString(PROJECT_LIST));
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        Table table = new Table(container, 2854);
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setHeaderVisible(false);
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.tableViewer.setInput((Object)this.getElements());
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof IProject && object2 instanceof IProject) {
                    IProject left = (IProject)object1;
                    IProject right = (IProject)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.tableViewer.setAllChecked(false);
        this.tableViewer.refresh();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ConvertProjectWizardPage.this.setPageComplete(ConvertProjectWizardPage.this.validatePage());
                ConvertProjectWizardPage.this.updateSelectionButtons();
            }
        });
        Composite buttons = new Composite(container, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 8;
        buttons.setLayout((Layout)layout);
        this.selectAllButton = new Button(buttons, 8);
        this.selectAllButton.setLayoutData((Object)ConvertProjectWizardPage.getButtonGridData(this.selectAllButton));
        this.selectAllButton.setText("Select All");
        this.selectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ConvertProjectWizardPage.this.tableViewer.setAllChecked(true);
                ConvertProjectWizardPage.this.setPageComplete(true);
                ConvertProjectWizardPage.this.updateSelectionButtons();
            }
        });
        this.deselectAllButton = new Button(buttons, 8);
        this.deselectAllButton.setLayoutData((Object)ConvertProjectWizardPage.getButtonGridData(this.deselectAllButton));
        this.deselectAllButton.setText("Deselect All");
        this.deselectAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ConvertProjectWizardPage.this.tableViewer.setAllChecked(false);
                ConvertProjectWizardPage.this.setPageComplete(false);
                ConvertProjectWizardPage.this.updateSelectionButtons();
            }
        });
        Object[] elements = this.getElements();
        boolean enableSelectionButtons = elements != null && elements.length > 0;
        this.selectAllButton.setEnabled(enableSelectionButtons);
        this.deselectAllButton.setEnabled(false);
        return parent;
    }

    protected void updateSelectionButtons() {
        int totalItems;
        Object[] checkedObjects = this.getCheckedElements();
        boolean allSelected = checkedObjects.length == (totalItems = this.tableViewer.getTable().getItemCount());
        boolean noneSelected = checkedObjects.length == 0;
        this.selectAllButton.setEnabled(!allSelected);
        this.deselectAllButton.setEnabled(!noneSelected);
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.widthHint = SWTUtil.getButtonWidthHint(button);
        data.heightHint = SWTUtil.getButtonHeigthHint(button);
        return data;
    }

    protected boolean validatePage() {
        Object[] selection = this.getCheckedElements();
        return selection != null && selection.length > 0;
    }

    protected Object[] getElements() {
        IWorkspace workspace = CUIPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        Vector<IProject> candidates = new Vector<IProject>(projects.length);
        IProject next = null;
        int i = 0;
        while (i < projects.length) {
            next = projects[i];
            if (next != null && next.isOpen() && this.isCandidate(next)) {
                candidates.addElement(next);
            }
            next = null;
            ++i;
        }
        Object[] candidateArray = null;
        if (candidates.size() > 0) {
            candidateArray = new Object[candidates.size()];
            candidates.copyInto(candidateArray);
        }
        this.listItems = candidateArray;
        return candidateArray;
    }

    public void doRun(IProgressMonitor monitor, String projectID) throws CoreException {
        Object[] selection = this.getCheckedElements();
        int totalSelected = selection.length;
        if (selection != null && totalSelected > 0) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CUIPlugin.getResourceString(KEY_TITLE), 1);
            this.convertProjects(selection, monitor, projectID);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertProjects(Object[] selected, IProgressMonitor monitor, String projectID) throws CoreException {
        monitor.beginTask(CUIPlugin.getResourceString(KEY_CONVERTING), selected.length);
        try {
            int i = 0;
            while (i < selected.length) {
                IProject project = (IProject)selected[i];
                this.convertProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1), projectID);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    public boolean finish() {
        return true;
    }

    public abstract boolean isCandidate(IProject var1);

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        if (this.convertToC) {
            if (!project.hasNature("org.eclipse.cdt.core.cnature")) {
                this.addCNature(project, monitor, true);
            } else if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                CCProjectNature.removeCCNature((IProject)project, (IProgressMonitor)monitor);
            }
        } else if (this.convertToCC && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
            this.addCCNature(project, monitor, true);
        }
    }

    protected void addCNature(IProject project, IProgressMonitor monitor, boolean addMakeBuilder) throws CoreException {
        if (this.getWizard() instanceof ConversionWizard) {
            CCorePlugin.getDefault().convertProjectToC(project, monitor, ((ConversionWizard)this.getWizard()).getProjectID());
        }
    }

    protected void addCCNature(IProject project, IProgressMonitor monitor, boolean addMakeBuilder) throws CoreException {
        if (this.getWizard() instanceof ConversionWizard) {
            if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                CCorePlugin.getDefault().convertProjectFromCtoCC(project, monitor);
            } else {
                CCorePlugin.getDefault().convertProjectToCC(project, monitor, ((ConversionWizard)this.getWizard()).getProjectID());
            }
        }
    }

    public class ProjectContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return ConvertProjectWizardPage.this.listItems;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return ((IProject)obj).getName();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }
}

