/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class EnableVariablesActionDelegate
implements IViewActionDelegate {
    private IViewPart fView;
    private IAction fAction;

    protected IViewPart getView() {
        return this.fView;
    }

    protected void setView(IViewPart view) {
        this.fView = view;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected boolean isEnableAction() {
        return true;
    }

    public void init(IViewPart view) {
        this.setView(view);
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        final int size = selection.size();
        if (size == 0) {
            return;
        }
        final Iterator iterator = selection.iterator();
        final MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("EnableVariablesActionDelegate.0"), null);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    ICVariable var = (ICVariable)iterator.next();
                    try {
                        if (size > 1) {
                            if (EnableVariablesActionDelegate.this.isEnableAction()) {
                                var.setEnabled(true);
                                continue;
                            }
                            var.setEnabled(false);
                            continue;
                        }
                        var.setEnabled(!var.isEnabled());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
                EnableVariablesActionDelegate.this.update();
            }
        });
        if (!ms.isOK()) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("EnableVariablesActionDelegate.1"), (IStatus)ms);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object o = sel.getFirstElement();
        if (!(o instanceof ICVariable)) {
            return;
        }
        Iterator iterator = sel.iterator();
        boolean allEnabled = true;
        boolean allDisabled = true;
        while (iterator.hasNext()) {
            ICVariable var = (ICVariable)iterator.next();
            if (!var.canEnableDisable()) continue;
            if (var.isEnabled()) {
                allDisabled = false;
                continue;
            }
            allEnabled = false;
        }
        if (this.isEnableAction()) {
            action.setEnabled(!allEnabled);
        } else {
            action.setEnabled(!allDisabled);
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getView().getViewSite().getSelectionProvider().getSelection();
    }

    protected void update() {
        this.getView().getViewSite().getSelectionProvider().setSelection(this.getView().getViewSite().getSelectionProvider().getSelection());
    }
}

