/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelBuilder;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CreateWorkingCopyOperation;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnitInfo;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TranslationUnit
extends Openable
implements ITranslationUnit {
    IPath location = null;
    protected IProblemRequestor problemRequestor;
    SourceManipulationInfo sourceManipulationInfo = null;

    public TranslationUnit(ICElement parent, IFile file) {
        super(parent, (IResource)file, 60);
    }

    public TranslationUnit(ICElement parent, IPath path) {
        super(parent, path, 60);
    }

    public ITranslationUnit getTranslationUnit() {
        return this;
    }

    public IInclude createInclude(String name, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String name, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        ICElement[] celements = this.getChildren();
        int i = 0;
        while (i < celements.length) {
            ISourceRange range = ((ISourceReference)((Object)celements[i])).getSourceRange();
            int startLine = range.getStartLine();
            int endLine = range.getEndLine();
            if (line >= startLine && line <= endLine) {
                return celements[i];
            }
            ++i;
        }
        return null;
    }

    public ICElement getElementAtOffset(int pos) throws CModelException {
        ICElement e = this.getSourceElementAtOffset(pos);
        if (e == this) {
            return null;
        }
        return e;
    }

    public ICElement[] getElementsAtOffset(int pos) throws CModelException {
        ICElement[] e = this.getSourceElementsAtOffset(pos);
        if (e.length == 1 && e[0] == this) {
            return CElement.NO_ELEMENTS;
        }
        return e;
    }

    public ICElement getElement(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (name.equals(celements[i].getElementName())) {
                    return celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude getInclude(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 72 && name.equals(celements[i].getElementName())) {
                    return (IInclude)celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 72) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IInclude[0]);
    }

    public IUsing getUsing(String name) {
        try {
            ICElement[] celements = this.getChildren();
            int i = 0;
            while (i < celements.length) {
                if (celements[i].getElementType() == 62 && name.equals(celements[i].getElementName())) {
                    return (IUsing)celements[i];
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        ICElement[] celements = this.getChildren();
        ArrayList<ICElement> aList = new ArrayList<ICElement>();
        int i = 0;
        while (i < celements.length) {
            if (celements[i].getElementType() == 62) {
                aList.add(celements[i]);
            }
            ++i;
        }
        return aList.toArray(new IUsing[0]);
    }

    public void setLocation(IPath loc) {
        this.location = loc;
    }

    public IPath getLocation() {
        if (this.location == null) {
            IFile file = this.getFile();
            if (file != null) {
                this.location = file.getLocation();
            } else {
                return this.getPath();
            }
        }
        return this.location;
    }

    protected IFile getFile() {
        IResource res = this.getResource();
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().copy(container, sibling, rename, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().delete(force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().move(container, sibling, rename, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        this.getSourceManipulationInfo().rename(name, force, monitor);
    }

    public String getSource() throws CModelException {
        return this.getSourceManipulationInfo().getSource();
    }

    public ISourceRange getSourceRange() throws CModelException {
        return this.getSourceManipulationInfo().getSourceRange();
    }

    protected TranslationUnitInfo getTranslationUnitInfo() throws CModelException {
        return (TranslationUnitInfo)this.getElementInfo();
    }

    protected SourceManipulationInfo getSourceManipulationInfo() {
        if (this.sourceManipulationInfo == null) {
            this.sourceManipulationInfo = new SourceManipulationInfo(this);
        }
        return this.sourceManipulationInfo;
    }

    protected CElementInfo createElementInfo() {
        return new TranslationUnitInfo(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ITranslationUnit)) {
            return false;
        }
        return super.equals(o) && !((ITranslationUnit)o).isWorkingCopy();
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = CModelManager.getDefault().sharedWorkingCopies).get(factory)) == null) {
            return null;
        }
        return (WorkingCopy)perFactoryWorkingCopies.get(this);
    }

    private void getNewElements(Map mapping, CElement element) {
        CElementInfo info = null;
        try {
            info = element.getElementInfo();
        }
        catch (CModelException cModelException) {}
        if (info != null && element instanceof IParent) {
            ICElement[] children = info.getChildren();
            int size = children.length;
            int i = 0;
            while (i < size) {
                CElement child = (CElement)children[i];
                this.getNewElements(mapping, child);
                ++i;
            }
        }
        mapping.put(element, info);
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        ITranslationUnit original;
        IResource r;
        TranslationUnitInfo unitInfo = (TranslationUnitInfo)info;
        CModelManager.getDefault().removeChildrenInfo(this);
        this.parse(newElements);
        if (this.isWorkingCopy() && (r = (original = ((IWorkingCopy)((Object)this)).getOriginalElement()).getResource()) != null && r instanceof IFile) {
            unitInfo.fTimestamp = ((IFile)r).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (CModelException cModelException) {
            return new char[0];
        }
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return this.getSharedWorkingCopy(monitor, factory, null);
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        WorkingCopy workingCopy;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager();
        }
        CModelManager manager = CModelManager.getDefault();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        HashMap perFactoryWorkingCopies = (HashMap)sharedWorkingCopies.get(factory);
        if (perFactoryWorkingCopies == null) {
            perFactoryWorkingCopies = new HashMap();
            sharedWorkingCopies.put(factory, perFactoryWorkingCopies);
        }
        if ((workingCopy = (WorkingCopy)perFactoryWorkingCopies.get(this)) != null) {
            ++workingCopy.useCount;
            return workingCopy;
        }
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, perFactoryWorkingCopies, factory, requestor);
        this.runOperation(op, monitor);
        return (IWorkingCopy)op.getResultElements()[0];
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return this.getWorkingCopy(null, null);
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        WorkingCopy workingCopy = new WorkingCopy(this.getParent(), this.getFile(), factory);
        workingCopy.open(monitor);
        return workingCopy;
    }

    protected boolean hasBuffer() {
        return true;
    }

    protected void openParent(Object childInfo, Map newElements, IProgressMonitor pm) throws CModelException {
        block2: {
            try {
                super.openParent(childInfo, newElements, pm);
            }
            catch (CModelException e) {
                if (this.isWorkingCopy()) break block2;
                throw e;
            }
        }
    }

    public boolean isConsistent() throws CModelException {
        return CModelManager.getDefault().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        IResource file;
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null && (file = this.getResource()) != null && file.getType() == 1) {
            buffer.setContents(Util.getResourceContentsAsCharArray((IFile)file));
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public Map parse() {
        HashMap map = new HashMap();
        try {
            this.getNewElements(map, this);
        }
        catch (Exception exception) {}
        return map;
    }

    private void parse(Map newElements) {
        try {
            CModelBuilder modelBuilder = new CModelBuilder(this, newElements);
            boolean quickParseMode = !CCorePlugin.getDefault().useStructuralParseMode();
            modelBuilder.parse(quickParseMode);
        }
        catch (Exception exception) {
            Util.debugLog("Exception in CModelBuilder", IDebugLogConstants.MODEL);
        }
    }

    public IProblemRequestor getProblemRequestor() {
        return this.problemRequestor;
    }

    public boolean isHeaderUnit() {
        IProject project = this.getCProject().getProject();
        return CoreModel.isValidHeaderUnitName(project, this.getPath().lastSegment());
    }

    public boolean isSourceUnit() {
        IProject project = this.getCProject().getProject();
        return CoreModel.isValidSourceUnitName(project, this.getPath().lastSegment());
    }

    public boolean isCLanguage() {
        IProject project = this.getCProject().getProject();
        ICFileType type = CCorePlugin.getDefault().getFileType(project, this.getPath().lastSegment());
        String lid = type.getLanguage().getId();
        return lid != null && lid.equals("org.eclipse.cdt.core.language.c");
    }

    public boolean isCXXLanguage() {
        IProject project = this.getCProject().getProject();
        ICFileType type = CCorePlugin.getDefault().getFileType(project, this.getPath().lastSegment());
        String lid = type.getLanguage().getId();
        return lid != null && lid.equals("org.eclipse.cdt.core.language.cxx");
    }

    public boolean isASMLanguage() {
        IProject project = this.getCProject().getProject();
        ICFileType type = CCorePlugin.getDefault().getFileType(project, this.getPath().lastSegment());
        String lid = type.getLanguage().getId();
        return lid != null && lid.equals("org.eclipse.cdt.core.language.asm");
    }

    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        return super.exists();
    }
}

