/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class ScannerConfigInfoFactory {
    private static final String PREFIX = MakeCorePlugin.getUniqueIdentifier();
    static final String BUILD_SCANNER_CONFIG_ENABLED = String.valueOf(PREFIX) + ".ScannerConfigDiscoveryEnabled";
    static final String MAKE_BUILDER_PARSER_ENABLED = String.valueOf(PREFIX) + ".makeBuilderParserEnabled";
    static final String MAKE_BUILDER_PARSER_ID = String.valueOf(PREFIX) + ".makeBuilderParserId";
    static final String ESI_PROVIDER_COMMAND_ENABLED = String.valueOf(PREFIX) + ".esiProviderCommandEnabled";
    static final String USE_DEFAULT_ESI_PROVIDER_CMD = String.valueOf(PREFIX) + ".useDefaultESIProviderCmd";
    static final String ESI_PROVIDER_COMMAND = String.valueOf(PREFIX) + ".esiProviderCommand";
    static final String ESI_PROVIDER_ARGUMENTS = String.valueOf(PREFIX) + ".esiProviderArguments";
    static final String ESI_PROVIDER_PARSER_ID = String.valueOf(PREFIX) + ".esiProviderParserId";
    static final String SI_PROBLEM_GENERATION_ENABLED = String.valueOf(PREFIX) + ".siProblemGenerationEnabled";

    public static IScannerConfigBuilderInfo create(Preferences prefs, String builderID, boolean useDefaults) {
        return new Preference(prefs, builderID, useDefaults);
    }

    public static IScannerConfigBuilderInfo create(IProject project, String builderID) throws CoreException {
        return new BuildProperty(project, builderID);
    }

    public static IScannerConfigBuilderInfo create(Map args, String builderID) {
        return new BuildArguments(args, builderID);
    }

    private static abstract class Store
    implements IScannerConfigBuilderInfo {
        Store() {
        }

        public boolean isAutoDiscoveryEnabled() {
            return this.getBoolean(BUILD_SCANNER_CONFIG_ENABLED);
        }

        public void setAutoDiscoveryEnabled(boolean enabled) throws CoreException {
            this.putString(BUILD_SCANNER_CONFIG_ENABLED, Boolean.toString(enabled));
        }

        public boolean isMakeBuilderConsoleParserEnabled() {
            if (this.getString(MAKE_BUILDER_PARSER_ENABLED) == null || this.getString(MAKE_BUILDER_PARSER_ENABLED).length() == 0) {
                return true;
            }
            return this.getBoolean(MAKE_BUILDER_PARSER_ENABLED);
        }

        public void setMakeBuilderConsoleParserEnabled(boolean enabled) throws CoreException {
            this.putString(MAKE_BUILDER_PARSER_ENABLED, Boolean.toString(enabled));
        }

        public String getMakeBuilderConsoleParserId() {
            String parserId = this.getString(MAKE_BUILDER_PARSER_ID);
            if (parserId == null || parserId.length() == 0) {
                String[] parserIds = MakeCorePlugin.getDefault().getScannerInfoConsoleParserIds("makeBuilder");
                parserId = parserIds[0];
            }
            return parserId;
        }

        public void setMakeBuilderConsoleParserId(String parserId) throws CoreException {
            this.putString(MAKE_BUILDER_PARSER_ID, parserId);
        }

        public boolean isESIProviderCommandEnabled() {
            if (this.getString(ESI_PROVIDER_COMMAND_ENABLED) == null || this.getString(ESI_PROVIDER_COMMAND_ENABLED).length() == 0) {
                return true;
            }
            return this.getBoolean(ESI_PROVIDER_COMMAND_ENABLED);
        }

        public void setESIProviderCommandEnabled(boolean enabled) throws CoreException {
            this.putString(ESI_PROVIDER_COMMAND_ENABLED, Boolean.toString(enabled));
        }

        public boolean isDefaultESIProviderCmd() {
            if (this.getString(USE_DEFAULT_ESI_PROVIDER_CMD) == null || this.getString(USE_DEFAULT_ESI_PROVIDER_CMD).length() == 0) {
                return true;
            }
            return this.getBoolean(USE_DEFAULT_ESI_PROVIDER_CMD);
        }

        public void setUseDefaultESIProviderCmd(boolean on) throws CoreException {
            this.putString(USE_DEFAULT_ESI_PROVIDER_CMD, Boolean.toString(on));
        }

        public IPath getESIProviderCommand() {
            if (this.isDefaultESIProviderCmd()) {
                String command = this.getESIProviderParameter("defaultCommand");
                if (command == null) {
                    return new Path("gcc");
                }
                return new Path(command);
            }
            return new Path(this.getString(ESI_PROVIDER_COMMAND));
        }

        public void setESIProviderCommand(IPath command) throws CoreException {
            this.putString(ESI_PROVIDER_COMMAND, command.toString());
        }

        public String getESIProviderArguments() {
            if (this.isDefaultESIProviderCmd()) {
                String attributes = this.getESIProviderParameter("defaultAttributes");
                if (attributes == null) {
                    attributes = "-E -P -v ${plugin_state_location}/{specs_file}";
                }
                return attributes;
            }
            return this.getString(ESI_PROVIDER_ARGUMENTS);
        }

        public void setESIProviderArguments(String args) throws CoreException {
            this.putString(ESI_PROVIDER_ARGUMENTS, args);
        }

        public String getESIProviderConsoleParserId() {
            String parserId = this.getString(ESI_PROVIDER_PARSER_ID);
            if (parserId == null || parserId.length() == 0) {
                String[] parserIds = MakeCorePlugin.getDefault().getScannerInfoConsoleParserIds("externalScannerInfoProvider");
                parserId = parserIds[0];
            }
            return parserId;
        }

        public void setESIProviderConsoleParserId(String parserId) throws CoreException {
            this.putString(ESI_PROVIDER_PARSER_ID, parserId);
        }

        public boolean isSIProblemGenerationEnabled() {
            if (this.getString(SI_PROBLEM_GENERATION_ENABLED) == null || this.getString(SI_PROBLEM_GENERATION_ENABLED).length() == 0) {
                return true;
            }
            return this.getBoolean(SI_PROBLEM_GENERATION_ENABLED);
        }

        public void setSIProblemGenerationEnabled(boolean enabled) throws CoreException {
            this.putString(SI_PROBLEM_GENERATION_ENABLED, Boolean.toString(enabled));
        }

        protected boolean getBoolean(String property) {
            return Boolean.valueOf(this.getString(property));
        }

        protected abstract String getBuilderID();

        protected abstract String getString(String var1);

        protected abstract void putString(String var1, String var2) throws CoreException;

        protected String getESIProviderParameter(String name) {
            IExtension extension = Platform.getExtensionRegistry().getExtension(MakeCorePlugin.getUniqueIdentifier(), "ExternalScannerInfoProvider", MakeCorePlugin.DEFAULT_EXTERNAL_SI_PROVIDER_ID);
            if (extension == null) {
                return null;
            }
            IConfigurationElement[] configs = extension.getConfigurationElements();
            if (configs.length == 0) {
                return null;
            }
            IConfigurationElement[] runElement = configs[0].getChildren("run");
            IConfigurationElement[] paramElement = runElement[0].getChildren("parameter");
            int i = 0;
            while (i < paramElement.length) {
                if (paramElement[i].getAttribute("name").equals(name)) {
                    return paramElement[i].getAttribute("value");
                }
                ++i;
            }
            return null;
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String builderID;
        private boolean useDefaults;

        Preference(Preferences prefs, String builderID, boolean useDefaults) {
            this.prefs = prefs;
            this.builderID = builderID;
            this.useDefaults = useDefaults;
        }

        protected void putString(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        protected String getString(String property) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(property);
            }
            return this.prefs.getString(property);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private String builderID;
        private Map args;

        BuildProperty(IProject project, String builderID) throws CoreException {
            this.project = project;
            this.builderID = builderID;
            ICommand builder = ScannerConfigNature.getBuildSpec(project.getDescription(), builderID);
            if (builder == null) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, String.valueOf(MakeMessages.getString("ScannerConfigInfoFactory.Missing_Builder")) + builderID, null));
            }
            this.args = builder.getArguments();
        }

        protected void putString(String name, String value) throws CoreException {
            String curValue = (String)this.args.get(name);
            if (curValue != null && curValue.equals(value)) {
                return;
            }
            IProjectDescription description = this.project.getDescription();
            ICommand builder = ScannerConfigNature.getBuildSpec(description, this.builderID);
            this.args.put(name, value);
            builder.setArguments(this.args);
            MakeProjectNature.setBuildSpec(description, builder);
            this.project.setDescription(description, null);
        }

        protected String getString(String name) {
            String value = (String)this.args.get(name);
            return value == null ? "" : value;
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildArguments
    extends Store {
        private Map args;
        private String builderID;

        BuildArguments(Map args, String builderID) {
            this.args = args;
            this.builderID = builderID;
        }

        protected void putString(String name, String value) {
            this.args.put(name, value);
        }

        protected String getString(String name) {
            return (String)this.args.get(name);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }
}

