/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class DiscoveryOptionsBlock
extends AbstractCOptionPage {
    private static final String PREFIX_BP = "BuildPathInfoBlock";
    private static final String SC_GROUP_LABEL = "BuildPathInfoBlock.scGroup.label";
    private static final String SC_ENABLED_LABEL = "BuildPathInfoBlock.scGroup.enabled.label";
    private static final String MISSING_BUILDER_MSG = "ScannerConfigOptionsDialog.label.missingBuilderInformation";
    private static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String DIALOG_TITLE = "ScannerConfigOptionsDialog.title";
    private static final String DIALOG_DESCRIPTION = "ScannerConfigOptionsDialog.description";
    private static final String SI_BUILD_PARSER_GROUP = "ScannerConfigOptionsDialog.siBuilder.parser.group_label";
    private static final String ENABLE_SI_BUILD_PARSER = "ScannerConfigOptionsDialog.siBuilder.parser.enable.label";
    private static final String SI_BUILD_PARSER_LABEL = "ScannerConfigOptionsDialog.siBuilder.parser.label";
    private static final String SI_PROVIDER_CMD_GROUP = "ScannerConfigOptionsDialog.siProvider.cmd.group_label";
    private static final String ENABLE_SI_PROVIDER_COMMAND = "ScannerConfigOptionsDialog.siProvider.cmd.enable.label";
    private static final String SI_PROVIDER_CMD_USE_DEFAULT = "ScannerConfigOptionsDialog.siProvider.cmd.use_default";
    private static final String SI_PROVIDER_CMD_LABEL = "ScannerConfigOptionsDialog.siProvider.cmd.label";
    private static final String SI_PROVIDER_PARSER_LABEL = "ScannerConfigOptionsDialog.siProvider.parser.label";
    private static final String SI_PROVIDER_CMD_ERROR_MESSAGE = "ScannerConfigOptionsDialog.siProvider.cmd.error_message";
    private static final String SI_PROBLEM_GROUP = "ScannerConfigOptionsDialog.siProblem.group.label";
    private static final String ENABLE_SI_PROBLEM_GENERATION = "ScannerConfigOptionsDialog.siProblem.generation.enable.label";
    private Button scEnabledButton;
    private boolean needsSCNature = false;
    private Button defESIProviderCommandButton;
    private Text esiProviderCommand;
    private Button enableBuilderParserButton;
    private Combo makeBuilderSIParserComboBox;
    private Button enableProviderCommandButton;
    private Combo esiProviderParserComboBox;
    private Button enableProblemGenerationButton;
    private Preferences fPrefs;
    private IScannerConfigBuilderInfo fBuildInfo;
    private boolean fInitialized = false;
    private Map builderParsers = new HashMap();
    private String initialBuilderParserId = null;
    private Map providerParsers = new HashMap();
    private String initialProviderParserId = null;
    private boolean fCreatePathContainer = false;

    public DiscoveryOptionsBlock() {
        super(MakeUIPlugin.getResourceString(DIALOG_TITLE));
        this.setDescription(MakeUIPlugin.getResourceString(DIALOG_DESCRIPTION));
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        this.fPrefs = this.getContainer().getPreferences();
        IProject project = this.getContainer().getProject();
        this.fInitialized = true;
        if (project != null) {
            try {
                this.fBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)project, (String)ScannerConfigBuilder.BUILDER_ID);
            }
            catch (CoreException coreException) {
                this.fInitialized = false;
                this.fBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
            }
        } else {
            this.fCreatePathContainer = true;
            this.fBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        }
        this.retrieveSIConsoleParsers();
        this.initialBuilderParserId = this.fBuildInfo.getMakeBuilderConsoleParserId();
        this.initialProviderParserId = this.fBuildInfo.getESIProviderConsoleParserId();
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IWorkspace workspace = MakeUIPlugin.getWorkspace();
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IScannerConfigBuilderInfo buildInfo;
                IProject project = DiscoveryOptionsBlock.this.getContainer().getProject();
                if (project != null) {
                    if (DiscoveryOptionsBlock.this.needsSCNature) {
                        ScannerConfigNature.addScannerConfigNature((IProject)DiscoveryOptionsBlock.this.getContainer().getProject());
                        DiscoveryOptionsBlock.this.needsSCNature = false;
                        DiscoveryOptionsBlock.this.fCreatePathContainer = true;
                    }
                    buildInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)project, (String)ScannerConfigBuilder.BUILDER_ID);
                    if (DiscoveryOptionsBlock.this.fCreatePathContainer) {
                        DiscoveryOptionsBlock.this.createDiscoveredPathContainer(project, monitor);
                        MakeCorePlugin.getDefault().getDiscoveryManager().removeDiscoveredInfo(project);
                        DiscoveryOptionsBlock.this.fCreatePathContainer = false;
                    }
                } else {
                    buildInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)DiscoveryOptionsBlock.this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
                }
                buildInfo.setAutoDiscoveryEnabled(DiscoveryOptionsBlock.this.isScannerConfigDiscoveryEnabled());
                if (DiscoveryOptionsBlock.this.isScannerConfigDiscoveryEnabled()) {
                    buildInfo.setMakeBuilderConsoleParserEnabled(DiscoveryOptionsBlock.this.isBuilderParserEnabled());
                    if (DiscoveryOptionsBlock.this.isBuilderParserEnabled()) {
                        buildInfo.setMakeBuilderConsoleParserId((String)DiscoveryOptionsBlock.this.builderParsers.get(DiscoveryOptionsBlock.this.makeBuilderSIParserComboBox.getText()));
                    }
                    buildInfo.setESIProviderCommandEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled());
                    if (DiscoveryOptionsBlock.this.isProviderCommandEnabled()) {
                        buildInfo.setUseDefaultESIProviderCmd(DiscoveryOptionsBlock.this.useDefaultESIProviderCmd());
                        if (!DiscoveryOptionsBlock.this.useDefaultESIProviderCmd()) {
                            DiscoveryOptionsBlock.this.storeSIProviderCommandLine(buildInfo);
                        }
                        buildInfo.setESIProviderConsoleParserId((String)DiscoveryOptionsBlock.this.providerParsers.get(DiscoveryOptionsBlock.this.esiProviderParserComboBox.getText()));
                    }
                    buildInfo.setSIProblemGenerationEnabled(DiscoveryOptionsBlock.this.isProblemGenerationEnabled());
                }
            }
        };
        if (this.getContainer().getProject() != null) {
            workspace.run(operation, monitor);
        } else {
            operation.run(monitor);
        }
    }

    private void createDiscoveredPathContainer(IProject project, IProgressMonitor monitor) throws CModelException {
        IPathEntry[] entries;
        ArrayList<IPathEntry> newEntries;
        IContainerEntry container = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        ICProject cProject = CoreModel.getDefault().create(project);
        if (cProject != null && !(newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries = cProject.getRawPathEntries()))).contains(container)) {
            newEntries.add((IPathEntry)container);
            cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
        }
    }

    public void performDefaults() {
        IScannerConfigBuilderInfo info = this.getContainer().getProject() != null ? MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false) : MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
        this.setScannerConfigDiscoveryEnabled(info.isAutoDiscoveryEnabled());
        this.enableBuilderParserButton.setSelection(info.isMakeBuilderConsoleParserEnabled());
        this.makeBuilderSIParserComboBox.setText(this.getParserName(this.builderParsers, info.getMakeBuilderConsoleParserId()));
        this.enableProviderCommandButton.setSelection(info.isESIProviderCommandEnabled());
        this.defESIProviderCommandButton.setSelection(info.isDefaultESIProviderCmd());
        this.setESIProviderCommandFrom(info);
        this.esiProviderParserComboBox.setText(this.getParserName(this.providerParsers, info.getESIProviderConsoleParserId()));
        this.enableAllControls();
    }

    private String getParserName(Map parsers, String consoleParserId) {
        Iterator i = parsers.keySet().iterator();
        while (i.hasNext()) {
            String parserName = (String)i.next();
            String parserId = (String)parsers.get(parserName);
            if (!parserId.equals(consoleParserId)) continue;
            return parserName;
        }
        return consoleParserId;
    }

    public void createControl(Composite parent) {
        int tabColumns = 2;
        Font font = parent.getFont();
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)tabColumns);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        composite.setFont(font);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.SCANNER_CONFIG_DISCOVERY_OPTIONS);
        if (this.createScannerConfigControls(composite, tabColumns)) {
            this.createBuildOutputParserControls(composite);
            this.createAfterBuildCmdControls(composite);
            this.createProblemGenerationControls(composite);
            this.enableAllControls();
        }
    }

    private boolean createScannerConfigControls(Composite parent, int numColumns) {
        IProject project = this.getContainer().getProject();
        boolean showMissingBuilder = false;
        try {
            if (project != null && project.hasNature(MakeProjectNature.NATURE_ID) && !project.hasNature(ScannerConfigNature.NATURE_ID)) {
                this.needsSCNature = true;
            }
        }
        catch (CoreException coreException) {
            showMissingBuilder = true;
        }
        Group scGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SC_GROUP_LABEL), (int)numColumns);
        scGroup.setFont(parent.getFont());
        ((GridData)scGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)scGroup.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)scGroup.getLayoutData()).horizontalAlignment = 4;
        if (showMissingBuilder || !this.needsSCNature && !this.fInitialized) {
            ControlFactory.createLabel((Composite)scGroup, (String)MakeUIPlugin.getResourceString(MISSING_BUILDER_MSG));
            return false;
        }
        this.scEnabledButton = ControlFactory.createCheckBox((Composite)scGroup, (String)MakeUIPlugin.getResourceString(SC_ENABLED_LABEL));
        this.scEnabledButton.setFont(parent.getFont());
        ((GridData)this.scEnabledButton.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.scEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.scEnabledButton.setSelection(this.needsSCNature ? false : this.fBuildInfo.isAutoDiscoveryEnabled());
        this.scEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.enableAllControls();
            }
        });
        return true;
    }

    private void retrieveSIConsoleParsers() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(MakeCorePlugin.getUniqueIdentifier(), "ScannerInfoConsoleParser");
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String parserId = extensions[i].getUniqueIdentifier();
                String label = extensions[i].getLabel();
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                String commandId = elements[0].getAttribute("commandId");
                if (commandId.equals("makeBuilder") || commandId.equals("all")) {
                    this.builderParsers.put(label, parserId);
                }
                if (commandId.equals("externalScannerInfoProvider") || commandId.equals("all")) {
                    this.providerParsers.put(label, parserId);
                }
                ++i;
            }
        }
    }

    private void createBuildOutputParserControls(Composite parent) {
        Group bopGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_GROUP), (int)2);
        ((GridLayout)bopGroup.getLayout()).marginHeight = 5;
        ((GridLayout)bopGroup.getLayout()).marginWidth = 5;
        ((GridData)bopGroup.getLayoutData()).verticalAlignment = 4;
        ((GridData)bopGroup.getLayoutData()).horizontalSpan = 2;
        this.enableBuilderParserButton = ControlFactory.createCheckBox((Composite)bopGroup, (String)MakeUIPlugin.getResourceString(ENABLE_SI_BUILD_PARSER));
        ((GridData)this.enableBuilderParserButton.getLayoutData()).horizontalSpan = 2;
        boolean enabledBuilderParser = this.fBuildInfo.isMakeBuilderConsoleParserEnabled();
        this.enableBuilderParserButton.setSelection(enabledBuilderParser);
        this.enableBuilderParserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.makeBuilderSIParserComboBox.setEnabled(DiscoveryOptionsBlock.this.isBuilderParserEnabled());
            }
        });
        Label label = ControlFactory.createLabel((Composite)bopGroup, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.makeBuilderSIParserComboBox = new Combo((Composite)bopGroup, 12);
        Iterator items = this.builderParsers.keySet().iterator();
        while (items.hasNext()) {
            String parser = (String)items.next();
            this.makeBuilderSIParserComboBox.add(parser);
            if (!this.initialBuilderParserId.equals(this.builderParsers.get(parser))) continue;
            this.makeBuilderSIParserComboBox.setText(parser);
        }
        this.makeBuilderSIParserComboBox.setEnabled(enabledBuilderParser);
    }

    private void createAfterBuildCmdControls(Composite parent) {
        Group abcGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_GROUP), (int)2);
        ((GridData)abcGroup.getLayoutData()).horizontalSpan = 2;
        this.enableProviderCommandButton = ControlFactory.createCheckBox((Composite)abcGroup, (String)MakeUIPlugin.getResourceString(ENABLE_SI_PROVIDER_COMMAND));
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        boolean enabledProviderCommand = this.fBuildInfo.isESIProviderCommandEnabled();
        this.enableProviderCommandButton.setSelection(enabledProviderCommand);
        this.enableProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.defESIProviderCommandButton.setEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled());
                DiscoveryOptionsBlock.this.esiProviderCommand.setEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled() && !DiscoveryOptionsBlock.this.useDefaultESIProviderCmd());
                DiscoveryOptionsBlock.this.esiProviderParserComboBox.setEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled());
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
        this.createESIProviderCmdControls((Composite)abcGroup);
        Label label = ControlFactory.createLabel((Composite)abcGroup, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderParserComboBox = new Combo((Composite)abcGroup, 12);
        Iterator items = this.providerParsers.keySet().iterator();
        while (items.hasNext()) {
            String parser = (String)items.next();
            this.esiProviderParserComboBox.add(parser);
            if (!this.initialProviderParserId.equals(this.providerParsers.get(parser))) continue;
            this.esiProviderParserComboBox.setText(parser);
        }
        this.defESIProviderCommandButton.setEnabled(enabledProviderCommand);
        this.esiProviderCommand.setEnabled(enabledProviderCommand && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(enabledProviderCommand);
    }

    private void createESIProviderCmdControls(Composite parent) {
        this.defESIProviderCommandButton = ControlFactory.createCheckBox((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_USE_DEFAULT));
        this.defESIProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.esiProviderCommand.setEnabled(!DiscoveryOptionsBlock.this.useDefaultESIProviderCmd());
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        Label label = ControlFactory.createLabel((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderCommand = ControlFactory.createTextField((Composite)parent, (int)2052);
        ((GridData)this.esiProviderCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.esiProviderCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        this.setESIProviderCommandFrom(this.fBuildInfo);
        if (this.fBuildInfo.isDefaultESIProviderCmd()) {
            this.esiProviderCommand.setEnabled(false);
        }
        this.esiProviderCommand.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
        this.defESIProviderCommandButton.setSelection(this.fBuildInfo.isDefaultESIProviderCmd());
    }

    private void createProblemGenerationControls(Composite parent) {
        Group problemGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SI_PROBLEM_GROUP), (int)2);
        ((GridData)problemGroup.getLayoutData()).horizontalSpan = 2;
        this.enableProblemGenerationButton = ControlFactory.createCheckBox((Composite)problemGroup, (String)MakeUIPlugin.getResourceString(ENABLE_SI_PROBLEM_GENERATION));
        ((GridData)this.enableProblemGenerationButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.enableProblemGenerationButton.getLayoutData()).horizontalAlignment = 768;
        boolean enabledProblemGeneration = this.fBuildInfo.isSIProblemGenerationEnabled();
        this.enableProblemGenerationButton.setSelection(enabledProblemGeneration);
        this.enableProblemGenerationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
    }

    private void setESIProviderCommandFrom(IScannerConfigBuilderInfo buildInfo) {
        IPath sCommand = buildInfo.getESIProviderCommand();
        if (sCommand != null) {
            StringBuffer cmd = new StringBuffer(sCommand.toOSString());
            String args = buildInfo.getESIProviderArguments();
            if (args != null && args.length() > 0) {
                cmd.append(' ');
                cmd.append(args);
            }
            this.esiProviderCommand.setText(cmd.toString());
        }
    }

    private void enableAllControls() {
        this.enableBuilderParserButton.setEnabled(this.isScannerConfigDiscoveryEnabled());
        this.makeBuilderSIParserComboBox.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isBuilderParserEnabled());
        this.enableProviderCommandButton.setEnabled(this.isScannerConfigDiscoveryEnabled());
        this.defESIProviderCommandButton.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isProviderCommandEnabled());
        this.esiProviderCommand.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isProviderCommandEnabled() && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isProviderCommandEnabled());
    }

    private boolean useDefaultESIProviderCmd() {
        return this.defESIProviderCommandButton.getSelection();
    }

    private String getSIProviderCommandLine() {
        return this.esiProviderCommand.getText().trim();
    }

    private boolean isBuilderParserEnabled() {
        return this.enableBuilderParserButton.getSelection();
    }

    private boolean isProviderCommandEnabled() {
        return this.enableProviderCommandButton.getSelection();
    }

    private boolean isProblemGenerationEnabled() {
        return this.enableProblemGenerationButton.getSelection();
    }

    private boolean isScannerConfigDiscoveryEnabled() {
        return this.scEnabledButton.getSelection();
    }

    private void setScannerConfigDiscoveryEnabled(boolean enabled) {
        this.scEnabledButton.setSelection(enabled);
    }

    private void storeSIProviderCommandLine(IScannerConfigBuilderInfo buildInfo) throws CoreException {
        String esiProviderLine = this.getSIProviderCommandLine();
        int start = 0;
        int end = -1;
        if (esiProviderLine.startsWith("\"")) {
            start = 1;
            end = esiProviderLine.indexOf(34, 1);
        } else {
            end = esiProviderLine.indexOf(32);
        }
        Path path = end == -1 ? new Path(esiProviderLine) : new Path(esiProviderLine.substring(start, end));
        buildInfo.setESIProviderCommand((IPath)path);
        String args = "";
        if (end != -1) {
            args = esiProviderLine.substring(end + 1);
        }
        buildInfo.setESIProviderArguments(args);
    }

    public boolean isValid() {
        String cmd;
        return !this.isProviderCommandEnabled() || this.useDefaultESIProviderCmd() || (cmd = this.getSIProviderCommandLine()) != null && cmd.length() != 0;
    }

    public String getErrorMessage() {
        if (!this.isValid()) {
            return MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_ERROR_MESSAGE);
        }
        return null;
    }
}

