/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.IOException;
import java.util.Map;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.index.impl.Int;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.processing.JobManager;

public class MergeFactory {
    protected IndexInput addsInput;
    protected IndexInput oldInput;
    protected BlocksIndexOutput mergeOutput;
    protected Map removedInOld;
    protected Map removedInAdds;
    protected int[] mappingOld;
    protected int[] mappingAdds;
    public static final int ADDS_INDEX = 0;
    public static final int OLD_INDEX = 1;

    public MergeFactory(IndexInput oldIndexInput, IndexInput addsIndexInput, BlocksIndexOutput mergeIndexOutput, Map removedInOld, Map removedInAdds) {
        this.oldInput = oldIndexInput;
        this.addsInput = addsIndexInput;
        this.mergeOutput = mergeIndexOutput;
        this.removedInOld = removedInOld;
        this.removedInAdds = removedInAdds;
    }

    protected void init() {
        this.mappingOld = new int[this.oldInput.getNumFiles() + 1];
        this.mappingAdds = new int[this.addsInput.getNumFiles() + 1];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void merge() throws IOException {
        try {
            try {
                this.addsInput.open();
                this.oldInput.open();
                this.mergeOutput.open();
                this.init();
                this.mergeFiles();
                this.mergeReferences();
                this.mergeIncludes();
                this.mergeOutput.flush();
            }
            catch (Exception ex) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> got the following exception during merge:");
                    ex.printStackTrace();
                }
            }
            catch (VirtualMachineError er) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> got the following exception during merge:");
                    er.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.oldInput.close();
            this.addsInput.close();
            this.mergeOutput.close();
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        this.oldInput.close();
        this.addsInput.close();
        this.mergeOutput.close();
    }

    protected void mergeFiles() throws IOException {
        int positionInMerge = 1;
        while (this.oldInput.hasMoreFiles() || this.addsInput.hasMoreFiles()) {
            IndexedFile file1 = this.oldInput.getCurrentFile();
            IndexedFile file2 = this.addsInput.getCurrentFile();
            while (file1 != null && this.wasRemoved(file1, 1)) {
                this.oldInput.moveToNextFile();
                file1 = this.oldInput.getCurrentFile();
            }
            while (file2 != null && this.wasRemoved(file2, 0)) {
                this.addsInput.moveToNextFile();
                file2 = this.addsInput.getCurrentFile();
            }
            if (file1 == null && file2 == null) break;
            int compare = file1 == null ? 1 : (file2 == null ? -1 : file1.getPath().compareTo(file2.getPath()));
            if (compare == 0) {
                this.removeFile(file1, 1);
                this.mappingAdds[file2.getFileNumber()] = positionInMerge;
                file1.setFileNumber(positionInMerge);
                this.mergeOutput.addFile(file1);
                this.oldInput.moveToNextFile();
                this.addsInput.moveToNextFile();
            } else if (compare < 0) {
                this.mappingOld[file1.getFileNumber()] = positionInMerge;
                file1.setFileNumber(positionInMerge);
                this.mergeOutput.addFile(file1);
                this.oldInput.moveToNextFile();
            } else {
                this.mappingAdds[file2.getFileNumber()] = positionInMerge;
                file2.setFileNumber(positionInMerge);
                this.mergeOutput.addFile(file2);
                this.addsInput.moveToNextFile();
            }
            ++positionInMerge;
        }
        this.mergeOutput.flushFiles();
    }

    protected void mergeReferences() throws IOException {
        while (this.oldInput.hasMoreWords() || this.addsInput.hasMoreWords()) {
            WordEntry word1 = this.oldInput.getCurrentWordEntry();
            WordEntry word2 = this.addsInput.getCurrentWordEntry();
            if (word1 == null && word2 == null) break;
            int compare = word1 == null ? 1 : (word2 == null ? -1 : Util.compare(word1.getWord(), word2.getWord()));
            if (compare < 0) {
                word1.mapRefs(this.mappingOld);
                this.mergeOutput.addWord(word1);
                this.oldInput.moveToNextWordEntry();
                continue;
            }
            if (compare > 0) {
                word2.mapRefs(this.mappingAdds);
                this.mergeOutput.addWord(word2);
                this.addsInput.moveToNextWordEntry();
                continue;
            }
            word1.mapRefs(this.mappingOld);
            word2.mapRefs(this.mappingAdds);
            word1.addRefs(word2.getRefs());
            this.mergeOutput.addWord(word1);
            this.addsInput.moveToNextWordEntry();
            this.oldInput.moveToNextWordEntry();
        }
        this.mergeOutput.flushWords();
    }

    protected void mergeIncludes() throws IOException {
        while (this.oldInput.hasMoreIncludes() || this.addsInput.hasMoreIncludes()) {
            IncludeEntry inc1 = this.oldInput.getCurrentIncludeEntry();
            IncludeEntry inc2 = this.addsInput.getCurrentIncludeEntry();
            if (inc1 == null && inc2 == null) break;
            int compare = inc1 == null ? 1 : (inc2 == null ? -1 : Util.compare(inc1.getFile(), inc2.getFile()));
            if (compare < 0) {
                inc1.mapRefs(this.mappingOld);
                this.mergeOutput.addInclude(inc1);
                this.oldInput.moveToNextIncludeEntry();
                continue;
            }
            if (compare > 0) {
                inc2.mapRefs(this.mappingAdds);
                this.mergeOutput.addInclude(inc2);
                this.addsInput.moveToNextIncludeEntry();
                continue;
            }
            inc1.mapRefs(this.mappingOld);
            inc2.mapRefs(this.mappingAdds);
            inc1.addRefs(inc2.getRefs());
            this.mergeOutput.addInclude(inc1);
            this.addsInput.moveToNextIncludeEntry();
            this.oldInput.moveToNextIncludeEntry();
        }
        this.mergeOutput.flushIncludes();
    }

    protected void removeFile(IndexedFile file, int index) {
        if (index == 1) {
            this.mappingOld[file.getFileNumber()] = -1;
        } else {
            this.mappingAdds[file.getFileNumber()] = -1;
        }
    }

    protected boolean wasRemoved(IndexedFile indexedFile, int index) {
        int fileNum;
        Int lastRemoved;
        String path = indexedFile.getPath();
        if (index == 1) {
            if (this.removedInOld.remove(path) != null) {
                this.mappingOld[indexedFile.getFileNumber()] = -1;
                return true;
            }
        } else if (index == 0 && (lastRemoved = (Int)this.removedInAdds.get(path)) != null && lastRemoved.value >= (fileNum = indexedFile.getFileNumber())) {
            this.mappingAdds[fileNum] = -1;
            return true;
        }
        return false;
    }
}

