/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;

public class ASTInitializerClause
implements IASTInitializerClause {
    private List references = new ArrayList();
    private IASTVariable ownerDeclaration = null;
    private final IASTInitializerClause.Kind kind;
    private final IASTExpression assignmentExpression;
    private final List initializerClauses;
    private final List designators;

    public ASTInitializerClause(IASTInitializerClause.Kind kind, IASTExpression assignmentExpression, List initializerClauses, List designators) {
        this.kind = kind;
        this.assignmentExpression = assignmentExpression;
        this.initializerClauses = initializerClauses;
        this.designators = designators;
    }

    public IASTInitializerClause.Kind getKind() {
        return this.kind;
    }

    public Iterator getInitializers() {
        if (this.initializerClauses == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.initializerClauses.iterator();
    }

    public IASTExpression getAssigmentExpression() {
        return this.assignmentExpression;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        Iterator i = this.getInitializers();
        while (i.hasNext()) {
            ((IASTInitializerClause)i.next()).acceptElement(requestor, manager);
        }
        if (this.assignmentExpression != null) {
            this.assignmentExpression.acceptElement(requestor, manager);
        }
        manager.processReferences(this.references, requestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public Iterator getDesignators() {
        return this.designators.iterator();
    }

    public void setOwnerVariableDeclaration(IASTVariable declaration) {
        this.ownerDeclaration = declaration;
        Iterator subInitializers = this.getInitializers();
        while (subInitializers.hasNext()) {
            ((IASTInitializerClause)subInitializers.next()).setOwnerVariableDeclaration(declaration);
        }
    }

    public IASTVariable getOwnerVariableDeclaration() {
        return this.ownerDeclaration;
    }

    public List getReferences() {
        return this.references;
    }

    public IASTExpression findExpressionForDuple(ITokenDuple finalDuple) throws ASTNotImplementedException {
        if (this.kind == IASTInitializerClause.Kind.EMPTY) {
            return null;
        }
        if (this.kind == IASTInitializerClause.Kind.ASSIGNMENT_EXPRESSION || this.kind == IASTInitializerClause.Kind.DESIGNATED_ASSIGNMENT_EXPRESSION) {
            return ((ASTExpression)this.assignmentExpression).findNewDescriptor(finalDuple);
        }
        Iterator i = this.getInitializers();
        while (i.hasNext()) {
            IASTInitializerClause clause = (IASTInitializerClause)i.next();
            IASTExpression e = clause.findExpressionForDuple(finalDuple);
            if (e == null) continue;
            return e;
        }
        return null;
    }
}

