/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;

public class ASTTemplateDeclaration
extends ASTSymbol
implements IASTTemplateDeclaration {
    private final List templateParameters;
    private ISymbol owned = null;
    private IASTScope ownerScope;
    private ITemplateFactory factory;
    private NamedOffsets offsets = new NamedOffsets();

    private ITemplateSymbol getTemplateSymbol() {
        return (ITemplateSymbol)(this.getSymbol() instanceof ITemplateSymbol ? this.getSymbol() : null);
    }

    public ASTTemplateDeclaration(ITemplateSymbol template, IASTScope scope, List parameters) {
        super(template);
        IContainerSymbol container = null;
        container = scope instanceof ASTTemplateDeclaration ? ((ASTTemplateDeclaration)scope).getContainerSymbol() : ((ASTScope)scope).getContainerSymbol();
        if (container instanceof ITemplateFactory) {
            this.factory = (ITemplateFactory)container;
        } else {
            this.factory = template.getSymbolTable().newTemplateFactory();
            this.factory.setContainingSymbol(container);
            this.factory.setASTExtension(new StandardSymbolExtension(this.factory, this));
        }
        this.factory.pushTemplate(template);
        this.templateParameters = parameters != null ? parameters : new LinkedList();
        this.ownerScope = scope;
    }

    public IASTScope getOwnerScope() {
        return this.ownerScope;
    }

    public boolean isExported() {
        return false;
    }

    public IASTDeclaration getOwnedDeclaration() {
        if (this.owned != null && this.owned.getASTExtension() != null) {
            ISymbolASTExtension extension = this.owned.getASTExtension();
            Iterator i = extension.getAllDefinitions();
            ASTSymbol s = null;
            while (i.hasNext()) {
                s = (ASTSymbol)i.next();
            }
            return s;
        }
        IContainerSymbol ownedSymbol = this.getTemplateSymbol().getTemplatedSymbol();
        if (ownedSymbol != null && ownedSymbol.getASTExtension() != null) {
            ASTNode node = ownedSymbol.getASTExtension().getPrimaryDeclaration();
            return node instanceof IASTDeclaration ? (IASTDeclaration)((Object)node) : null;
        }
        return null;
    }

    public void setOwnedDeclaration(ISymbol symbol) {
        this.owned = symbol;
    }

    public void releaseFactory() {
        this.factory = null;
    }

    public IContainerSymbol getContainerSymbol() {
        return this.factory != null ? this.factory : this.getTemplateSymbol();
    }

    public Iterator getTemplateParameters() {
        return this.templateParameters.iterator();
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterTemplateDeclaration(this);
        }
        catch (Exception exception) {}
        if (this.templateParameters == null || this.templateParameters.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.templateParameters.size()) {
            ((IASTTemplateParameter)this.templateParameters.get(i)).acceptElement(requestor, manager);
            ++i;
        }
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitTemplateDeclaration(this);
        }
        catch (Exception exception) {}
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public void setOwnedDeclaration(IASTDeclaration declaration) {
    }

    public Iterator getDeclarations() throws ASTNotImplementedException {
        return null;
    }
}

