/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class DeferredTemplateInstance
extends BasicSymbol
implements IDeferredTemplateInstance {
    private ITemplateSymbol _template;
    private List _arguments;

    public DeferredTemplateInstance(ParserSymbolTable table, ITemplateSymbol template, List args) {
        super(table, "");
        this._template = template;
        this._arguments = new ArrayList(args);
        this.setContainingSymbol(template);
        if (template.getTemplatedSymbol() != null) {
            this.setASTExtension(template.getTemplatedSymbol().getASTExtension());
        }
    }

    public ITemplateSymbol getTemplate() {
        return this._template;
    }

    public List getArguments() {
        return this._arguments;
    }

    public ISymbol instantiate(ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        List args = this.getArguments();
        ArrayList<TypeInfo> newArgs = new ArrayList<TypeInfo>(args.size());
        int size = args.size();
        int i = 0;
        while (i < size) {
            TypeInfo arg = (TypeInfo)args.get(i);
            newArgs.add(TemplateEngine.instantiateTypeInfo(arg, template, argMap));
            ++i;
        }
        ITemplateSymbol deferredTemplate = this.getTemplate();
        if (deferredTemplate.isType(TypeInfo.t_templateParameter) && argMap.containsKey(deferredTemplate)) {
            TypeInfo i2 = (TypeInfo)argMap.get(deferredTemplate);
            deferredTemplate = (ITemplateSymbol)i2.getTypeSymbol();
        }
        ISymbol instance = deferredTemplate.instantiate(newArgs);
        return instance;
    }

    public boolean isType(TypeInfo.eType type, TypeInfo.eType upperType) {
        IContainerSymbol symbol = this._template.getTemplatedSymbol();
        if (symbol != null) {
            return symbol.isType(type, upperType);
        }
        return super.isType(type, upperType);
    }

    public TypeInfo.eType getType() {
        IContainerSymbol symbol = this._template.getTemplatedSymbol();
        if (symbol != null) {
            return symbol.getType();
        }
        return super.getType();
    }

    public TypeInfo getTypeInfo() {
        IContainerSymbol symbol = this._template.getTemplatedSymbol();
        if (symbol != null) {
            return symbol.getTypeInfo();
        }
        return super.getTypeInfo();
    }

    public boolean isType(TypeInfo.eType type) {
        return this._template.getTemplatedSymbol().isType(type);
    }

    public ISymbolASTExtension getASTExtension() {
        if (super.getASTExtension() != null) {
            return super.getASTExtension();
        }
        if (this._template.getTemplatedSymbol() != null) {
            return this._template.getTemplatedSymbol().getASTExtension();
        }
        return this._template.getASTExtension();
    }
}

