/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.internal.core.parser.scanner2.CharArrayUtils;

public abstract class CharArrayMap {
    private char[][] keyTable;
    private int[] hashTable;
    private int[] nextTable;
    protected int currEntry = -1;

    protected CharArrayMap(int initialSize) {
        int size = 1;
        while (size < initialSize) {
            size <<= 1;
        }
        this.keyTable = new char[size][];
        this.hashTable = new int[size * 2];
        this.nextTable = new int[size];
    }

    protected int capacity() {
        return this.keyTable.length;
    }

    private int hash(char[] buffer, int start, int len) {
        return CharArrayUtils.hash(buffer, start, len) & this.keyTable.length - 1;
    }

    private int hash(char[] buffer) {
        return this.hash(buffer, 0, buffer.length);
    }

    private void insert(int i) {
        this.insert(i, this.hash(this.keyTable[i], 0, this.keyTable[i].length));
    }

    private void insert(int i, int hash) {
        if (this.hashTable[hash] == 0) {
            this.hashTable[hash] = i + 1;
        } else {
            int j = this.hashTable[hash] - 1;
            while (this.nextTable[j] != 0) {
                j = this.nextTable[j] - 1;
            }
            this.nextTable[j] = i + 1;
        }
    }

    protected void resize(int size) {
        char[][] oldKeyTable = this.keyTable;
        this.keyTable = new char[size][];
        System.arraycopy(oldKeyTable, 0, this.keyTable, 0, oldKeyTable.length);
        this.hashTable = new int[size * 2];
        this.nextTable = new int[size];
        int i = 0;
        while (i < oldKeyTable.length) {
            this.insert(i);
            ++i;
        }
    }

    private void resize() {
        this.resize(this.keyTable.length << 1);
    }

    protected final int add(char[] buffer, int start, int len) {
        int hash = this.hash(buffer, start, len);
        if (this.hashTable[hash] == 0) {
            if (++this.currEntry >= this.keyTable.length) {
                this.resize();
            }
            this.keyTable[this.currEntry] = CharArrayUtils.extract(buffer, start, len);
            this.insert(this.currEntry, hash);
            return this.currEntry;
        }
        int i = this.hashTable[hash] - 1;
        if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
            return i;
        }
        int last = i;
        i = this.nextTable[i] - 1;
        while (i >= 0) {
            if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
                return i;
            }
            last = i;
            i = this.nextTable[i] - 1;
        }
        if (++this.currEntry >= this.keyTable.length) {
            this.resize();
        }
        this.keyTable[this.currEntry] = CharArrayUtils.extract(buffer, start, len);
        this.nextTable[last] = this.currEntry + 1;
        return this.currEntry;
    }

    protected final int lookup(char[] buffer, int start, int len) {
        int hash = this.hash(buffer, start, len);
        if (this.hashTable[hash] == 0) {
            return -1;
        }
        int i = this.hashTable[hash] - 1;
        if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
            return i;
        }
        i = this.nextTable[i] - 1;
        while (i >= 0) {
            if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
                return i;
            }
            i = this.nextTable[i] - 1;
        }
        return -1;
    }

    protected void removeEntry(int i) {
        int j;
        int hash = this.hash(this.keyTable[i]);
        if (this.hashTable[hash] == i + 1) {
            this.hashTable[hash] = this.nextTable[i];
        } else {
            j = this.hashTable[hash] - 1;
            while (this.nextTable[j] != 0 && this.nextTable[j] != i + 1) {
                j = this.nextTable[j] - 1;
            }
            this.nextTable[j] = this.nextTable[i];
        }
        if (i < this.currEntry) {
            System.arraycopy(this.keyTable, i + 1, this.keyTable, i, this.currEntry - i);
            System.arraycopy(this.nextTable, i + 1, this.nextTable, i, this.currEntry - i);
            j = 0;
            while (j < this.hashTable.length) {
                if (this.hashTable[j] > i) {
                    int n = j;
                    this.hashTable[n] = this.hashTable[n] - 1;
                }
                ++j;
            }
            j = 0;
            while (j < this.nextTable.length) {
                if (this.nextTable[j] > i) {
                    int n = j;
                    this.nextTable[n] = this.nextTable[n] - 1;
                }
                ++j;
            }
        }
        this.keyTable[this.currEntry] = null;
        this.nextTable[this.currEntry] = 0;
        --this.currEntry;
    }

    public void dumpNexts() {
        int i = 0;
        while (i < this.nextTable.length) {
            if (this.nextTable[i] != 0) {
                System.out.print(i);
                int j = this.nextTable[i] - 1;
                while (j >= 0) {
                    System.out.print(" -> " + j);
                    j = this.nextTable[j] - 1;
                }
                System.out.println("");
            }
            ++i;
        }
    }
}

