/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast;

import java.util.Collections;
import java.util.Map;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTDesignator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCDesignator;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCExpression;
import org.eclipse.cdt.core.parser.ast.gcc.IASTGCCSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.extension.IASTFactoryExtension;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.gcc.ASTGCCSimpleTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.gcc.GCCASTCompleteExtension;
import org.eclipse.cdt.internal.core.parser.ast.expression.GCCASTExpressionExtension;
import org.eclipse.cdt.internal.core.parser.ast.gcc.ASTGCCDesignator;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public abstract class GCCASTExtension
implements IASTFactoryExtension {
    protected final ParserMode mode;
    protected static final String EMPTY_STRING = "";

    public GCCASTExtension(ParserMode mode) {
        this.mode = mode;
    }

    public boolean canHandleExpressionKind(IASTExpression.Kind kind) {
        return kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID || kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION || kind == IASTGCCExpression.Kind.UNARY_TYPEOF_UNARYEXPRESSION || kind == IASTGCCExpression.Kind.UNARY_TYPEOF_TYPEID || kind == IASTGCCExpression.Kind.RELATIONAL_MAX || kind == IASTGCCExpression.Kind.RELATIONAL_MIN;
    }

    public TypeInfo getExpressionResultType(IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTTypeId typeId) {
        TypeInfo info = null;
        if (kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_TYPEID || kind == IASTGCCExpression.Kind.UNARY_ALIGNOF_UNARYEXPRESSION) {
            info = new TypeInfo();
            info.setType(TypeInfo.t_int);
            info.setBit(true, 4096);
        } else if (kind == IASTGCCExpression.Kind.RELATIONAL_MAX || kind == IASTGCCExpression.Kind.RELATIONAL_MIN) {
            if (lhs instanceof ASTExpression) {
                info = new TypeInfo(((ASTExpression)lhs).getResultType().getResult());
            }
        } else if (kind == IASTGCCExpression.Kind.UNARY_TYPEOF_TYPEID) {
            if (typeId instanceof ASTTypeId) {
                info = new TypeInfo(((ASTTypeId)typeId).getTypeSymbol().getTypeInfo());
            }
        } else if (kind == IASTGCCExpression.Kind.UNARY_TYPEOF_UNARYEXPRESSION && lhs instanceof ASTExpression) {
            info = new TypeInfo(((ASTExpression)lhs).getResultType().getResult());
        }
        if (info != null) {
            return info;
        }
        return new TypeInfo();
    }

    public boolean overrideCreateSimpleTypeSpecifierMethod(IASTSimpleTypeSpecifier.Type type) {
        return type == IASTGCCSimpleTypeSpecifier.Type.TYPEOF;
    }

    public IASTSimpleTypeSpecifier createSimpleTypeSpecifier(ParserSymbolTable pst, IASTScope scope, IASTSimpleTypeSpecifier.Type kind, ITokenDuple typeName, boolean isShort, boolean isLong, boolean isSigned, boolean isUnsigned, boolean isTypename, boolean isComplex, boolean isImaginary, boolean isGlobal, Map extensionParms) {
        if (kind == IASTGCCSimpleTypeSpecifier.Type.TYPEOF) {
            ASTExpression typeOfExpression = (ASTExpression)extensionParms.get("TYPEOF EXPRESSION");
            ISymbol s = pst.newSymbol(EMPTY_STRING);
            s.setTypeInfo(typeOfExpression.getResultType().getResult());
            return new ASTGCCSimpleTypeSpecifier(s, isTypename, typeName == null ? EMPTY_STRING : typeName.toString(), Collections.EMPTY_LIST, typeOfExpression);
        }
        return null;
    }

    public boolean overrideCreateDesignatorMethod(IASTDesignator.DesignatorKind kind) {
        return kind == IASTGCCDesignator.DesignatorKind.SUBSCRIPT_RANGE;
    }

    public IASTDesignator createDesignator(IASTDesignator.DesignatorKind kind, IASTExpression constantExpression, IToken fieldIdentifier, Map extensionParms) {
        IASTExpression secondExpression = (IASTExpression)extensionParms.get("SUBSCRIPT2 EXPRESSION");
        return new ASTGCCDesignator(kind, constantExpression, EMPTY_STRING, -1, secondExpression);
    }

    public static IASTFactoryExtension createExtension(ParserMode parseMode) {
        if (parseMode == ParserMode.EXPRESSION_PARSE || parseMode == ParserMode.QUICK_PARSE) {
            return new GCCASTExpressionExtension(parseMode);
        }
        return new GCCASTCompleteExtension(parseMode);
    }
}

