/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTEnumerationSpecifier
extends ASTSymbol
implements IASTEnumerationSpecifier {
    private NamedOffsets offsets = new NamedOffsets();
    private final ASTQualifiedNamedElement qualifiedName;
    private List enumerators = Collections.EMPTY_LIST;
    private static final int ENUMERATOR_LIST_SIZE = 4;

    public ASTEnumerationSpecifier(ISymbol symbol, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine) {
        super(symbol);
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
    }

    public void addEnumerator(IASTEnumerator enumerator) {
        if (this.enumerators == Collections.EMPTY_LIST) {
            this.enumerators = new ArrayList(4);
        }
        this.enumerators.add(enumerator);
    }

    public Iterator getEnumerators() {
        return this.enumerators.iterator();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.acceptEnumerationSpecifier(this);
        }
        catch (Exception exception) {}
        if (this.enumerators.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.enumerators.size()) {
            IASTEnumerator enumerator = (IASTEnumerator)this.enumerators.get(i);
            if (enumerator.getInitialValue() != null) {
                enumerator.getInitialValue().acceptElement(requestor, manager);
            }
            ++i;
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public String getName() {
        return this.getSymbol().getName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public void freeReferences(IReferenceManager referenceManager) {
        if (this.enumerators.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.enumerators.size()) {
            ((IASTEnumerator)this.enumerators.get(i)).freeReferences(referenceManager);
            ++i;
        }
    }
}

