/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ParameterizedSymbol
extends ContainerSymbol
implements IParameterizedSymbol {
    private List _parameterList = Collections.EMPTY_LIST;
    private Map _parameterMap = Collections.EMPTY_MAP;
    private ISymbol _returnType;
    private boolean _hasVarArgs = false;

    protected ParameterizedSymbol(ParserSymbolTable table, String name) {
        super(table, name);
    }

    protected ParameterizedSymbol(ParserSymbolTable table, String name, ISymbolASTExtension obj) {
        super(table, name, obj);
    }

    protected ParameterizedSymbol(ParserSymbolTable table, String name, TypeInfo.eType typeInfo) {
        super(table, name, typeInfo);
    }

    public Object clone() {
        ParameterizedSymbol copy = (ParameterizedSymbol)super.clone();
        List list = copy._parameterList = this._parameterList != Collections.EMPTY_LIST ? (List)((ArrayList)this._parameterList).clone() : this._parameterList;
        copy._parameterMap = this.getSymbolTable().getParserMode() == ParserMode.COMPLETION_PARSE ? (this._parameterMap != Collections.EMPTY_MAP ? (Map)((TreeMap)this._parameterMap).clone() : this._parameterMap) : (this._parameterMap != Collections.EMPTY_MAP ? (Map)((HashMap)this._parameterMap).clone() : this._parameterMap);
        return copy;
    }

    public ISymbol instantiate(ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember()) {
            return null;
        }
        ParameterizedSymbol newParameterized = (ParameterizedSymbol)super.instantiate(template, argMap);
        if (this._returnType != null) {
            if (this._returnType.isType(TypeInfo.t_templateParameter)) {
                if (argMap.containsKey(this._returnType)) {
                    newParameterized.setReturnType(this.getSymbolTable().newSymbol(""));
                    newParameterized.getReturnType().setTypeInfo((TypeInfo)argMap.get(this._returnType));
                    newParameterized.getReturnType().setInstantiatedSymbol(this._returnType);
                }
            } else if (this._returnType instanceof IDeferredTemplateInstance) {
                template.registerDeferredInstatiation(newParameterized, this._returnType, ITemplateSymbol.DeferredKind.RETURN_TYPE, argMap);
            } else {
                newParameterized.setReturnType(this._returnType.instantiate(template, argMap));
            }
        }
        if (!this.isType(TypeInfo.t_template)) {
            List params = this.getParameterList();
            int size = params.size();
            newParameterized.getParameterList().clear();
            newParameterized.getParameterMap().clear();
            ISymbol param = null;
            ISymbol newParam = null;
            int i = 0;
            while (i < size) {
                param = (ISymbol)params.get(i);
                newParam = param.instantiate(template, argMap);
                newParameterized.addParameter(newParam);
                ++i;
            }
        }
        return newParameterized;
    }

    public void instantiateDeferredReturnType(ISymbol returnType, ITemplateSymbol template, Map argMap) throws ParserSymbolTableException {
        this.setReturnType(returnType.instantiate(template, argMap));
    }

    public void discardDeferredReturnType(ISymbol oldReturnType, TemplateSymbol template, Map map) {
        ISymbol returnType = this.getReturnType();
        this.setReturnType(null);
        template.removeInstantiation((IContainerSymbol)returnType);
    }

    public void prepareForParameters(int numParams) {
        if (this._parameterList == Collections.EMPTY_LIST) {
            this._parameterList = new ArrayList(numParams);
        } else {
            ((ArrayList)this._parameterList).ensureCapacity(numParams);
        }
    }

    public void addParameter(ISymbol param) {
        if (this._parameterList == Collections.EMPTY_LIST) {
            this._parameterList = new ArrayList(8);
        }
        this._parameterList.add(param);
        String name = param.getName();
        if (name != null && !name.equals("")) {
            if (this._parameterMap == Collections.EMPTY_MAP) {
                this._parameterMap = this.getSymbolTable().getParserMode() == ParserMode.COMPLETION_PARSE ? new TreeMap(new ContainerSymbol.SymbolTableComparator()) : new HashMap();
            }
            if (!this._parameterMap.containsKey(name)) {
                this._parameterMap.put(name, param);
            }
        }
        param.setContainingSymbol(this);
        param.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
    }

    public void addParameter(TypeInfo.eType type, int info, TypeInfo.PtrOp ptrOp, boolean hasDefault) {
        BasicSymbol param = new BasicSymbol(this.getSymbolTable(), "");
        TypeInfo t = param.getTypeInfo();
        t.setTypeInfo(info);
        t.setType(type);
        t.addPtrOperator(ptrOp);
        t.setHasDefault(hasDefault);
        this.addParameter(param);
    }

    public void addParameter(ISymbol typeSymbol, int info, TypeInfo.PtrOp ptrOp, boolean hasDefault) {
        BasicSymbol param = new BasicSymbol(this.getSymbolTable(), "");
        TypeInfo nfo = param.getTypeInfo();
        nfo.setTypeInfo(info);
        nfo.setType(TypeInfo.t_type);
        nfo.setTypeSymbol(typeSymbol);
        nfo.addPtrOperator(ptrOp);
        nfo.setHasDefault(hasDefault);
        this.addParameter(param);
    }

    public Map getParameterMap() {
        return this._parameterMap;
    }

    public List getParameterList() {
        return this._parameterList;
    }

    public boolean hasSameParameters(IParameterizedSymbol function) {
        int fsize;
        if (function.getType() != this.getType()) {
            return false;
        }
        int size = this.getParameterList() == null ? 0 : this.getParameterList().size();
        int n = fsize = function.getParameterList() == null ? 0 : function.getParameterList().size();
        if (fsize != size) {
            return false;
        }
        if (fsize == 0) {
            return true;
        }
        List params = this.getParameterList();
        List functionParams = function.getParameterList();
        TypeInfo info = null;
        TypeInfo fInfo = null;
        ParserSymbolTable.TypeInfoProvider provider = this.getSymbolTable().getTypeInfoProvider();
        int i = 0;
        while (i < size) {
            ISymbol p = (ISymbol)params.get(i);
            ISymbol pf = (ISymbol)functionParams.get(i);
            info = p.getTypeInfo();
            fInfo = pf.getTypeInfo();
            info = ParserSymbolTable.getFlatTypeInfo(info, provider);
            fInfo = ParserSymbolTable.getFlatTypeInfo(fInfo, provider);
            TypeInfo nfo = info;
            while (nfo != null) {
                TypeInfo.PtrOp op;
                ListIterator<TypeInfo.PtrOp> ptrs = nfo.getPtrOperators().listIterator();
                if (ptrs.hasNext() && (op = (TypeInfo.PtrOp)ptrs.next()).getType() == TypeInfo.PtrOp.t_array) {
                    ptrs.remove();
                    ptrs.add(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, op.isConst(), op.isVolatile()));
                }
                if (nfo.isType(TypeInfo.t_type) && nfo.getTypeSymbol() != null && nfo.getTypeSymbol().isType(TypeInfo.t_function) && nfo.getPtrOperators().size() == 0) {
                    nfo.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
                }
                if (nfo.getPtrOperators().size() == 0) {
                    nfo.setBit(false, 1024);
                    nfo.setBit(false, 2048);
                } else {
                    op = (TypeInfo.PtrOp)nfo.getPtrOperators().get(nfo.getPtrOperators().size() - 1);
                    op.setConst(false);
                    op.setVolatile(false);
                }
                if (nfo == fInfo) break;
                nfo = fInfo;
            }
            boolean equals = info.equals(fInfo);
            provider.returnTypeInfo(info);
            provider.returnTypeInfo(fInfo);
            if (!equals) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setReturnType(ISymbol type) {
        this._returnType = type;
        this._returnType.setContainingSymbol(this);
        this._returnType.setIsTemplateMember(this.isTemplateMember() || this.getType() == TypeInfo.t_template);
    }

    public ISymbol getReturnType() {
        return this._returnType;
    }

    public void setHasVariableArgs(boolean var) {
        this._hasVarArgs = var;
    }

    public boolean hasVariableArgs() {
        return this._hasVarArgs;
    }
}

