/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.actions.DeclarationsSearchGroup;
import org.eclipse.cdt.internal.ui.search.actions.ReferencesSearchGroup;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class SelectionSearchGroup
extends ActionGroup {
    private CEditor fEditor;
    private DeclarationsSearchGroup fDeclarationsSearchGroup;
    private ReferencesSearchGroup fRefSearchGroup;

    public SelectionSearchGroup(CEditor editor) {
        this.fEditor = editor;
        this.fDeclarationsSearchGroup = new DeclarationsSearchGroup(this.fEditor);
        this.fRefSearchGroup = new ReferencesSearchGroup(this.fEditor);
    }

    public SelectionSearchGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public SelectionSearchGroup(IWorkbenchSite site) {
        this.fDeclarationsSearchGroup = new DeclarationsSearchGroup(site);
        this.fRefSearchGroup = new ReferencesSearchGroup(site);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IMenuManager incomingMenu = menu;
        if (this.fEditor != null) {
            MenuManager selSearchMenu = new MenuManager(CSearchMessages.getString("group.search"), "group.search");
            menu.appendToGroup("group.find", (IContributionItem)selSearchMenu);
            incomingMenu = selSearchMenu;
        }
        this.fDeclarationsSearchGroup.fillContextMenu(incomingMenu);
        this.fRefSearchGroup.fillContextMenu(incomingMenu);
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return SelectionSearchGroup.getElement(selection) != null;
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public void dispose() {
        if (this.fDeclarationsSearchGroup != null) {
            this.fDeclarationsSearchGroup.dispose();
            this.fDeclarationsSearchGroup = null;
        }
        if (this.fRefSearchGroup != null) {
            this.fRefSearchGroup.dispose();
            this.fRefSearchGroup = null;
        }
        this.fEditor = null;
        super.dispose();
    }
}

