/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.model.ISwitchToFrame;
import org.eclipse.cdt.debug.core.model.ISwitchToThread;
import org.eclipse.cdt.debug.internal.ui.CBreakpointUpdater;
import org.eclipse.cdt.debug.internal.ui.CDTDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.ui.UIMessages;
import org.eclipse.cdt.debug.ui.sourcelookup.DefaultSourceLocator;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CDebugUIPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.ui";
    private static CDebugUIPlugin plugin;
    protected Map fDebuggerPageMap;
    private CDebugImageDescriptorRegistry fImageDescriptorRegistry;

    public CDebugUIPlugin() {
        plugin = this;
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (CDebugUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return CDebugUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public static CDTDebugModelPresentation getDebugModelPresentation() {
        return CDTDebugModelPresentation.getDefault();
    }

    public static void log(IStatus status) {
        CDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public static void logErrorMessage(String message) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public ILaunchConfigurationTab getDebuggerPage(String debuggerID) {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement configElement = (IConfigurationElement)this.fDebuggerPageMap.get(debuggerID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            try {
                tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 100, "An error occurred retrieving a C Debugger page", (Throwable)ce));
            }
        }
        return tab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "CDebuggerPage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("debuggerID");
            this.fDebuggerPageMap.put(id, infos[i]);
            ++i;
        }
    }

    public static void errorDialog(String message, IStatus status) {
        CDebugUIPlugin.log(status);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        CDebugUIPlugin.log(t);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CDebugImageDescriptorRegistry getImageDescriptorRegistry() {
        if (CDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            CDebugUIPlugin.getDefault().fImageDescriptorRegistry = new CDebugImageDescriptorRegistry();
        }
        return CDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element != null && element instanceof IThread) {
                if (((IThread)element).getDebugTarget() instanceof ISwitchToThread) {
                    try {
                        if (!this.sameThread((IDebugElement)element)) {
                            ((ISwitchToThread)((IThread)element).getDebugTarget()).setCurrentThread((IThread)element);
                        }
                    }
                    catch (DebugException e) {
                        CDebugUIPlugin.errorDialog(e.getMessage(), e);
                    }
                }
            } else if (element != null && element instanceof IStackFrame && ((IStackFrame)element).getThread() instanceof ISwitchToFrame) {
                try {
                    if (!this.sameThread((IDebugElement)element)) {
                        ((ISwitchToThread)((IStackFrame)element).getDebugTarget()).setCurrentThread(((IStackFrame)element).getThread());
                    }
                    ((ISwitchToFrame)((IStackFrame)element).getThread()).switchToFrame((IStackFrame)element);
                }
                catch (DebugException debugException) {}
            }
        }
    }

    private boolean sameThread(IDebugElement element) throws DebugException {
        if (element.getDebugTarget() instanceof ISwitchToThread) {
            if (element instanceof IThread) {
                return ((IThread)element).equals(((ISwitchToThread)element.getDebugTarget()).getCurrentThread());
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).getThread().equals(((ISwitchToThread)element.getDebugTarget()).getCurrentThread());
            }
        }
        return false;
    }

    public static IPersistableSourceLocator createDefaultSourceLocator() {
        return new DefaultSourceLocator();
    }

    public static String getDefaultSourceLocatorID() {
        return DefaultSourceLocator.ID_DEFAULT_SOURCE_LOCATOR;
    }

    public static String getDefaultSourceLocatorOldID() {
        return "org.eclipse.cdt.launch.DefaultSourceLocator";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.listenSelection(true, this);
        CDebugCorePlugin.getDefault().addCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
    }

    public void stop(BundleContext context) throws Exception {
        CDebugCorePlugin.getDefault().removeCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
        this.listenSelection(false, this);
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        super.stop(context);
    }

    void listenSelection(final boolean enable, final ISelectionListener listener) {
        Runnable r = new Runnable(){

            public void run() {
                IWorkbenchWindow ww = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (ww != null) {
                    if (enable) {
                        ww.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", listener);
                    } else {
                        ww.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", listener);
                    }
                }
            }
        };
        this.getWorkbench().getDisplay().asyncExec(r);
    }
}

