/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CGlobalVariable
extends CModificationVariable
implements ICGlobalVariable {
    public CGlobalVariable(CDebugElement parent, ICDIVariable cdiVariable) {
        super(parent, cdiVariable);
    }

    public IValue getValue() throws DebugException {
        if (!this.isEnabled()) {
            return CVariable.fDisabledValue;
        }
        if (this.fValue == null) {
            ICDIValue cdiValue = this.getCurrentValue();
            if (cdiValue instanceof ICDIArrayValue) {
                ICDIVariable var = null;
                try {
                    var = this.getCDIVariable();
                }
                catch (CDIException e) {
                    this.requestFailed("", e);
                }
                int[] dims = this.getType().getArrayDimensions();
                if (dims.length > 0 && dims[0] > 0) {
                    this.fValue = CValueFactory.createArrayValue(this, var, 0, dims.length - 1);
                }
            } else {
                this.fValue = CValueFactory.createGlobalValue(this, this.getCurrentValue());
            }
        }
        return this.fValue;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        super.handleDebugEvents(events);
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null && source.getTarget().equals(this.getCDITarget()) && event instanceof ICDIResumedEvent) {
                try {
                    this.setChanged(false);
                }
                catch (DebugException e) {
                    CDebugCorePlugin.log(e);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.getShadow() != null) {
            this.getShadow().dispose();
        }
        try {
            this.getCDISession().getVariableManager().destroyVariable(this.getCDIVariable());
        }
        catch (CDIException cDIException) {}
        super.dispose();
    }

    public boolean canEnableDisable() {
        return true;
    }
}

