/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.core.resources.IResource;

class CElementInfo {
    static Object[] NO_NON_C_RESOURCES = new Object[0];
    protected CElement element;
    private List fChildren;
    protected boolean fIsStructureKnown = false;
    protected long modificationStamp = 0L;

    protected CElementInfo(CElement element) {
        this.element = element;
        this.fChildren = new Vector(0);
    }

    protected CElement getElement() {
        return this.element;
    }

    protected void addChild(ICElement child) {
        this.fChildren.add(child);
    }

    protected ICElement[] getChildren() {
        List list = this.fChildren;
        synchronized (list) {
            ICElement[] array = new ICElement[this.fChildren.size()];
            return this.fChildren.toArray(array);
        }
    }

    protected boolean includesChild(ICElement child) {
        return this.fChildren.contains(child);
    }

    protected boolean isStructureKnown() {
        return this.fIsStructureKnown;
    }

    protected void removeChild(ICElement child) {
        this.fChildren.remove(child);
    }

    protected void removeChildren() {
        this.fChildren.clear();
    }

    protected void setChildren(List children) {
        this.fChildren.addAll(children);
    }

    protected boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    protected void setChanged() {
        this.modificationStamp = 0L;
    }

    protected boolean hasChanged() {
        IResource r = null;
        boolean b = false;
        r = this.getElement().getUnderlyingResource();
        if (r != null && r.exists()) {
            long modif = 0L;
            switch (r.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    File file = r.getLocation().toFile();
                    modif = file.lastModified();
                    break;
                }
                case 1: {
                    modif = r.getModificationStamp();
                }
            }
            b = modif != this.modificationStamp;
            this.modificationStamp = modif;
        }
        return b;
    }

    protected void setIsStructureKnown(boolean newIsStructureKnown) {
        this.fIsStructureKnown = newIsStructureKnown;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

