/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionConverter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IStructuredSelection convertSelectionToCElements(ISelection s) {
        ArrayList<Object> converted = new ArrayList<Object>();
        if (s instanceof StructuredSelection) {
            Object[] elements = ((StructuredSelection)s).toArray();
            int i = 0;
            while (i < elements.length) {
                Object e = elements[i];
                if (e instanceof ICElement) {
                    converted.add(e);
                } else if (e instanceof IAdaptable) {
                    ICElement c;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.model.ICElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((c = (ICElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                        converted.add(c);
                    }
                }
                ++i;
            }
        }
        return new StructuredSelection(converted.toArray());
    }

    public static IStructuredSelection convertSelectionToResources(ISelection s) {
        ArrayList<Object> converted = new ArrayList<Object>();
        if (s instanceof StructuredSelection) {
            Object[] elements = ((StructuredSelection)s).toArray();
            int i = 0;
            while (i < elements.length) {
                Object e = elements[i];
                if (e instanceof IResource) {
                    converted.add(e);
                } else if (e instanceof IAdaptable) {
                    IResource r;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((r = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        converted.add(r);
                    }
                }
                ++i;
            }
        }
        return new StructuredSelection(converted.toArray());
    }

    public static boolean allResourcesAreOfType(IStructuredSelection selection, int resourceMask) {
        Iterator resources = selection.iterator();
        while (resources.hasNext()) {
            IResource resource;
            Object next = resources.next();
            if (!(next instanceof IAdaptable)) continue;
            IAdaptable element = (IAdaptable)next;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)element.getAdapter((Class)clazz)) == null) {
                return false;
            }
            if (SelectionConverter.resourceIsType(resource, resourceMask)) continue;
            return false;
        }
        return true;
    }

    public static IStructuredSelection allResources(IStructuredSelection selection, int resourceMask) {
        Iterator adaptables = selection.iterator();
        ArrayList<IResource> result = new ArrayList<IResource>();
        while (adaptables.hasNext()) {
            Object next = adaptables.next();
            if (next instanceof IAdaptable) {
                IResource resource;
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                    return null;
                }
                if (!SelectionConverter.resourceIsType(resource, resourceMask)) continue;
                result.add(resource);
                continue;
            }
            return null;
        }
        return new StructuredSelection(result);
    }

    public static ICElement getElementAtOffset(ITextEditor editor) throws CModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static ICElement getElementAtOffset(ICElement input, ITextSelection selection) throws CModelException {
        if (input instanceof ITranslationUnit) {
            ICElement ref;
            ITranslationUnit tunit = (ITranslationUnit)input;
            if (tunit.isWorkingCopy()) {
                ITranslationUnit iTranslationUnit = tunit;
                synchronized (iTranslationUnit) {
                    if (tunit instanceof IWorkingCopy) {
                        ((IWorkingCopy)tunit).reconcile();
                    }
                }
            }
            if ((ref = tunit.getElementAtOffset(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static ICElement getInput(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public static boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }
}

