/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CygwinPEBinaryParserPage
extends AbstractCOptionPage {
    public static final String PREF_ADDR2LINE_PATH = "org.eclipse.cdt.ui.addr2line";
    public static final String PREF_CPPFILT_PATH = "org.eclipse.cdt.ui.cppfilt";
    public static final String PREF_CYGPATH_PATH = "org.eclipse.cdt.ui.cygpath";
    protected Text fAddr2LineCommandText;
    protected Text fCPPFiltCommandText;
    protected Text fCygPathCommandText;

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String addr2line = this.fAddr2LineCommandText.getText().trim();
        String cppfilt = this.fCPPFiltCommandText.getText().trim();
        String cygpath = this.fCygPathCommandText.getText().trim();
        monitor.beginTask(CUIMessages.getString("BinaryParserPage.task.savingAttributes"), 1);
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            String parserID = "";
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(proj);
            ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.BinaryParser");
            if (cext.length > 0) {
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
                IConfigurationElement[] infos = point.getConfigurationElements();
                int i = 0;
                while (i < infos.length) {
                    String id = infos[i].getAttribute("parserID");
                    String clazz = infos[i].getAttribute("class");
                    String ego = this.getClass().getName();
                    if (clazz != null && clazz.equals(ego)) {
                        parserID = id;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < cext.length) {
                    if (cext[i].getID().equals(parserID)) {
                        String orig = cext[i].getExtensionData("addr2line");
                        if (orig == null || !orig.equals(addr2line)) {
                            cext[i].setExtensionData("addr2line", addr2line);
                        }
                        if ((orig = cext[i].getExtensionData("c++filt")) == null || !orig.equals(cppfilt)) {
                            cext[i].setExtensionData("c++filt", cppfilt);
                        }
                        if ((orig = cext[i].getExtensionData("cygpath")) == null || !orig.equals(cygpath)) {
                            cext[i].setExtensionData("cygpath", cygpath);
                        }
                    }
                    ++i;
                }
            }
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                store.setValue(PREF_ADDR2LINE_PATH, addr2line);
                store.setValue(PREF_CPPFILT_PATH, cppfilt);
                store.setValue(PREF_CYGPATH_PATH, cygpath);
            }
        }
    }

    public void performDefaults() {
        String addr2line = null;
        String cppfilt = null;
        String cygpath = null;
        IProject proj = this.getContainer().getProject();
        Preferences store = this.getContainer().getPreferences();
        if (store != null) {
            if (proj != null) {
                addr2line = store.getString(PREF_ADDR2LINE_PATH);
                cppfilt = store.getString(PREF_CPPFILT_PATH);
                cygpath = store.getString(PREF_CYGPATH_PATH);
            } else {
                addr2line = store.getDefaultString(PREF_ADDR2LINE_PATH);
                cppfilt = store.getDefaultString(PREF_CPPFILT_PATH);
                cygpath = store.getDefaultString(PREF_CYGPATH_PATH);
            }
            this.fAddr2LineCommandText.setText(addr2line == null || addr2line.length() == 0 ? "addr2line" : addr2line);
            this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
            this.fCygPathCommandText.setText(cygpath == null || cygpath.length() == 0 ? "cygpath" : cygpath);
        }
    }

    public void createControl(Composite composite) {
        Group comp = new Group(composite, 16);
        comp.setText(CUIMessages.getString("BinaryParserBlock.binaryParserOptions"));
        comp.setLayout((Layout)new GridLayout(2, true));
        comp.setLayoutData((Object)new GridData(768));
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)comp, CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fAddr2LineCommandText = ControlFactory.createTextField((Composite)comp, 2052);
        this.fAddr2LineCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        Button button = ControlFactory.createPushButton((Composite)comp, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleAddr2LineButtonSelected();
            }

            private void handleAddr2LineButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CygwinPEBinaryParserPage.this.getShell(), 0);
                dialog.setText(CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
                String command = CygwinPEBinaryParserPage.this.fAddr2LineCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CygwinPEBinaryParserPage.this.fAddr2LineCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)comp, CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fCPPFiltCommandText = ControlFactory.createTextField((Composite)comp, 2052);
        gd = new GridData(768);
        this.fCPPFiltCommandText.setLayoutData((Object)gd);
        this.fCPPFiltCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        button = ControlFactory.createPushButton((Composite)comp, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleCPPFiltButtonSelected();
            }

            private void handleCPPFiltButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CygwinPEBinaryParserPage.this.getShell(), 0);
                dialog.setText(CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
                String command = CygwinPEBinaryParserPage.this.fCPPFiltCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CygwinPEBinaryParserPage.this.fCPPFiltCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)comp, CUIMessages.getString("BinaryParserPage.label.cygpathCommand"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fCygPathCommandText = ControlFactory.createTextField((Composite)comp, 2052);
        gd = new GridData(768);
        this.fCygPathCommandText.setLayoutData((Object)gd);
        this.fCygPathCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        button = ControlFactory.createPushButton((Composite)comp, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleCygPathButtonSelected();
            }

            private void handleCygPathButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(CygwinPEBinaryParserPage.this.getShell(), 0);
                dialog.setText(CUIMessages.getString("BinaryParserPage.label.cygpathCommand"));
                String command = CygwinPEBinaryParserPage.this.fCygPathCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                CygwinPEBinaryParserPage.this.fCygPathCommandText.setText(res);
            }
        });
        this.setControl((Control)comp);
        this.initializeValues();
    }

    private void initializeValues() {
        String addr2line = null;
        String cppfilt = null;
        String cygpath = null;
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            try {
                ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(proj);
                ICExtensionReference[] cext = cdesc.get("org.eclipse.cdt.core.BinaryParser");
                if (cext.length > 0) {
                    addr2line = cext[0].getExtensionData("addr2line");
                    cppfilt = cext[0].getExtensionData("c++filt");
                    cygpath = cext[0].getExtensionData("cygpath");
                }
            }
            catch (CoreException coreException) {}
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                addr2line = store.getString(PREF_ADDR2LINE_PATH);
                cppfilt = store.getString(PREF_CPPFILT_PATH);
                cygpath = store.getString(PREF_CYGPATH_PATH);
            }
        }
        this.fAddr2LineCommandText.setText(addr2line == null || addr2line.length() == 0 ? "addr2line" : addr2line);
        this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
        this.fCygPathCommandText.setText(cygpath == null || cygpath.length() == 0 ? "cygpath" : cygpath);
    }
}

