/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.util.regex.Pattern;

public class GDBTypeParser {
    static final int EOF = -1;
    static final int NAME = 0;
    static final int PARENS = 1;
    static final int BRACKETS = 2;
    String line;
    int index;
    int tokenType;
    String token;
    String dataType;
    String name;
    GDBDerivedType gdbDerivedType;
    GDBType genericType;

    public GDBType getGDBType() {
        if (this.gdbDerivedType != null) {
            return this.gdbDerivedType;
        }
        return this.genericType;
    }

    public String getVariableName() {
        return this.name;
    }

    public GDBType parse(String s) {
        if (s == null) {
            s = new String();
        }
        s = Pattern.compile("\\bconst\\b").matcher(s).replaceAll("");
        this.line = s = s.trim();
        this.index = 0;
        this.token = "";
        this.dataType = "";
        this.name = "";
        this.gdbDerivedType = null;
        while (this.getToken() == 0) {
            this.dataType = String.valueOf(this.dataType) + " " + this.token;
        }
        int column = this.dataType.indexOf(58);
        if (column > 0 && column + 1 < this.dataType.length() && this.dataType.charAt(column + 1) != ':') {
            this.dataType = this.dataType.substring(0, column);
        }
        this.genericType = new GDBType(this.dataType);
        this.dcl(this.tokenType);
        return this.getGDBType();
    }

    int getch() {
        if (this.index >= this.line.length() || this.index < 0) {
            return -1;
        }
        return this.line.charAt(this.index++);
    }

    void ungetch() {
        if (this.index > 0) {
            --this.index;
        }
    }

    boolean isCIdentifierStart(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95 || c == 58 || c == 44;
    }

    boolean isCIdentifierPart(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95 || c == 58;
    }

    boolean isCSpace(int c) {
        return c == 32 || c == 9 || c == 12 || c == 10;
    }

    void prependChild(int kind) {
        this.prependChild(kind, 0);
    }

    void prependChild(int kind, int d) {
        this.gdbDerivedType = this.gdbDerivedType == null ? new GDBDerivedType(this.genericType, kind, d) : new GDBDerivedType(this.gdbDerivedType, kind, d);
    }

    int getToken() {
        this.token = "";
        int c = this.getch();
        while (this.isCSpace(c)) {
            c = this.getch();
        }
        if (c == 40) {
            c = this.getch();
            if (c == 41) {
                this.token = "()";
                this.tokenType = 1;
            } else {
                this.ungetch();
                this.tokenType = 40;
            }
        } else if (c == 91) {
            while ((c = this.getch()) != 93 && c != -1) {
                this.token = String.valueOf(this.token) + (char)c;
            }
            this.tokenType = 2;
        } else if (this.isCIdentifierStart(c)) {
            this.token = "" + (char)c;
            while (this.isCIdentifierPart(c = this.getch()) && c != -1) {
                this.token = String.valueOf(this.token) + (char)c;
            }
            if (c != -1) {
                this.ungetch();
            }
            this.tokenType = 0;
        } else if (c == 123) {
            int count = 1;
            do {
                if ((c = this.getch()) == 123) {
                    ++count;
                    continue;
                }
                if (c != 125) continue;
                --count;
            } while (count > 0 && c != -1);
        } else {
            this.tokenType = c;
        }
        return this.tokenType;
    }

    void dcl() {
        this.dcl(this.getToken());
    }

    void dcl(int c) {
        int nstar = 0;
        int namp = 0;
        if (c == 42) {
            ++nstar;
            while (this.getToken() == 42) {
                ++nstar;
            }
        } else if (c == 38) {
            ++namp;
            while (this.getToken() == 38) {
                ++namp;
            }
        }
        this.dirdcl();
        while (nstar-- > 0) {
            this.prependChild(1);
        }
        while (namp-- > 0) {
            this.prependChild(2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dirdcl() {
        int type;
        int len;
        if (this.tokenType == 40) {
            this.dcl();
            if (this.tokenType != 41) {
                return;
            }
        } else if (this.tokenType == 0) {
            this.name = " " + this.token;
        } else if (this.tokenType == 1) {
            this.prependChild(4);
        } else {
            if (this.tokenType != 2) {
                return;
            }
            len = 0;
            if (this.token.length() > 0) {
                try {
                    len = Integer.parseInt(this.token);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.prependChild(3, len);
        }
        while ((type = this.getToken()) == 1 || type == 2) {
            if (type == -1) {
                return;
            }
            if (type == 1) {
                this.prependChild(4);
                continue;
            }
            len = 0;
            if (this.token.length() > 0) {
                try {
                    len = Integer.parseInt(this.token);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.prependChild(3, len);
        }
    }

    public static void main(String[] args) {
        GDBTypeParser parser = new GDBTypeParser();
        System.out.println("struct link { int i; int j; struct link * next} *");
        parser.parse("struct link { int i; int j; struct link * next} *");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("char **argv");
        parser.parse("unsigned long long int **argv");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("int (*daytab)[13]");
        parser.parse("int (*daytab)[13]");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("int *daytab[13]");
        parser.parse("int *daytab[13]");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("void *comp()");
        parser.parse("void *comp()");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("void (*comp)()");
        parser.parse("void (*comp)()");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("int (*func[15])()");
        parser.parse("int (*func[15])()");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("char (*(*x())[])()");
        parser.parse("char (*(*x())[])()");
        System.out.println(parser.getGDBType().verbose());
        System.out.println("char (*(*x[3])())[5]");
        parser.parse("char (*(*x[3])())[5]");
        System.out.println(parser.getGDBType().verbose());
    }

    public class GDBType {
        public static final int GENERIC = 0;
        public static final int POINTER = 1;
        public static final int REFERENCE = 2;
        public static final int ARRAY = 3;
        public static final int FUNCTION = 4;
        String nameType;
        int type;

        public GDBType(String n) {
            this(n, 0);
        }

        public GDBType(int t) {
            this("", t);
        }

        GDBType(String n, int t) {
            this.nameType = n;
            this.type = t;
        }

        public String toString() {
            return this.nameType;
        }

        public String verbose() {
            return this.nameType;
        }

        public int getType() {
            return this.type;
        }
    }

    public class GDBDerivedType
    extends GDBType {
        int dimension;
        GDBType child;

        public GDBDerivedType(GDBType c, int i) {
            this(c, i, 0);
        }

        public GDBDerivedType(GDBType c, int t, int dim) {
            super(t);
            this.setChild(c);
            this.dimension = dim;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setChild(GDBType c) {
            this.child = c;
        }

        public GDBType getChild() {
            return this.child;
        }

        public boolean hasChild() {
            return this.child != null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String childTypeName = this.hasChild() ? this.child.toString() : "";
            sb.append(childTypeName);
            switch (this.getType()) {
                case 4: {
                    sb.append("()");
                    break;
                }
                case 3: {
                    sb.append("[" + this.dimension + "]");
                    break;
                }
                case 2: {
                    sb.append("&");
                    break;
                }
                case 1: {
                    sb.append("*");
                }
            }
            return sb.toString();
        }

        public String verbose() {
            StringBuffer sb = new StringBuffer();
            switch (this.getType()) {
                case 4: {
                    sb.append(" function returning " + (this.hasChild() ? this.child.verbose() : ""));
                    break;
                }
                case 3: {
                    sb.append(" array[" + this.dimension + "]" + " of " + (this.hasChild() ? this.child.verbose() : ""));
                    break;
                }
                case 2: {
                    sb.append(" reference to " + (this.hasChild() ? this.child.verbose() : ""));
                    break;
                }
                case 1: {
                    sb.append(" pointer to " + (this.hasChild() ? this.child.verbose() : ""));
                }
            }
            return sb.toString();
        }
    }
}

