/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;

public class Register
extends Variable
implements ICDIRegister {
    public Register(RegisterObject obj, MIVar var) {
        super(obj, var);
    }

    public String getFullName() {
        String n;
        if (this.fullName == null && !(n = this.getName()).startsWith("$")) {
            this.fullName = "$" + n;
        }
        return this.fullName;
    }

    public ICDIVariable[] getChildren() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        RegisterManager mgr = (RegisterManager)session.getRegisterManager();
        CommandFactory factory = mi.getCommandFactory();
        MIVarListChildren var = factory.createMIVarListChildren(this.getMIVar().getVarName());
        try {
            mi.postCommand(var);
            MIVarListChildrenInfo info = var.getMIVarListChildrenInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            MIVar[] vars = info.getMIVars();
            this.children = new Register[vars.length];
            int i = 0;
            while (i < vars.length) {
                String exp = vars[i].getExp();
                String fn = this.isCPPLanguage() ? (exp.equals("private") || exp.equals("public") || exp.equals("protected") ? this.getFullName() : String.valueOf(this.getFullName()) + "." + exp) : String.valueOf(this.getFullName()) + "." + exp;
                RegisterObject regObj = new RegisterObject(this.getTarget(), exp, fn, this.getPosition());
                this.children[i] = mgr.createRegister(regObj, vars[i]);
                ++i;
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return this.children;
    }
}

