/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIBoolType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIEnumType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFunctionType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIStructType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Format;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ArrayValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.BoolValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.CharValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DoubleValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.EnumValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FloatValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.FunctionValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IntValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongLongValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.LongValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.PointerValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ReferenceValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.ShortValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.StructValue;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.WCharValue;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarAssign;
import org.eclipse.cdt.debug.mi.core.command.MIVarInfoExpression;
import org.eclipse.cdt.debug.mi.core.command.MIVarListChildren;
import org.eclipse.cdt.debug.mi.core.command.MIVarSetFormat;
import org.eclipse.cdt.debug.mi.core.command.MIVarShowAttributes;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarInfoExpressionInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarListChildrenInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarShowAttributesInfo;

public class Variable
extends VariableObject
implements ICDIVariable {
    MIVar miVar;
    Value value;
    ICDIVariable[] children = new ICDIVariable[0];
    String editable = null;
    String language;
    boolean isFake = false;

    public Variable(VariableObject obj, MIVar v) {
        super(obj);
        this.miVar = v;
    }

    public Variable(ICDITarget target, String n, String q, ICDIStackFrame stack, int pos, int depth, MIVar v) {
        super(target, n, q, stack, pos, depth);
        this.miVar = v;
    }

    public MIVar getMIVar() {
        return this.miVar;
    }

    public Variable getChild(String name) {
        int i = 0;
        while (i < this.children.length) {
            Variable variable = (Variable)this.children[i];
            if (name.equals(variable.getMIVar().getVarName())) {
                return variable;
            }
            Variable grandChild = variable.getChild(name);
            if (grandChild != null) {
                return grandChild;
            }
            ++i;
        }
        return null;
    }

    String getLanguage() throws CDIException {
        if (this.language == null) {
            Session session = (Session)this.getTarget().getSession();
            MISession mi = session.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarInfoExpression var = factory.createMIVarInfoExpression(this.getMIVar().getVarName());
            try {
                mi.postCommand(var);
                MIVarInfoExpressionInfo info = var.getMIVarInfoExpressionInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.language = info.getLanguage();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return this.language == null ? "" : this.language;
    }

    boolean isCPPLanguage() throws CDIException {
        return this.getLanguage().equalsIgnoreCase("C++");
    }

    void setIsFake(boolean f) {
        this.isFake = f;
    }

    boolean isFake() {
        return this.isFake;
    }

    public ICDIVariable[] getChildren() throws CDIException {
        return this.getChildren(-1);
    }

    public ICDIVariable[] getChildren(int timeout) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarListChildren var = factory.createMIVarListChildren(this.getMIVar().getVarName());
        try {
            if (timeout >= 0) {
                mi.postCommand(var, timeout);
            } else {
                mi.postCommand(var);
            }
            MIVarListChildrenInfo info = var.getMIVarListChildrenInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            MIVar[] vars = info.getMIVars();
            this.children = new Variable[vars.length];
            int i = 0;
            while (i < vars.length) {
                String fn = this.getFullName();
                String childName = vars[i].getExp();
                ICDIType childType = null;
                boolean childFake = false;
                ICDIType t = this.getType();
                if (t instanceof ICDIArrayType) {
                    fn = "(" + fn + ")[" + i + "]";
                    int index = this.castingIndex + i;
                    childName = String.valueOf(this.getName()) + "[" + index + "]";
                } else if (t instanceof ICDIPointerType) {
                    ICDIType subType = ((ICDIPointerType)t).getComponentType();
                    if (subType instanceof ICDIStructType) {
                        if (this.isCPPLanguage()) {
                            if (!this.isFake() || this.isFake() && !this.name.equals("private") && !this.name.equals("public") && !this.name.equals("protected")) {
                                childFake = true;
                                childType = t;
                            } else {
                                fn = "(" + fn + ")->" + vars[i].getExp();
                            }
                        } else {
                            fn = "(" + fn + ")->" + vars[i].getExp();
                        }
                    } else {
                        fn = "*(" + fn + ")";
                    }
                } else if (t instanceof ICDIStructType) {
                    if (this.isCPPLanguage()) {
                        if (!this.isFake() || this.isFake() && !this.name.equals("private") && !this.name.equals("public") && !this.name.equals("protected")) {
                            childFake = true;
                            childType = t;
                        } else {
                            fn = "(" + fn + ")." + vars[i].getExp();
                        }
                    } else {
                        fn = "(" + fn + ")." + vars[i].getExp();
                    }
                }
                Variable v = new Variable(this.getTarget(), childName, fn, this.getStackFrame(), this.getPosition(), this.getStackDepth(), vars[i]);
                if (childType != null) {
                    v.type = childType;
                }
                v.setIsFake(childFake);
                this.children[i] = v;
                ++i;
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        return this.children;
    }

    public int getChildrenNumber() throws CDIException {
        return this.miVar.getNumChild();
    }

    public ICDIValue getValue() throws CDIException {
        if (this.value == null) {
            ICDIType t = this.getType();
            this.value = t instanceof ICDIBoolType ? new BoolValue(this) : (t instanceof ICDICharType ? new CharValue(this) : (t instanceof ICDIWCharType ? new WCharValue(this) : (t instanceof ICDIShortType ? new ShortValue(this) : (t instanceof ICDIIntType ? new IntValue(this) : (t instanceof ICDILongType ? new LongValue(this) : (t instanceof ICDILongLongType ? new LongLongValue(this) : (t instanceof ICDIEnumType ? new EnumValue(this) : (t instanceof ICDIFloatType ? new FloatValue(this) : (t instanceof ICDIDoubleType ? new DoubleValue(this) : (t instanceof ICDIFunctionType ? new FunctionValue(this) : (t instanceof ICDIPointerType ? new PointerValue(this) : (t instanceof ICDIReferenceType ? new ReferenceValue(this) : (t instanceof ICDIArrayType ? new ArrayValue(this) : (t instanceof ICDIStructType ? new StructValue(this) : new Value(this)))))))))))))));
        }
        return this.value;
    }

    public void setValue(ICDIValue value) throws CDIException {
        this.setValue(value.getValueString());
    }

    public void setValue(String expression) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        MISession mi = session.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarAssign var = factory.createMIVarAssign(this.miVar.getVarName(), expression);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        MIVarChangedEvent change = new MIVarChangedEvent(var.getToken(), this.miVar.getVarName());
        mi.fireEvent(change);
        if (this instanceof Register) {
            ICDIRegisterManager mgr = session.getRegisterManager();
            if (mgr.isAutoUpdate()) {
                mgr.update();
            }
        } else if (this instanceof Expression) {
            ICDIExpressionManager mgr = session.getExpressionManager();
            if (mgr.isAutoUpdate()) {
                mgr.update();
            }
        } else {
            ICDIVariableManager mgr = session.getVariableManager();
            if (mgr.isAutoUpdate()) {
                mgr.update();
            }
        }
    }

    public boolean isEditable() throws CDIException {
        if (this.editable == null) {
            MISession mi = ((Session)this.getTarget().getSession()).getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarShowAttributes var = factory.createMIVarShowAttributes(this.miVar.getVarName());
            try {
                mi.postCommand(var);
                MIVarShowAttributesInfo info = var.getMIVarShowAttributesInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.editable = String.valueOf(info.isEditable());
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return this.editable == null ? false : this.editable.equalsIgnoreCase("true");
    }

    public void setFormat(int format) throws CDIException {
        int fmt = Format.toMIFormat(format);
        MISession mi = ((Session)this.getTarget().getSession()).getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIVarSetFormat var = factory.createMIVarSetFormat(this.miVar.getVarName(), fmt);
        try {
            mi.postCommand(var);
            MIInfo info = var.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public boolean equals(ICDIVariable var) {
        if (var instanceof Variable) {
            Variable variable = (Variable)var;
            return this.miVar.getVarName().equals(variable.getMIVar().getVarName());
        }
        return super.equals((ICDIVariableObject)var);
    }
}

