/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeInfoVisitor;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheManager;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.browser.util.ArrayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;

public class AllTypesCache {
    private static final int INITIAL_DELAY = 5000;
    private static IWorkingCopyProvider fgWorkingCopyProvider;
    private static TypeCacheManager fgTypeCacheManager;
    private static IElementChangedListener fgElementChangedListener;
    private static Preferences.IPropertyChangeListener fgPropertyChangeListener;
    private static boolean fgEnableIndexing;
    public static final String ENABLE_BACKGROUND_TYPE_CACHE = "enableBackgroundTypeCache";

    static {
        fgEnableIndexing = true;
    }

    public static void initialize(IWorkingCopyProvider workingCopyProvider) {
        fgWorkingCopyProvider = workingCopyProvider;
        fgTypeCacheManager = new TypeCacheManager(fgWorkingCopyProvider);
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        if (prefs.contains(ENABLE_BACKGROUND_TYPE_CACHE)) {
            fgEnableIndexing = prefs.getBoolean(ENABLE_BACKGROUND_TYPE_CACHE);
        } else {
            prefs.setDefault(ENABLE_BACKGROUND_TYPE_CACHE, true);
            prefs.setValue(ENABLE_BACKGROUND_TYPE_CACHE, true);
            CCorePlugin.getDefault().savePluginPreferences();
            fgEnableIndexing = true;
        }
        fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 5000);
        fgElementChangedListener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                fgTypeCacheManager.processDelta(event.getDelta());
                fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 0);
            }
        };
        CoreModel.getDefault().addElementChangedListener(fgElementChangedListener);
        fgPropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals(AllTypesCache.ENABLE_BACKGROUND_TYPE_CACHE)) {
                    String value = (String)event.getNewValue();
                    fgEnableIndexing = Boolean.valueOf(value);
                    if (!fgEnableIndexing) {
                        fgTypeCacheManager.cancelJobs();
                    } else {
                        fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 0);
                    }
                }
            }
        };
        prefs.addPropertyChangeListener(fgPropertyChangeListener);
    }

    public static void terminate() {
        if (fgElementChangedListener != null) {
            CoreModel.getDefault().removeElementChangedListener(fgElementChangedListener);
        }
        if (fgPropertyChangeListener != null) {
            CCorePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(fgPropertyChangeListener);
        }
        if (fgTypeCacheManager != null) {
            fgTypeCacheManager.cancelJobs();
        }
    }

    public static ITypeInfo[] getAllTypes() {
        final ArrayList fAllTypes = new ArrayList();
        TypeSearchScope workspaceScope = new TypeSearchScope(true);
        IProject[] projects = workspaceScope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                fAllTypes.add(info);
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            fgTypeCacheManager.getCache(projects[i]).accept(visitor);
            ++i;
        }
        return fAllTypes.toArray(new ITypeInfo[fAllTypes.size()]);
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope scope, int[] kinds) {
        final ArrayList fTypesFound = new ArrayList();
        final ITypeSearchScope fScope = scope;
        final int[] fKinds = kinds;
        IProject[] projects = scope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (ArrayUtil.contains(fKinds, info.getCElementType()) && fScope != null && info.isEnclosed(fScope)) {
                    fTypesFound.add(info);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            fgTypeCacheManager.getCache(projects[i]).accept(visitor);
            ++i;
        }
        return fTypesFound.toArray(new ITypeInfo[fTypesFound.size()]);
    }

    public static ITypeInfo[] getTypes(ITypeSearchScope scope, IQualifiedTypeName qualifiedName, int[] kinds) {
        final ArrayList fTypesFound = new ArrayList();
        final ITypeSearchScope fScope = scope;
        final int[] fKinds = kinds;
        final IQualifiedTypeName fQualifiedName = qualifiedName;
        IProject[] projects = scope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (ArrayUtil.contains(fKinds, info.getCElementType()) && fQualifiedName.equals(info.getQualifiedTypeName()) && fScope != null && info.isEnclosed(fScope)) {
                    fTypesFound.add(info);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            fgTypeCacheManager.getCache(projects[i]).accept(visitor);
            ++i;
        }
        return fTypesFound.toArray(new ITypeInfo[fTypesFound.size()]);
    }

    public static ITypeInfo[] getNamespaces(ITypeSearchScope scope, boolean includeGlobalNamespace) {
        final ArrayList<ITypeInfo> fTypesFound = new ArrayList<ITypeInfo>();
        final ITypeSearchScope fScope = scope;
        IProject[] projects = scope.getEnclosingProjects();
        ITypeInfoVisitor visitor = new ITypeInfoVisitor(){

            public boolean visit(ITypeInfo info) {
                if (info.getCElementType() == 61 && fScope != null && info.isEnclosed(fScope)) {
                    fTypesFound.add(info);
                }
                return true;
            }

            public boolean shouldContinue() {
                return true;
            }
        };
        int i = 0;
        while (i < projects.length) {
            ITypeCache cache = fgTypeCacheManager.getCache(projects[i]);
            cache.accept(visitor);
            if (includeGlobalNamespace) {
                fTypesFound.add(cache.getGlobalNamespace());
            }
            ++i;
        }
        return fTypesFound.toArray(new ITypeInfo[fTypesFound.size()]);
    }

    public static boolean isCacheUpToDate(ITypeSearchScope scope) {
        AllTypesCache.forceDeltaComplete();
        IProject[] projects = scope.getEnclosingProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.exists() && project.isOpen() && !fgTypeCacheManager.getCache(project).isUpToDate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void forceDeltaComplete() {
        if (fgWorkingCopyProvider != null) {
            IWorkingCopy[] workingCopies = fgWorkingCopyProvider.getWorkingCopies();
            int i = 0;
            while (i < workingCopies.length) {
                IWorkingCopy wc = workingCopies[i];
                try {
                    IWorkingCopy iWorkingCopy = wc;
                    synchronized (iWorkingCopy) {
                        wc.reconcile();
                    }
                }
                catch (CModelException cModelException) {}
                ++i;
            }
        }
    }

    public static void updateCache(ITypeSearchScope scope, IProgressMonitor monitor) {
        IProject[] projects = scope.getEnclosingProjects();
        monitor.beginTask(TypeCacheMessages.getString("AllTypesCache.updateCache.taskName"), projects.length);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            fgTypeCacheManager.getCache(project).reconcileAndWait(true, 20, monitor);
            ++i;
        }
        monitor.done();
    }

    public static ITypeReference resolveTypeLocation(ITypeInfo info, IProgressMonitor monitor) {
        ITypeReference location = info.getResolvedReference();
        if (location == null) {
            IProject project = info.getEnclosingProject();
            fgTypeCacheManager.getCache(project).cancelJobs();
            fgTypeCacheManager.getCache(project).locateTypeAndWait(info, 20, monitor);
            location = info.getResolvedReference();
            fgTypeCacheManager.reconcile(fgEnableIndexing, 40, 0);
        }
        return location;
    }
}

