/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class ASTTemplateParameter
extends ASTSymbol
implements IASTTemplateParameter,
IASTOffsetableNamedElement {
    private IASTTypeId defaultValue;
    private ASTParameterDeclaration parameter;
    private List parms;
    private final NamedOffsets offsets = new NamedOffsets();

    public ASTTemplateParameter(ISymbol sym, IASTTypeId defVal, IASTParameterDeclaration param, List parms, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, int endingOffset, int endingLine) {
        super(sym);
        this.symbol = sym;
        this.defaultValue = defVal;
        this.parameter = (ASTParameterDeclaration)param;
        this.parms = parms;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
    }

    public IASTTemplateParameter.ParamKind getTemplateParameterKind() {
        TypeInfo.eType type = this.symbol.getTypeInfo().getTemplateParameterType();
        if (type == TypeInfo.t_typeName) {
            return IASTTemplateParameter.ParamKind.TYPENAME;
        }
        if (type == TypeInfo.t_template) {
            return IASTTemplateParameter.ParamKind.TEMPLATE_LIST;
        }
        return IASTTemplateParameter.ParamKind.PARAMETER;
    }

    public String getIdentifier() {
        return this.symbol.getName();
    }

    public String getDefaultValueIdExpression() {
        return this.defaultValue != null ? this.defaultValue.toString() : "";
    }

    public IASTParameterDeclaration getParameterDeclaration() {
        return this.parameter;
    }

    public Iterator getTemplateParameters() {
        return this.parms.iterator();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        if (this.defaultValue != null) {
            this.defaultValue.acceptElement(requestor, manager);
        }
        if (this.parameter != null) {
            this.parameter.acceptElement(requestor, manager);
        }
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public String getName() {
        return this.symbol.getName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setNameEndOffsetAndLineNumber(offset, lineNumber);
    }

    public int getNameLineNumber() {
        return this.offsets.getNameLineNumber();
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setStartingOffsetAndLineNumber(offset, lineNumber);
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.offsets.setEndingOffsetAndLineNumber(offset, lineNumber);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public int getStartingLine() {
        return this.offsets.getStartingLine();
    }

    public int getEndingLine() {
        return this.offsets.getEndingLine();
    }
}

