/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;

public class ReferenceCache
implements IReferenceManager {
    private static final int DEFAULT_CACHE_SIZE = 64;
    private boolean[] classReferencesAvailable;
    private ASTReference[] classReferences = CLASSREF_FACTORY.createReferenceArray(64);
    private boolean[] variableReferencesAvailable;
    private ASTReference[] variableReferences = VARIABLEREF_FACTORY.createReferenceArray(64);
    private boolean[] fieldReferencesAvailable;
    private ASTReference[] fieldReferences = FIELDREF_FACTORY.createReferenceArray(64);
    private boolean[] functionReferencesAvailable;
    private ASTReference[] functionReferences = FUNCTIONREF_FACTORY.createReferenceArray(64);
    private boolean[] methodReferencesAvailable;
    private ASTReference[] methodReferences = METHODREF_FACTORY.createReferenceArray(64);
    private boolean[] enumerationReferencesAvailable;
    private ASTReference[] enumerationReferences = ENUMSPECREF_FACTORY.createReferenceArray(64);
    private boolean[] enumeratorReferencesAvailable;
    private ASTReference[] enumeratorReferences = ENUMERATORREF_FACTORY.createReferenceArray(64);
    private boolean[] namespaceReferencesAvailable;
    private ASTReference[] namespaceReferences = NAMESPACEREF_FACTORY.createReferenceArray(64);
    private boolean[] typedefReferencesAvailable;
    private ASTReference[] typedefReferences = TYPEDEFREF_FACTORY.createReferenceArray(64);
    private boolean[] parameterReferencesAvailable;
    private ASTReference[] parameterReferences = PARMREF_FACTORY.createReferenceArray(64);
    private boolean[] templateParameterReferencesAvailable;
    private ASTReference[] templateParameterReferences = TEMPPARMREF_FACTORY.createReferenceArray(64);
    private static final IReferenceFactory TYPEDEFREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTTypedefReference();
        }
    };
    private static final IReferenceFactory NAMESPACEREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTNamespaceReference();
        }
    };
    private static final IReferenceFactory PARMREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTParameterReference();
        }
    };
    private static final IReferenceFactory TEMPPARMREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTTemplateParameterReference();
        }
    };
    private static final IReferenceFactory CLASSREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTClassReference();
        }
    };
    private static final IReferenceFactory FUNCTIONREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTFunctionReference();
        }
    };
    private static final IReferenceFactory METHODREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTMethodReference();
        }
    };
    private static final IReferenceFactory VARIABLEREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTVariableReference();
        }
    };
    private static final IReferenceFactory FIELDREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTFieldReference();
        }
    };
    private static final IReferenceFactory ENUMSPECREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTEnumerationReference();
        }
    };
    private static final IReferenceFactory ENUMERATORREF_FACTORY = new BaseReferenceFactory(){

        public ASTReference createReference() {
            return new ASTEnumeratorReference();
        }
    };
    protected static final GrowResult growResult = new GrowResult();

    public ReferenceCache() {
        this.classReferencesAvailable = new boolean[64];
        this.variableReferencesAvailable = new boolean[64];
        this.fieldReferencesAvailable = new boolean[64];
        this.functionReferencesAvailable = new boolean[64];
        this.methodReferencesAvailable = new boolean[64];
        this.enumerationReferencesAvailable = new boolean[64];
        this.enumeratorReferencesAvailable = new boolean[64];
        this.templateParameterReferencesAvailable = new boolean[64];
        this.namespaceReferencesAvailable = new boolean[64];
        this.typedefReferencesAvailable = new boolean[64];
        this.parameterReferencesAvailable = new boolean[64];
        int i = 0;
        while (i < 64) {
            this.classReferencesAvailable[i] = true;
            this.variableReferencesAvailable[i] = true;
            this.fieldReferencesAvailable[i] = true;
            this.functionReferencesAvailable[i] = true;
            this.methodReferencesAvailable[i] = true;
            this.enumerationReferencesAvailable[i] = true;
            this.enumeratorReferencesAvailable[i] = true;
            this.namespaceReferencesAvailable[i] = true;
            this.typedefReferencesAvailable[i] = true;
            this.parameterReferencesAvailable[i] = true;
            this.templateParameterReferencesAvailable[i] = true;
            this.methodReferences[i] = METHODREF_FACTORY.createReference();
            this.classReferences[i] = CLASSREF_FACTORY.createReference();
            this.variableReferences[i] = VARIABLEREF_FACTORY.createReference();
            this.fieldReferences[i] = FIELDREF_FACTORY.createReference();
            this.functionReferences[i] = FUNCTIONREF_FACTORY.createReference();
            this.enumerationReferences[i] = ENUMSPECREF_FACTORY.createReference();
            this.enumeratorReferences[i] = ENUMERATORREF_FACTORY.createReference();
            this.typedefReferences[i] = TYPEDEFREF_FACTORY.createReference();
            this.namespaceReferences[i] = NAMESPACEREF_FACTORY.createReference();
            this.parameterReferences[i] = PARMREF_FACTORY.createReference();
            this.templateParameterReferences[i] = TEMPPARMREF_FACTORY.createReference();
            ++i;
        }
    }

    public void returnReference(IASTReference reference) {
        if (reference instanceof IASTClassReference) {
            this.returnReference(this.classReferencesAvailable, this.classReferences, reference);
            return;
        }
        if (reference instanceof IASTVariableReference) {
            this.returnReference(this.variableReferencesAvailable, this.variableReferences, reference);
            return;
        }
        if (reference instanceof IASTFieldReference) {
            this.returnReference(this.fieldReferencesAvailable, this.fieldReferences, reference);
            return;
        }
        if (reference instanceof IASTFunctionReference) {
            this.returnReference(this.functionReferencesAvailable, this.functionReferences, reference);
            return;
        }
        if (reference instanceof IASTMethodReference) {
            this.returnReference(this.methodReferencesAvailable, this.methodReferences, reference);
            return;
        }
        if (reference instanceof IASTEnumerationReference) {
            this.returnReference(this.enumerationReferencesAvailable, this.enumerationReferences, reference);
            return;
        }
        if (reference instanceof IASTEnumeratorReference) {
            this.returnReference(this.enumeratorReferencesAvailable, this.enumeratorReferences, reference);
            return;
        }
        if (reference instanceof IASTNamespaceReference) {
            this.returnReference(this.namespaceReferencesAvailable, this.namespaceReferences, reference);
            return;
        }
        if (reference instanceof IASTTypedefReference) {
            this.returnReference(this.typedefReferencesAvailable, this.typedefReferences, reference);
            return;
        }
        if (reference instanceof IASTParameterReference) {
            this.returnReference(this.parameterReferencesAvailable, this.parameterReferences, reference);
            return;
        }
        if (reference instanceof IASTTemplateParameterReference) {
            this.returnReference(this.templateParameterReferencesAvailable, this.templateParameterReferences, reference);
        }
    }

    private void returnReference(boolean[] referencesAvailable, ASTReference[] references, IASTReference reference) {
        int i = 0;
        while (i < referencesAvailable.length) {
            if (references[i] == reference) {
                referencesAvailable[i] = true;
                references[i].reset();
                break;
            }
            ++i;
        }
    }

    public IASTReference getReference(int offset, ISourceElementCallbackDelegate referencedElement) {
        if (referencedElement instanceof IASTTypedefDeclaration) {
            return this.getTypedefReference(offset, (IASTTypedefDeclaration)referencedElement);
        }
        if (referencedElement instanceof IASTEnumerationSpecifier) {
            return this.getEnumerationReference(offset, (IASTEnumerationSpecifier)referencedElement);
        }
        if (referencedElement instanceof IASTTemplateParameter) {
            return this.getTemplateParameterReference(offset, (IASTTemplateParameter)referencedElement);
        }
        if (referencedElement instanceof IASTParameterDeclaration) {
            return this.getParameterReference(offset, (IASTParameterDeclaration)referencedElement);
        }
        if (referencedElement instanceof IASTTypeSpecifier) {
            return this.getClassReference(offset, referencedElement);
        }
        if (referencedElement instanceof IASTNamespaceDefinition) {
            return this.getNamespaceReference(offset, (IASTNamespaceDefinition)referencedElement);
        }
        if (referencedElement instanceof IASTMethod) {
            return this.getMethodReference(offset, (IASTMethod)referencedElement);
        }
        if (referencedElement instanceof IASTFunction) {
            return this.getFunctionReference(offset, (IASTFunction)referencedElement);
        }
        if (referencedElement instanceof IASTField) {
            return this.getFieldReference(offset, (IASTField)referencedElement);
        }
        if (referencedElement instanceof IASTVariable) {
            return this.getVariableReference(offset, (IASTVariable)referencedElement);
        }
        if (referencedElement instanceof IASTEnumerator) {
            return this.getEnumeratorReference(offset, (IASTEnumerator)referencedElement);
        }
        return null;
    }

    private IASTReference getClassReference(int offset, ISourceElementCallbackDelegate referencedElement) {
        int i = 0;
        while (i < this.classReferencesAvailable.length) {
            if (this.classReferencesAvailable[i]) {
                this.classReferencesAvailable[i] = false;
                this.classReferences[i].initialize(offset, referencedElement);
                return this.classReferences[i];
            }
            ++i;
        }
        int currentSize = this.classReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.classReferences, this.classReferencesAvailable, CLASSREF_FACTORY);
        this.classReferences = g.getReferences();
        this.classReferencesAvailable = g.getAvailables();
        this.classReferencesAvailable[currentSize] = false;
        this.classReferences[currentSize].initialize(offset, referencedElement);
        return this.classReferences[currentSize];
    }

    protected static GrowResult growArrays(ASTReference[] inReferences, boolean[] inReferencesAvailable, IReferenceFactory factory) {
        int currentSize = inReferences.length;
        boolean[] availables = new boolean[currentSize * 2];
        System.arraycopy(inReferencesAvailable, 0, availables, 0, currentSize);
        ASTReference[] refs = factory.createReferenceArray(currentSize * 2);
        System.arraycopy(inReferences, 0, refs, 0, currentSize);
        int i = currentSize;
        while (i < availables.length) {
            refs[i] = factory.createReference();
            availables[i] = true;
            ++i;
        }
        growResult.initialize(availables, refs);
        return growResult;
    }

    private IASTReference getTypedefReference(int offset, IASTTypedefDeclaration referencedElement) {
        int i = 0;
        while (i < this.typedefReferencesAvailable.length) {
            if (this.typedefReferencesAvailable[i]) {
                this.typedefReferencesAvailable[i] = false;
                this.typedefReferences[i].initialize(offset, referencedElement);
                return this.typedefReferences[i];
            }
            ++i;
        }
        int currentSize = this.typedefReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.typedefReferences, this.typedefReferencesAvailable, TYPEDEFREF_FACTORY);
        this.typedefReferencesAvailable = g.getAvailables();
        this.typedefReferences = g.getReferences();
        this.typedefReferencesAvailable[currentSize] = false;
        this.typedefReferences[currentSize].initialize(offset, referencedElement);
        return this.typedefReferences[currentSize];
    }

    private IASTReference getVariableReference(int offset, IASTVariable referencedElement) {
        int i = 0;
        while (i < this.variableReferencesAvailable.length) {
            if (this.variableReferencesAvailable[i]) {
                this.variableReferencesAvailable[i] = false;
                this.variableReferences[i].initialize(offset, referencedElement);
                return this.variableReferences[i];
            }
            ++i;
        }
        int currentSize = this.variableReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.variableReferences, this.variableReferencesAvailable, VARIABLEREF_FACTORY);
        this.variableReferencesAvailable = g.getAvailables();
        this.variableReferences = g.getReferences();
        this.variableReferencesAvailable[currentSize] = false;
        this.variableReferences[currentSize].initialize(offset, referencedElement);
        return this.variableReferences[currentSize];
    }

    private IASTReference getParameterReference(int offset, IASTParameterDeclaration referencedElement) {
        int i = 0;
        while (i < this.parameterReferencesAvailable.length) {
            if (this.parameterReferencesAvailable[i]) {
                this.parameterReferencesAvailable[i] = false;
                this.parameterReferences[i].initialize(offset, referencedElement);
                return this.parameterReferences[i];
            }
            ++i;
        }
        int currentSize = this.parameterReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.parameterReferences, this.parameterReferencesAvailable, PARMREF_FACTORY);
        this.parameterReferencesAvailable = g.getAvailables();
        this.parameterReferences = g.getReferences();
        this.parameterReferencesAvailable[currentSize] = false;
        this.parameterReferences[currentSize].initialize(offset, referencedElement);
        return this.parameterReferences[currentSize];
    }

    private IASTReference getTemplateParameterReference(int offset, IASTTemplateParameter referencedElement) {
        int i = 0;
        while (i < this.templateParameterReferencesAvailable.length) {
            if (this.templateParameterReferencesAvailable[i]) {
                this.templateParameterReferencesAvailable[i] = false;
                this.templateParameterReferences[i].initialize(offset, referencedElement);
                return this.templateParameterReferences[i];
            }
            ++i;
        }
        int currentSize = this.templateParameterReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.templateParameterReferences, this.templateParameterReferencesAvailable, TEMPPARMREF_FACTORY);
        this.templateParameterReferencesAvailable = g.getAvailables();
        this.templateParameterReferences = g.getReferences();
        this.templateParameterReferencesAvailable[currentSize] = false;
        this.templateParameterReferences[currentSize].initialize(offset, referencedElement);
        return this.templateParameterReferences[currentSize];
    }

    private IASTReference getNamespaceReference(int offset, IASTNamespaceDefinition referencedElement) {
        int i = 0;
        while (i < this.namespaceReferencesAvailable.length) {
            if (this.namespaceReferencesAvailable[i]) {
                this.namespaceReferencesAvailable[i] = false;
                this.namespaceReferences[i].initialize(offset, referencedElement);
                return this.namespaceReferences[i];
            }
            ++i;
        }
        int currentSize = this.namespaceReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.namespaceReferences, this.namespaceReferencesAvailable, NAMESPACEREF_FACTORY);
        this.namespaceReferencesAvailable = g.getAvailables();
        this.namespaceReferences = g.getReferences();
        this.namespaceReferencesAvailable[currentSize] = false;
        this.namespaceReferences[currentSize].initialize(offset, referencedElement);
        return this.namespaceReferences[currentSize];
    }

    private IASTReference getEnumerationReference(int offset, IASTEnumerationSpecifier referencedElement) {
        int i = 0;
        while (i < this.enumerationReferencesAvailable.length) {
            if (this.enumerationReferencesAvailable[i]) {
                this.enumerationReferencesAvailable[i] = false;
                this.enumerationReferences[i].initialize(offset, referencedElement);
                return this.enumerationReferences[i];
            }
            ++i;
        }
        int currentSize = this.enumerationReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.enumerationReferences, this.enumerationReferencesAvailable, ENUMSPECREF_FACTORY);
        this.enumerationReferencesAvailable = g.getAvailables();
        this.enumerationReferences = g.getReferences();
        this.enumerationReferencesAvailable[currentSize] = false;
        this.enumerationReferences[currentSize].initialize(offset, referencedElement);
        return this.enumerationReferences[currentSize];
    }

    private IASTReference getEnumeratorReference(int offset, IASTEnumerator referencedElement) {
        int i = 0;
        while (i < this.enumeratorReferencesAvailable.length) {
            if (this.enumeratorReferencesAvailable[i]) {
                this.enumeratorReferencesAvailable[i] = false;
                this.enumeratorReferences[i].initialize(offset, referencedElement);
                return this.enumeratorReferences[i];
            }
            ++i;
        }
        int currentSize = this.enumeratorReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.enumeratorReferences, this.enumeratorReferencesAvailable, ENUMERATORREF_FACTORY);
        this.enumeratorReferencesAvailable = g.getAvailables();
        this.enumeratorReferences = g.getReferences();
        this.enumeratorReferencesAvailable[currentSize] = false;
        this.enumeratorReferences[currentSize].initialize(offset, referencedElement);
        return this.enumeratorReferences[currentSize];
    }

    private IASTReference getMethodReference(int offset, IASTMethod referencedElement) {
        int i = 0;
        while (i < this.methodReferencesAvailable.length) {
            if (this.methodReferencesAvailable[i]) {
                this.methodReferencesAvailable[i] = false;
                this.methodReferences[i].initialize(offset, referencedElement);
                return this.methodReferences[i];
            }
            ++i;
        }
        int currentSize = this.methodReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.methodReferences, this.methodReferencesAvailable, METHODREF_FACTORY);
        this.methodReferencesAvailable = g.getAvailables();
        this.methodReferences = g.getReferences();
        this.methodReferencesAvailable[currentSize] = false;
        this.methodReferences[currentSize].initialize(offset, referencedElement);
        return this.methodReferences[currentSize];
    }

    private IASTReference getFunctionReference(int offset, IASTFunction referencedElement) {
        int i = 0;
        while (i < this.functionReferencesAvailable.length) {
            if (this.functionReferencesAvailable[i]) {
                this.functionReferencesAvailable[i] = false;
                this.functionReferences[i].initialize(offset, referencedElement);
                return this.functionReferences[i];
            }
            ++i;
        }
        int currentSize = this.functionReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.functionReferences, this.functionReferencesAvailable, FUNCTIONREF_FACTORY);
        this.functionReferencesAvailable = g.getAvailables();
        this.functionReferences = g.getReferences();
        this.functionReferencesAvailable[currentSize] = false;
        this.functionReferences[currentSize].initialize(offset, referencedElement);
        return this.functionReferences[currentSize];
    }

    private IASTReference getFieldReference(int offset, IASTField referencedElement) {
        int i = 0;
        while (i < this.fieldReferencesAvailable.length) {
            if (this.fieldReferencesAvailable[i]) {
                this.fieldReferencesAvailable[i] = false;
                this.fieldReferences[i].initialize(offset, referencedElement);
                return this.fieldReferences[i];
            }
            ++i;
        }
        int currentSize = this.fieldReferences.length;
        GrowResult g = ReferenceCache.growArrays(this.fieldReferences, this.fieldReferencesAvailable, FIELDREF_FACTORY);
        this.fieldReferencesAvailable = g.getAvailables();
        this.fieldReferences = g.getReferences();
        this.fieldReferencesAvailable[currentSize] = false;
        this.fieldReferences[currentSize].initialize(offset, referencedElement);
        return this.fieldReferences[currentSize];
    }

    public void processReferences(List references, ISourceElementRequestor requestor) {
        if (references == null || references.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < references.size()) {
            IASTReference reference = (IASTReference)references.get(i);
            reference.acceptElement(requestor, this);
            this.returnReference(reference);
            ++i;
        }
        references.clear();
    }

    public boolean isBalanced() {
        return this.isBalanced(this.classReferencesAvailable) && this.isBalanced(this.variableReferencesAvailable) && this.isBalanced(this.fieldReferencesAvailable) && this.isBalanced(this.functionReferencesAvailable) && this.isBalanced(this.methodReferencesAvailable) && this.isBalanced(this.enumerationReferencesAvailable) && this.isBalanced(this.enumeratorReferencesAvailable) && this.isBalanced(this.parameterReferencesAvailable) && this.isBalanced(this.templateParameterReferencesAvailable) && this.isBalanced(this.typedefReferencesAvailable);
    }

    private boolean isBalanced(boolean[] referencesAvailable) {
        int i = 0;
        while (i < referencesAvailable.length) {
            if (!referencesAvailable[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private interface IReferenceFactory {
        public ASTReference createReference();

        public ASTReference[] createReferenceArray(int var1);
    }

    private static abstract class BaseReferenceFactory
    implements IReferenceFactory {
        BaseReferenceFactory() {
        }

        public ASTReference[] createReferenceArray(int size) {
            return new ASTReference[size];
        }
    }

    protected static class GrowResult {
        private boolean[] b;
        private ASTReference[] r;

        protected GrowResult() {
        }

        public void initialize(boolean[] bools, ASTReference[] refs) {
            this.b = bools;
            this.r = refs;
        }

        public boolean[] getAvailables() {
            return this.b;
        }

        public ASTReference[] getReferences() {
            return this.r;
        }
    }

    public static abstract class ASTReference
    implements IASTReference {
        protected int offset;
        private static final String EMPTY_STRING = "";

        public abstract void reset();

        protected void resetOffset() {
            this.offset = 0;
        }

        public abstract void initialize(int var1, ISourceElementCallbackDelegate var2);

        protected void initialize(int o) {
            this.offset = o;
        }

        public ASTReference(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getName() {
            if (this.getReferencedElement() instanceof IASTOffsetableNamedElement) {
                return ((IASTOffsetableNamedElement)((Object)this.getReferencedElement())).getName();
            }
            return EMPTY_STRING;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IASTReference)) {
                return false;
            }
            return ((IASTReference)obj).getName().equals(this.getName()) && ((IASTReference)obj).getOffset() == this.getOffset();
        }

        public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        }

        public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        }
    }

    public static class ASTClassReference
    extends ASTReference
    implements IASTClassReference {
        private IASTTypeSpecifier reference;

        public ASTClassReference(int i, IASTTypeSpecifier specifier) {
            super(i);
            this.reference = specifier;
        }

        public void initialize(int o, ISourceElementCallbackDelegate specifier) {
            super.initialize(o);
            this.reference = (IASTTypeSpecifier)((Object)specifier);
        }

        public void reset() {
            super.resetOffset();
            this.reference = null;
        }

        public ASTClassReference() {
            super(0);
            this.reference = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return (ISourceElementCallbackDelegate)((Object)this.reference);
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptClassReference(this);
            }
            catch (Exception exception) {}
        }

        public boolean isResolved() {
            return this.reference instanceof IASTClassSpecifier;
        }
    }

    public static class ASTEnumerationReference
    extends ASTReference
    implements IASTEnumerationReference {
        private IASTEnumerationSpecifier referencedElement;

        public ASTEnumerationReference(int offset, IASTEnumerationSpecifier specifier) {
            super(offset);
            this.referencedElement = specifier;
        }

        public ASTEnumerationReference() {
            super(0);
            this.referencedElement = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedElement;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptEnumerationReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate re) {
            this.initialize(o);
            this.referencedElement = (IASTEnumerationSpecifier)re;
        }

        public void reset() {
            super.resetOffset();
            this.referencedElement = null;
        }
    }

    public static class ASTEnumeratorReference
    extends ASTReference
    implements IASTEnumeratorReference {
        private IASTEnumerator enumerator;

        public ASTEnumeratorReference(int offset, IASTEnumerator enumerator) {
            super(offset);
            this.enumerator = enumerator;
        }

        public ASTEnumeratorReference() {
            super(0);
            this.enumerator = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.enumerator;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptEnumeratorReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            super.initialize(o);
            this.enumerator = (IASTEnumerator)referencedElement;
        }

        public void reset() {
            super.resetOffset();
            this.enumerator = null;
        }
    }

    public static class ASTFieldReference
    extends ASTReference
    implements IASTReference,
    IASTFieldReference {
        private IASTField referencedElement;

        public ASTFieldReference(int offset, IASTField field) {
            super(offset);
            this.referencedElement = field;
        }

        public ASTFieldReference() {
            super(0);
            this.referencedElement = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedElement;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptFieldReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate re) {
            this.initialize(o);
            this.referencedElement = (IASTField)re;
        }

        public void reset() {
            this.resetOffset();
            this.referencedElement = null;
        }
    }

    public static class ASTFunctionReference
    extends ASTReference
    implements IASTReference,
    IASTFunctionReference {
        private IASTFunction declaration;

        public ASTFunctionReference(int offset, IASTFunction referencedDeclaration) {
            super(offset);
            this.declaration = referencedDeclaration;
        }

        public ASTFunctionReference() {
            super(0);
            this.declaration = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.declaration;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptFunctionReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            super.initialize(o);
            this.declaration = (IASTFunction)referencedElement;
        }

        public void reset() {
            this.resetOffset();
            this.declaration = null;
        }
    }

    public static class ASTMethodReference
    extends ASTReference
    implements IASTMethodReference {
        private IASTMethod method;

        public ASTMethodReference(int offset, IASTMethod method) {
            super(offset);
            this.method = method;
        }

        public ASTMethodReference() {
            super(0);
            this.method = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.method;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptMethodReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            super.initialize(o);
            this.method = (IASTMethod)referencedElement;
        }

        public void reset() {
            this.resetOffset();
            this.method = null;
        }
    }

    public static class ASTNamespaceReference
    extends ASTReference
    implements IASTNamespaceReference {
        private IASTNamespaceDefinition reference;

        public ASTNamespaceReference(int offset, IASTNamespaceDefinition definition) {
            super(offset);
            this.reference = definition;
        }

        public ASTNamespaceReference() {
            super(0);
            this.reference = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.reference;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptNamespaceReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            super.initialize(o);
            this.reference = (IASTNamespaceDefinition)referencedElement;
        }

        public void reset() {
            this.resetOffset();
            this.reference = null;
        }
    }

    public static class ASTParameterReference
    extends ASTReference
    implements IASTParameterReference {
        private IASTParameterDeclaration parm;

        public ASTParameterReference(int offset, IASTParameterDeclaration declaration) {
            super(offset);
            this.parm = declaration;
        }

        public ASTParameterReference() {
            super(0);
            this.parm = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.parm;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptParameterReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            this.initialize(o);
            this.parm = (IASTParameterDeclaration)referencedElement;
        }

        public void reset() {
            this.resetOffset();
            this.parm = null;
        }
    }

    public static class ASTTemplateParameterReference
    extends ASTReference
    implements IASTTemplateParameterReference {
        private IASTTemplateParameter parameter;

        public ASTTemplateParameterReference(int offset, IASTTemplateParameter param) {
            super(offset);
            this.parameter = param;
        }

        public ASTTemplateParameterReference() {
            super(0);
            this.parameter = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.parameter;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptTemplateParameterReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            super.initialize(o);
            this.parameter = (IASTTemplateParameter)referencedElement;
        }

        public void reset() {
            this.resetOffset();
            this.parameter = null;
        }
    }

    public static class ASTTypedefReference
    extends ASTReference
    implements IASTTypedefReference {
        private IASTTypedefDeclaration referencedItem;

        public ASTTypedefReference(int offset, IASTTypedefDeclaration referencedItem) {
            super(offset);
            this.referencedItem = referencedItem;
        }

        public ASTTypedefReference() {
            super(0);
            this.referencedItem = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedItem;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptTypedefReference(this);
            }
            catch (Exception exception) {}
        }

        public void initialize(int o, ISourceElementCallbackDelegate referencedElement) {
            super.initialize(o);
            this.referencedItem = (IASTTypedefDeclaration)referencedElement;
        }

        public void reset() {
            super.resetOffset();
            this.referencedItem = null;
        }
    }

    public static class ASTVariableReference
    extends ASTReference
    implements IASTReference,
    IASTVariableReference {
        private IASTVariable referencedElement;

        public ASTVariableReference(int offset, IASTVariable variable) {
            super(offset);
            this.referencedElement = variable;
        }

        public void initialize(int o, ISourceElementCallbackDelegate var) {
            super.initialize(o);
            this.referencedElement = (IASTVariable)var;
        }

        public void reset() {
            super.resetOffset();
            this.referencedElement = null;
        }

        public ASTVariableReference() {
            super(0);
            this.referencedElement = null;
        }

        public ISourceElementCallbackDelegate getReferencedElement() {
            return this.referencedElement;
        }

        public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
            try {
                requestor.acceptVariableReference(this);
            }
            catch (Exception exception) {}
        }
    }
}

